/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;

public class RetryProcedure
extends BalanceProcedure {
    private int retryTime = 1;
    private int totalRetry = 0;

    public RetryProcedure() {
    }

    public RetryProcedure(String name, long delay, int retryTime) {
        super(name, delay);
        this.retryTime = retryTime;
    }

    public boolean execute() throws BalanceProcedure.RetryException {
        if (this.retryTime > 0) {
            --this.retryTime;
            ++this.totalRetry;
            throw new BalanceProcedure.RetryException();
        }
        return true;
    }

    public int getTotalRetry() {
        return this.totalRetry;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.retryTime);
        out.writeInt(this.totalRetry);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.retryTime = in.readInt();
        this.totalRetry = in.readInt();
    }
}

