/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.tools.ECAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileListingEntry;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistCpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestDistCpUtils.class);
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;
    private static final FsPermission fullPerm;
    private static final FsPermission almostFullPerm;
    private static final FsPermission noPerm;
    private static Random rand;

    @BeforeClass
    public static void create() throws IOException {
        config.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(2).format(true).build();
        cluster.getFileSystem().enableErasureCodingPolicy("XOR-2-1-1024k");
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testGetRelativePathRoot() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        Path root = new Path("/");
        Path child = new Path("/a");
        TestDistCpUtils.createFile(fs, child);
        FileListingEntry rootListing = new FileListingEntry();
        rootListing.setSourceRealPath(fs.getFileStatus(root));
        FileListingEntry childListing = new FileListingEntry();
        childListing.setSourceRealPath(fs.getFileStatus(root));
        childListing.setParent(rootListing);
        Assertions.assertThat((String)DistCpUtils.getRelativePath((FileListingEntry)childListing)).isEqualTo((Object)"/");
    }

    @Test
    public void testGetRelativePath() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        Path root = new Path("/tmp/abc123/xyz");
        Path child = new Path("/tmp/abc123/xyz/file");
        TestDistCpUtils.createFile(fs, child);
        FileListingEntry rootListing = new FileListingEntry();
        rootListing.setSourceRealPath(fs.getFileStatus(root));
        FileListingEntry childListing = new FileListingEntry();
        childListing.setSourceRealPath(fs.getFileStatus(root));
        childListing.setParent(rootListing);
        Assertions.assertThat((String)DistCpUtils.getRelativePath((FileListingEntry)childListing)).isEqualTo((Object)"/xyz/xyz");
    }

    @Test
    public void testPackAttributes() {
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"");
        attributes.add(DistCpOptions.FileAttribute.REPLICATION);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"R");
        attributes.add(DistCpOptions.FileAttribute.BLOCKSIZE);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"RB");
        attributes.add(DistCpOptions.FileAttribute.USER);
        attributes.add(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"RBUC");
        attributes.add(DistCpOptions.FileAttribute.GROUP);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"RBUGC");
        attributes.add(DistCpOptions.FileAttribute.PERMISSION);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"RBUGPC");
        attributes.add(DistCpOptions.FileAttribute.TIMES);
        Assertions.assertThat((String)DistCpUtils.packAttributes(attributes)).isEqualTo((Object)"RBUGPCT");
    }

    @Test
    public void testUnpackAttributes() {
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"RCBUGPAXTEH"));
        attributes.remove(DistCpOptions.FileAttribute.REPLICATION);
        attributes.remove(DistCpOptions.FileAttribute.CHECKSUMTYPE);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        attributes.remove(DistCpOptions.FileAttribute.XATTR);
        attributes.remove(DistCpOptions.FileAttribute.ERASURECODINGPOLICY);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"BUGPTH"));
        attributes.remove(DistCpOptions.FileAttribute.TIMES);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"BUGPH"));
        attributes.remove(DistCpOptions.FileAttribute.BLOCKSIZE);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"UGPH"));
        attributes.remove(DistCpOptions.FileAttribute.GROUP);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"UPH"));
        attributes.remove(DistCpOptions.FileAttribute.USER);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"PH"));
        attributes.remove(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertEquals(attributes, (Object)DistCpUtils.unpackAttributes((String)"H"));
    }

    @Test
    public void testPreserveDefaults() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet attributes = DistCpUtils.unpackAttributes((String)"-prbugpcteh".substring(1));
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, (EnumSet)attributes, (boolean)false);
        this.assertStatusEqual(fs, dst, srcStatus);
    }

    private void assertStatusEqual(FileSystem fs, Path dst, CopyListingFileStatus srcStatus) throws IOException {
        FileStatus destStatus = fs.getFileStatus(dst);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(destStatus);
        String text = String.format("Source %s; dest %s: wrong ", srcStatus, destStatus);
        Assert.assertEquals((String)(text + "permission"), (Object)srcStatus.getPermission(), (Object)dstStatus.getPermission());
        Assert.assertEquals((String)(text + "owner"), (Object)srcStatus.getOwner(), (Object)dstStatus.getOwner());
        Assert.assertEquals((String)(text + "group"), (Object)srcStatus.getGroup(), (Object)dstStatus.getGroup());
        Assert.assertEquals((String)(text + "accessTime"), (long)srcStatus.getAccessTime(), (long)dstStatus.getAccessTime());
        Assert.assertEquals((String)(text + "modificationTime"), (long)srcStatus.getModificationTime(), (long)dstStatus.getModificationTime());
        Assert.assertEquals((String)(text + "replication"), (long)srcStatus.getReplication(), (long)dstStatus.getReplication());
    }

    private void assertStatusNotEqual(FileSystem fs, Path dst, CopyListingFileStatus srcStatus) throws IOException {
        FileStatus destStatus = fs.getFileStatus(dst);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(destStatus);
        String text = String.format("Source %s; dest %s: wrong ", srcStatus, destStatus);
        Assert.assertNotEquals((String)(text + "permission"), (Object)srcStatus.getPermission(), (Object)dstStatus.getPermission());
        Assert.assertNotEquals((String)(text + "owner"), (Object)srcStatus.getOwner(), (Object)dstStatus.getOwner());
        Assert.assertNotEquals((String)(text + "group"), (Object)srcStatus.getGroup(), (Object)dstStatus.getGroup());
        Assert.assertNotEquals((String)(text + "accessTime"), (long)srcStatus.getAccessTime(), (long)dstStatus.getAccessTime());
        Assert.assertNotEquals((String)(text + "modificationTime"), (long)srcStatus.getModificationTime(), (long)dstStatus.getModificationTime());
        Assert.assertNotEquals((String)(text + "replication"), (long)srcStatus.getReplication(), (long)dstStatus.getReplication());
    }

    @Test
    public void testSkipsNeedlessAttributes() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)config);
        Path src = new Path("/tmp/testSkipsNeedlessAttributes/source");
        Path dst = new Path("/tmp/testSkipsNeedlessAttributes/dest");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(new FileStatus(0L, false, 1, 32L, 0L, src));
        EnumSet<DistCpOptions.FileAttribute> attrs = EnumSet.of(DistCpOptions.FileAttribute.ACL, DistCpOptions.FileAttribute.GROUP, DistCpOptions.FileAttribute.PERMISSION, DistCpOptions.FileAttribute.TIMES, DistCpOptions.FileAttribute.XATTR);
        for (DistCpOptions.FileAttribute attr : attrs) {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, EnumSet.of(attr), (boolean)false));
        }
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, EnumSet.of(DistCpOptions.FileAttribute.BLOCKSIZE, DistCpOptions.FileAttribute.CHECKSUMTYPE), (boolean)false);
    }

    @Test
    public void testPreserveAclsforDefaultACL() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute[]> attributes = EnumSet.of(DistCpOptions.FileAttribute.ACL, new DistCpOptions.FileAttribute[]{DistCpOptions.FileAttribute.PERMISSION, DistCpOptions.FileAttribute.XATTR, DistCpOptions.FileAttribute.GROUP, DistCpOptions.FileAttribute.USER, DistCpOptions.FileAttribute.REPLICATION, DistCpOptions.FileAttribute.XATTR, DistCpOptions.FileAttribute.TIMES});
        Path dest = new Path("/tmpdest");
        Path src = new Path("/testsrc");
        fs.mkdirs(src);
        fs.mkdirs(dest);
        ArrayList acls = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.DEFAULT, (AclEntryType)AclEntryType.USER, (String)"foo", (FsAction)FsAction.READ_EXECUTE), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (FsAction)FsAction.READ_WRITE), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (FsAction)FsAction.READ), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.OTHER, (FsAction)FsAction.READ), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (String)"bar", (FsAction)FsAction.ALL)});
        ArrayList acls1 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (FsAction)FsAction.ALL), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.USER, (String)"user1", (FsAction)FsAction.ALL), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.GROUP, (FsAction)FsAction.READ_EXECUTE), AclTestHelpers.aclEntry((AclEntryScope)AclEntryScope.ACCESS, (AclEntryType)AclEntryType.OTHER, (FsAction)FsAction.EXECUTE)});
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setAcl(src, (List)acls);
        fs.setPermission(dest, noPerm);
        fs.setOwner(dest, "nobody", "nobody-group");
        fs.setTimes(dest, 100L, 100L);
        fs.setReplication(dest, (short)2);
        fs.setAcl(dest, (List)acls1);
        List en1 = fs.getAclStatus(src).getEntries();
        List dd2 = fs.getAclStatus(dest).getEntries();
        Assert.assertNotEquals((Object)en1, (Object)dd2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        en1 = srcStatus.getAclEntries();
        DistCpUtils.preserve((FileSystem)fs, (Path)dest, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dest));
        dd2 = dstStatus.getAclEntries();
        en1 = srcStatus.getAclEntries();
        this.assertStatusEqual(fs, dest, srcStatus);
        Assert.assertArrayEquals((Object[])en1.toArray(), (Object[])dd2.toArray());
    }

    @Test
    public void testPreserveNothingOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((dstStatus.getAccessTime() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((dstStatus.getModificationTime() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((dstStatus.getReplication() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPreservePermissionOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.PERMISSION);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveGroupOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.GROUP);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveUserOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.USER);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
    }

    @Test
    public void testPreserveReplicationOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveTimestampOnDirectory() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.TIMES);
        Path dst = new Path("/tmp/abc");
        Path src = new Path("/tmp/src");
        TestDistCpUtils.createDirectory(fs, src);
        TestDistCpUtils.createDirectory(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveNothingOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        this.assertStatusNotEqual(fs, dst, srcStatus);
    }

    @Test
    public void testPreservePermissionOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.PERMISSION);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveGroupOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.GROUP);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveUserOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.USER);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveReplicationOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testReplFactorNotPreservedOnErasureCodedFile() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)config);
        Path srcECDir = new Path("/tmp/srcECDir");
        Path srcECFile = new Path(srcECDir, "srcECFile");
        Path dstReplDir = new Path("/tmp/dstReplDir");
        Path dstReplFile = new Path(dstReplDir, "destReplFile");
        fs.mkdirs(srcECDir);
        fs.mkdirs(dstReplDir);
        String[] args = new String[]{"-setPolicy", "-path", "/tmp/srcECDir", "-policy", "XOR-2-1-1024k"};
        int res = ToolRunner.run((Configuration)config, (Tool)new ECAdmin(config), (String[])args);
        Assert.assertEquals((String)"Setting EC policy should succeed!", (long)0L, (long)res);
        this.verifyReplFactorNotPreservedOnErasureCodedFile(srcECFile, true, dstReplFile, false);
        Path srcReplDir = new Path("/tmp/srcReplDir");
        Path srcReplFile = new Path(srcReplDir, "srcReplFile");
        Path dstECDir = new Path("/tmp/dstECDir");
        Path dstECFile = new Path(dstECDir, "destECFile");
        fs.mkdirs(srcReplDir);
        fs.mkdirs(dstECDir);
        args = new String[]{"-setPolicy", "-path", "/tmp/dstECDir", "-policy", "XOR-2-1-1024k"};
        res = ToolRunner.run((Configuration)config, (Tool)new ECAdmin(config), (String[])args);
        Assert.assertEquals((String)"Setting EC policy should succeed!", (long)0L, (long)res);
        this.verifyReplFactorNotPreservedOnErasureCodedFile(srcReplFile, false, dstECFile, true);
        this.verifyReplFactorNotPreservedOnErasureCodedFile(srcECFile, true, dstECFile, true);
    }

    private void verifyReplFactorNotPreservedOnErasureCodedFile(Path srcFile, boolean isSrcEC, Path dstFile, boolean isDstEC) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)config);
        TestDistCpUtils.createFile(fs, srcFile);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(srcFile));
        if (isSrcEC) {
            Assert.assertTrue((String)(srcFile + "should be erasure coded!"), (boolean)srcStatus.isErasureCoded());
            Assert.assertEquals((long)1L, (long)srcStatus.getReplication());
        } else {
            Assert.assertEquals((String)("Unexpected replication factor for " + srcFile), (long)fs.getDefaultReplication(srcFile), (long)srcStatus.getReplication());
        }
        TestDistCpUtils.createFile(fs, dstFile);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dstFile));
        if (isDstEC) {
            Assert.assertTrue((String)(dstFile + "should be erasure coded!"), (boolean)dstStatus.isErasureCoded());
            Assert.assertEquals((String)"Unexpected replication factor for erasure coded file!", (long)1L, (long)dstStatus.getReplication());
        } else {
            Assert.assertEquals((String)("Unexpected replication factor for " + dstFile), (long)fs.getDefaultReplication(dstFile), (long)dstStatus.getReplication());
        }
        fs.setPermission(srcFile, fullPerm);
        fs.setOwner(srcFile, "ec", "ec-group");
        fs.setTimes(srcFile, 0L, 0L);
        fs.setPermission(dstFile, noPerm);
        fs.setOwner(dstFile, "normal", "normal-group");
        fs.setTimes(dstFile, 100L, 100L);
        srcStatus = new CopyListingFileStatus(fs.getFileStatus(srcFile));
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.REPLICATION);
        DistCpUtils.preserve((FileSystem)fs, (Path)dstFile, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        dstStatus = new CopyListingFileStatus(fs.getFileStatus(dstFile));
        Assert.assertFalse((String)("Permission for " + srcFile + " and " + dstFile + " should not be same after preserve only for replication attr!"), (boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((String)"File ownership should not match!", (boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        if (isDstEC) {
            Assert.assertEquals((String)"Unexpected replication factor for erasure coded file!", (long)1L, (long)dstStatus.getReplication());
        } else {
            Assert.assertEquals((String)(dstFile + " replication factor should be same as dst filesystem!"), (long)fs.getDefaultReplication(dstFile), (long)dstStatus.getReplication());
        }
        if (!isSrcEC || !isDstEC) {
            Assert.assertFalse((String)(dstFile + " replication factor should not be same as " + srcFile), (srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPreserveTimestampOnFile() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.of(DistCpOptions.FileAttribute.TIMES);
        Path dst = new Path("/tmp/dest2");
        Path src = new Path("/tmp/src2");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, dst);
        fs.setPermission(src, fullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(dst, noPerm);
        fs.setOwner(dst, "nobody", "nobody-group");
        fs.setTimes(dst, 100L, 100L);
        fs.setReplication(dst, (short)2);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)dst, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        CopyListingFileStatus dstStatus = new CopyListingFileStatus(fs.getFileStatus(dst));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)dstStatus.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(dstStatus.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(dstStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == dstStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == dstStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == dstStatus.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveOnFileUpwardRecursion() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        Path src = new Path("/tmp/src2");
        Path f0 = new Path("/f0");
        Path f1 = new Path("/d1/f1");
        Path f2 = new Path("/d1/d2/f2");
        Path d1 = new Path("/d1/");
        Path d2 = new Path("/d1/d2/");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, f0);
        TestDistCpUtils.createFile(fs, f1);
        TestDistCpUtils.createFile(fs, f2);
        fs.setPermission(src, almostFullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(d1, fullPerm);
        fs.setOwner(d1, "anybody", "anybody-group");
        fs.setTimes(d1, 400L, 400L);
        fs.setReplication(d1, (short)3);
        fs.setPermission(d2, fullPerm);
        fs.setOwner(d2, "anybody", "anybody-group");
        fs.setTimes(d2, 300L, 300L);
        fs.setReplication(d2, (short)3);
        fs.setPermission(f0, fullPerm);
        fs.setOwner(f0, "anybody", "anybody-group");
        fs.setTimes(f0, 200L, 200L);
        fs.setReplication(f0, (short)3);
        fs.setPermission(f1, fullPerm);
        fs.setOwner(f1, "anybody", "anybody-group");
        fs.setTimes(f1, 200L, 200L);
        fs.setReplication(f1, (short)3);
        fs.setPermission(f2, fullPerm);
        fs.setOwner(f2, "anybody", "anybody-group");
        fs.setTimes(f2, 200L, 200L);
        fs.setReplication(f2, (short)3);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)f2, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        cluster.triggerHeartbeats();
        this.assertStatusEqual(fs, f2, srcStatus);
        CopyListingFileStatus f1Status = new CopyListingFileStatus(fs.getFileStatus(f1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f0Status = new CopyListingFileStatus(fs.getFileStatus(f0));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f0Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f0Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f0Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f0Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f0Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f0Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d2Status = new CopyListingFileStatus(fs.getFileStatus(d2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d2Status.getGroup()));
        Assert.assertTrue((d2Status.getAccessTime() == 300L ? 1 : 0) != 0);
        Assert.assertTrue((d2Status.getModificationTime() == 300L ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == d2Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d1Status = new CopyListingFileStatus(fs.getFileStatus(d1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d1Status.getGroup()));
        Assert.assertTrue((d1Status.getAccessTime() == 400L ? 1 : 0) != 0);
        Assert.assertTrue((d1Status.getModificationTime() == 400L ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == d1Status.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveOnDirectoryUpwardRecursion() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        Path src = new Path("/tmp/src2");
        Path f0 = new Path("/f0");
        Path f1 = new Path("/d1/f1");
        Path f2 = new Path("/d1/d2/f2");
        Path d1 = new Path("/d1/");
        Path d2 = new Path("/d1/d2/");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, f0);
        TestDistCpUtils.createFile(fs, f1);
        TestDistCpUtils.createFile(fs, f2);
        fs.setPermission(src, almostFullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(d1, fullPerm);
        fs.setOwner(d1, "anybody", "anybody-group");
        fs.setTimes(d1, 400L, 400L);
        fs.setReplication(d1, (short)3);
        fs.setPermission(d2, fullPerm);
        fs.setOwner(d2, "anybody", "anybody-group");
        fs.setTimes(d2, 300L, 300L);
        fs.setReplication(d2, (short)3);
        fs.setPermission(f0, fullPerm);
        fs.setOwner(f0, "anybody", "anybody-group");
        fs.setTimes(f0, 200L, 200L);
        fs.setReplication(f0, (short)3);
        fs.setPermission(f1, fullPerm);
        fs.setOwner(f1, "anybody", "anybody-group");
        fs.setTimes(f1, 200L, 200L);
        fs.setReplication(f1, (short)3);
        fs.setPermission(f2, fullPerm);
        fs.setOwner(f2, "anybody", "anybody-group");
        fs.setTimes(f2, 200L, 200L);
        fs.setReplication(f2, (short)3);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)d2, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        cluster.triggerHeartbeats();
        CopyListingFileStatus d2Status = new CopyListingFileStatus(fs.getFileStatus(d2));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)d2Status.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(d2Status.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(d2Status.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == d2Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == d2Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() != d2Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d1Status = new CopyListingFileStatus(fs.getFileStatus(d1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == d1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == d1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() != d1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f2Status = new CopyListingFileStatus(fs.getFileStatus(f2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f2Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f2Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f2Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f2Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f1Status = new CopyListingFileStatus(fs.getFileStatus(f1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f0Status = new CopyListingFileStatus(fs.getFileStatus(f0));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f0Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f0Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f0Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f0Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f0Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f0Status.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveOnFileDownwardRecursion() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        Path src = new Path("/tmp/src2");
        Path f0 = new Path("/f0");
        Path f1 = new Path("/d1/f1");
        Path f2 = new Path("/d1/d2/f2");
        Path d1 = new Path("/d1/");
        Path d2 = new Path("/d1/d2/");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, f0);
        TestDistCpUtils.createFile(fs, f1);
        TestDistCpUtils.createFile(fs, f2);
        fs.setPermission(src, almostFullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(d1, fullPerm);
        fs.setOwner(d1, "anybody", "anybody-group");
        fs.setTimes(d1, 400L, 400L);
        fs.setReplication(d1, (short)3);
        fs.setPermission(d2, fullPerm);
        fs.setOwner(d2, "anybody", "anybody-group");
        fs.setTimes(d2, 300L, 300L);
        fs.setReplication(d2, (short)3);
        fs.setPermission(f0, fullPerm);
        fs.setOwner(f0, "anybody", "anybody-group");
        fs.setTimes(f0, 200L, 200L);
        fs.setReplication(f0, (short)3);
        fs.setPermission(f1, fullPerm);
        fs.setOwner(f1, "anybody", "anybody-group");
        fs.setTimes(f1, 200L, 200L);
        fs.setReplication(f1, (short)3);
        fs.setPermission(f2, fullPerm);
        fs.setOwner(f2, "anybody", "anybody-group");
        fs.setTimes(f2, 200L, 200L);
        fs.setReplication(f2, (short)3);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)f0, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        cluster.triggerHeartbeats();
        this.assertStatusEqual(fs, f0, srcStatus);
        CopyListingFileStatus f1Status = new CopyListingFileStatus(fs.getFileStatus(f1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f2Status = new CopyListingFileStatus(fs.getFileStatus(f2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f2Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f2Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f2Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f2Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d1Status = new CopyListingFileStatus(fs.getFileStatus(d1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d1Status.getGroup()));
        Assert.assertTrue((d1Status.getAccessTime() == 400L ? 1 : 0) != 0);
        Assert.assertTrue((d1Status.getModificationTime() == 400L ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == d1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d2Status = new CopyListingFileStatus(fs.getFileStatus(d2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d2Status.getGroup()));
        Assert.assertTrue((d2Status.getAccessTime() == 300L ? 1 : 0) != 0);
        Assert.assertTrue((d2Status.getModificationTime() == 300L ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == d2Status.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testPreserveOnDirectoryDownwardRecursion() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)config);
        EnumSet<DistCpOptions.FileAttribute> attributes = EnumSet.allOf(DistCpOptions.FileAttribute.class);
        attributes.remove(DistCpOptions.FileAttribute.ACL);
        Path src = new Path("/tmp/src2");
        Path f0 = new Path("/f0");
        Path f1 = new Path("/d1/f1");
        Path f2 = new Path("/d1/d2/f2");
        Path d1 = new Path("/d1/");
        Path d2 = new Path("/d1/d2/");
        Path root = new Path("/");
        TestDistCpUtils.createFile(fs, src);
        TestDistCpUtils.createFile(fs, f0);
        TestDistCpUtils.createFile(fs, f1);
        TestDistCpUtils.createFile(fs, f2);
        fs.setPermission(src, almostFullPerm);
        fs.setOwner(src, "somebody", "somebody-group");
        fs.setTimes(src, 0L, 0L);
        fs.setReplication(src, (short)1);
        fs.setPermission(root, fullPerm);
        fs.setOwner(root, "anybody", "anybody-group");
        fs.setTimes(root, 400L, 400L);
        fs.setReplication(root, (short)3);
        fs.setPermission(d1, fullPerm);
        fs.setOwner(d1, "anybody", "anybody-group");
        fs.setTimes(d1, 400L, 400L);
        fs.setReplication(d1, (short)3);
        fs.setPermission(d2, fullPerm);
        fs.setOwner(d2, "anybody", "anybody-group");
        fs.setTimes(d2, 300L, 300L);
        fs.setReplication(d2, (short)3);
        fs.setPermission(f0, fullPerm);
        fs.setOwner(f0, "anybody", "anybody-group");
        fs.setTimes(f0, 200L, 200L);
        fs.setReplication(f0, (short)3);
        fs.setPermission(f1, fullPerm);
        fs.setOwner(f1, "anybody", "anybody-group");
        fs.setTimes(f1, 200L, 200L);
        fs.setReplication(f1, (short)3);
        fs.setPermission(f2, fullPerm);
        fs.setOwner(f2, "anybody", "anybody-group");
        fs.setTimes(f2, 200L, 200L);
        fs.setReplication(f2, (short)3);
        CopyListingFileStatus srcStatus = new CopyListingFileStatus(fs.getFileStatus(src));
        DistCpUtils.preserve((FileSystem)fs, (Path)root, (CopyListingFileStatus)srcStatus, attributes, (boolean)false);
        cluster.triggerHeartbeats();
        CopyListingFileStatus rootStatus = new CopyListingFileStatus(fs.getFileStatus(root));
        Assert.assertTrue((boolean)srcStatus.getPermission().equals((Object)rootStatus.getPermission()));
        Assert.assertTrue((boolean)srcStatus.getOwner().equals(rootStatus.getOwner()));
        Assert.assertTrue((boolean)srcStatus.getGroup().equals(rootStatus.getGroup()));
        Assert.assertTrue((srcStatus.getAccessTime() == rootStatus.getAccessTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getModificationTime() == rootStatus.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() != rootStatus.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d1Status = new CopyListingFileStatus(fs.getFileStatus(d1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == d1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == d1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() != d1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus d2Status = new CopyListingFileStatus(fs.getFileStatus(d2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)d2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(d2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(d2Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == d2Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == d2Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertTrue((srcStatus.getReplication() != d2Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f0Status = new CopyListingFileStatus(fs.getFileStatus(f0));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f0Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f0Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f0Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f0Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f0Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f0Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f1Status = new CopyListingFileStatus(fs.getFileStatus(f1));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f1Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f1Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f1Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f1Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f1Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f1Status.getReplication() ? 1 : 0) != 0);
        CopyListingFileStatus f2Status = new CopyListingFileStatus(fs.getFileStatus(f2));
        Assert.assertFalse((boolean)srcStatus.getPermission().equals((Object)f2Status.getPermission()));
        Assert.assertFalse((boolean)srcStatus.getOwner().equals(f2Status.getOwner()));
        Assert.assertFalse((boolean)srcStatus.getGroup().equals(f2Status.getGroup()));
        Assert.assertFalse((srcStatus.getAccessTime() == f2Status.getAccessTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getModificationTime() == f2Status.getModificationTime() ? 1 : 0) != 0);
        Assert.assertFalse((srcStatus.getReplication() == f2Status.getReplication() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareFileLengthsAndChecksums() throws Throwable {
        String base = "/tmp/verify-checksum/";
        long srcSeed = System.currentTimeMillis();
        long dstSeed = srcSeed + rand.nextLong();
        short replFactor = 2;
        FileSystem fs = FileSystem.get((Configuration)config);
        Path basePath = new Path(base);
        fs.mkdirs(basePath);
        Path srcWithLen0 = new Path(base + "srcLen0");
        Path dstWithLen0 = new Path(base + "dstLen0");
        fs.create(srcWithLen0).close();
        fs.create(dstWithLen0).close();
        DistCpUtils.compareFileLengthsAndChecksums((long)0L, (FileSystem)fs, (Path)srcWithLen0, null, (FileSystem)fs, (Path)dstWithLen0, (boolean)false, (long)0L);
        Path srcWithLen1 = new Path(base + "srcLen1");
        Path dstWithLen2 = new Path(base + "dstLen2");
        DFSTestUtil.createFile((FileSystem)fs, (Path)srcWithLen1, (long)1L, (short)replFactor, (long)srcSeed);
        DFSTestUtil.createFile((FileSystem)fs, (Path)dstWithLen2, (long)2L, (short)replFactor, (long)srcSeed);
        LambdaTestUtils.intercept(IOException.class, (String)"Mismatch in length of source:", () -> DistCpUtils.compareFileLengthsAndChecksums((long)1L, (FileSystem)fs, (Path)srcWithLen1, null, (FileSystem)fs, (Path)dstWithLen2, (boolean)false, (long)2L));
        Path srcWithChecksum1 = new Path(base + "srcChecksum1");
        Path dstWithChecksum1 = new Path(base + "dstChecksum1");
        DFSTestUtil.createFile((FileSystem)fs, (Path)srcWithChecksum1, (long)1024L, (short)replFactor, (long)srcSeed);
        DFSTestUtil.createFile((FileSystem)fs, (Path)dstWithChecksum1, (long)1024L, (short)replFactor, (long)srcSeed);
        DistCpUtils.compareFileLengthsAndChecksums((long)1024L, (FileSystem)fs, (Path)srcWithChecksum1, null, (FileSystem)fs, (Path)dstWithChecksum1, (boolean)false, (long)1024L);
        DistCpUtils.compareFileLengthsAndChecksums((long)1024L, (FileSystem)fs, (Path)srcWithChecksum1, (FileChecksum)fs.getFileChecksum(srcWithChecksum1), (FileSystem)fs, (Path)dstWithChecksum1, (boolean)false, (long)1024L);
        Path dstWithChecksum2 = new Path(base + "dstChecksum2");
        DFSTestUtil.createFile((FileSystem)fs, (Path)dstWithChecksum2, (long)1024L, (short)replFactor, (long)dstSeed);
        LambdaTestUtils.intercept(IOException.class, (String)"Checksum mismatch between ", () -> DistCpUtils.compareFileLengthsAndChecksums((long)1024L, (FileSystem)fs, (Path)srcWithChecksum1, null, (FileSystem)fs, (Path)dstWithChecksum2, (boolean)false, (long)1024L));
        DistCpUtils.compareFileLengthsAndChecksums((long)1024L, (FileSystem)fs, (Path)srcWithChecksum1, null, (FileSystem)fs, (Path)dstWithChecksum2, (boolean)true, (long)1024L);
    }

    public static String createTestSetup(FileSystem fs) throws IOException {
        return TestDistCpUtils.createTestSetup("/tmp1", fs, FsPermission.getDefault());
    }

    public static String createTestSetup(FileSystem fs, FsPermission perm) throws IOException {
        return TestDistCpUtils.createTestSetup("/tmp1", fs, perm);
    }

    public static String createTestSetup(String baseDir, FileSystem fs, FsPermission perm) throws IOException {
        String base = TestDistCpUtils.getBase(baseDir);
        fs.mkdirs(new Path(base + "/newTest/hello/world1"));
        fs.mkdirs(new Path(base + "/newTest/hello/world2/newworld"));
        fs.mkdirs(new Path(base + "/newTest/hello/world3/oldworld"));
        fs.setPermission(new Path(base + "/newTest"), perm);
        fs.setPermission(new Path(base + "/newTest/hello"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world1"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world2/newworld"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3"), perm);
        fs.setPermission(new Path(base + "/newTest/hello/world3/oldworld"), perm);
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/1"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/2"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/world3/oldworld/3"));
        TestDistCpUtils.createFile(fs, new Path(base, "/newTest/hello/world2/4"));
        return base;
    }

    private static String getBase(String base) {
        String location = String.valueOf(rand.nextLong());
        return base + "/" + location;
    }

    public static String createTestSetupWithOnlyFile(FileSystem fs, FsPermission perm) throws IOException {
        String location = String.valueOf(rand.nextLong());
        fs.mkdirs(new Path("/tmp1/" + location));
        fs.setPermission(new Path("/tmp1/" + location), perm);
        TestDistCpUtils.createFile(fs, new Path("/tmp1/" + location + "/file"));
        return "/tmp1/" + location + "/file";
    }

    public static void delete(FileSystem fs, String path) {
        try {
            if (fs != null && path != null) {
                fs.delete(new Path(path), true);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception encountered ", (Throwable)e);
        }
    }

    public static void createFile(FileSystem fs, String filePath) throws IOException {
        Path path = new Path(filePath);
        TestDistCpUtils.createFile(fs, path);
    }

    public static void createFile(FileSystem fs, Path filePath) throws IOException {
        FSDataOutputStream out = fs.create(filePath, true);
        IOUtils.closeStream((Closeable)out);
    }

    public static void createDirectory(FileSystem fs, Path dirPath) throws IOException {
        fs.delete(dirPath, true);
        boolean created = fs.mkdirs(dirPath);
        if (!created) {
            LOG.warn("Could not create directory " + dirPath + " this might cause test failures.");
        }
    }

    public static void verifyFoldersAreInSync(FileSystem fs, String targetBase, String sourceBase) throws IOException {
        Path base = new Path(targetBase);
        Stack<Path> stack = new Stack<Path>();
        stack.push(base);
        while (!stack.isEmpty()) {
            FileStatus[] fStatus;
            Path file = (Path)stack.pop();
            if (!fs.exists(file) || (fStatus = fs.listStatus(file)) == null || fStatus.length == 0) continue;
            for (FileStatus status : fStatus) {
                if (status.isDirectory()) {
                    stack.push(status.getPath());
                }
                FileListingEntry targetBaseListingEntry = DistCpUtils.pathToFileListingEntry((Path)new Path(targetBase), (FileSystem)fs);
                FileListingEntry statusListingEntry = DistCpUtils.pathToFileListingEntry((Path)status.getPath(), (FileSystem)fs);
                Path p = new Path(sourceBase + "/" + DistCpUtils.getRelativePath((FileListingEntry)targetBaseListingEntry, (FileListingEntry)statusListingEntry));
                ContractTestUtils.assertPathExists((FileSystem)fs, (String)("path in sync with " + status.getPath()), (Path)p);
            }
        }
    }

    static {
        fullPerm = new FsPermission(777);
        almostFullPerm = new FsPermission(666);
        noPerm = new FsPermission(0);
        rand = new Random();
    }
}

