/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.SimpleCopyListing;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestCopyListing
extends SimpleCopyListing {
    private static final Logger LOG = LoggerFactory.getLogger(TestCopyListing.class);
    private static final Credentials CREDENTIALS = new Credentials();
    private static final Configuration config = new Configuration();
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void create() throws IOException {
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{1}, {2}, {10}, {20}};
        return Arrays.asList(data);
    }

    public TestCopyListing(int numListstatusThreads) {
        super(config, CREDENTIALS, numListstatusThreads, 0, false);
    }

    protected TestCopyListing(Configuration configuration) {
        super(configuration, CREDENTIALS);
    }

    protected long getBytesToCopy() {
        return 0L;
    }

    protected long getNumberOfPaths() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testMultipleSrcToFile() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            srcPaths.add(new Path("/tmp/in/1"));
            srcPaths.add(new Path("/tmp/in/2"));
            Path target = new Path("/tmp/out/1");
            TestDistCpUtils.createFile(fs, "/tmp/in/1");
            TestDistCpUtils.createFile(fs, "/tmp/in/2");
            fs.mkdirs(target);
            DistCpOptions options = new DistCpOptions.Builder(srcPaths, target).build();
            this.validatePaths(new DistCpContext(options));
            TestDistCpUtils.delete(fs, "/tmp");
            fs.create(target).close();
            try {
                this.validatePaths(new DistCpContext(options));
                Assert.fail((String)"Invalid inputs accepted");
            }
            catch (CopyListing.InvalidInputException invalidInputException) {
                // empty catch block
            }
            TestDistCpUtils.delete(fs, "/tmp");
            srcPaths.clear();
            srcPaths.add(new Path("/tmp/in/1"));
            fs.mkdirs(new Path("/tmp/in/1"));
            fs.create(target).close();
            try {
                this.validatePaths(new DistCpContext(options));
                Assert.fail((String)"Invalid inputs accepted");
            }
            catch (CopyListing.InvalidInputException invalidInputException) {
                // empty catch block
            }
            TestDistCpUtils.delete(fs, "/tmp");
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
            Assert.fail((String)"Test input validation failed");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDuplicates() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            srcPaths.add(new Path("/tmp/in/*/*"));
            TestDistCpUtils.createFile(fs, "/tmp/in/src1/1.txt");
            TestDistCpUtils.createFile(fs, "/tmp/in/src2/1.txt");
            Path target = new Path("/tmp/out");
            Path listingFile = new Path("/tmp/list");
            DistCpOptions options = new DistCpOptions.Builder(srcPaths, target).build();
            DistCpContext context = new DistCpContext(options);
            CopyListing listing = CopyListing.getCopyListing((Configuration)this.getConf(), (Credentials)CREDENTIALS, (DistCpContext)context);
            try {
                listing.buildListing(listingFile, context);
                Assert.fail((String)"Duplicates not detected");
            }
            catch (CopyListing.DuplicateFileException duplicateFileException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            LOG.error("Exception encountered in test", (Throwable)e);
            Assert.fail((String)("Test failed " + e.getMessage()));
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateSourcePaths() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        ArrayList<Path> srcPaths = new ArrayList<Path>();
        try {
            srcPaths.add(new Path("/tmp/in"));
            srcPaths.add(new Path("/tmp/in"));
            TestDistCpUtils.createFile(fs, "/tmp/in/src1/1.txt");
            TestDistCpUtils.createFile(fs, "/tmp/in/src2/1.txt");
            Path target = new Path("/tmp/out");
            Path listingFile = new Path("/tmp/list");
            DistCpOptions options = new DistCpOptions.Builder(srcPaths, target).build();
            DistCpContext context = new DistCpContext(options);
            CopyListing listing = CopyListing.getCopyListing((Configuration)this.getConf(), (Credentials)CREDENTIALS, (DistCpContext)context);
            listing.buildListing(listingFile, context);
            Assert.assertTrue((boolean)fs.exists(listingFile));
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testBuildListing() {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            Path p1 = new Path("/tmp/in/1");
            Path p2 = new Path("/tmp/in/2");
            Path p3 = new Path("/tmp/in2/2");
            Path target = new Path("/tmp/out/1");
            srcPaths.add(p1.getParent());
            srcPaths.add(p3.getParent());
            TestDistCpUtils.createFile(fs, "/tmp/in/1");
            TestDistCpUtils.createFile(fs, "/tmp/in/2");
            TestDistCpUtils.createFile(fs, "/tmp/in2/2");
            fs.mkdirs(target);
            FSDataOutputStream out = fs.create(p1);
            out.write("ABC".getBytes());
            out.close();
            out = fs.create(p2);
            out.write("DEF".getBytes());
            out.close();
            out = fs.create(p3);
            out.write("GHIJ".getBytes());
            out.close();
            Path listingFile = new Path("/tmp/file");
            DistCpOptions options = new DistCpOptions.Builder(srcPaths, target).withSyncFolder(true).build();
            SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
            try {
                listing.buildListing(listingFile, new DistCpContext(options));
                Assert.fail((String)"Duplicates not detected");
            }
            catch (CopyListing.DuplicateFileException duplicateFileException) {
                // empty catch block
            }
            Assertions.assertThat((long)listing.getBytesToCopy()).isEqualTo(10L);
            Assertions.assertThat((long)listing.getNumberOfPaths()).isEqualTo(3L);
            TestDistCpUtils.delete(fs, "/tmp");
            try {
                listing.buildListing(listingFile, new DistCpContext(options));
                Assert.fail((String)"Invalid input not detected");
            }
            catch (CopyListing.InvalidInputException invalidInputException) {
                // empty catch block
            }
            TestDistCpUtils.delete(fs, "/tmp");
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
            Assert.fail((String)"Test build listing failed");
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testWithRandomFileListing() throws IOException {
        FileSystem fs = null;
        try {
            fs = FileSystem.get((Configuration)this.getConf());
            ArrayList<Path> srcPaths = new ArrayList<Path>();
            ArrayList<Path> srcFiles = new ArrayList<Path>();
            Path target = new Path("/tmp/out/1");
            int pathCount = 25;
            for (int i = 0; i < 25; ++i) {
                Path p = new Path("/tmp", String.valueOf(i));
                srcPaths.add(p);
                fs.mkdirs(p);
                Path fileName = new Path(p, i + ".txt");
                srcFiles.add(fileName);
                try (FSDataOutputStream out = fs.create(fileName);){
                    out.write(i);
                    continue;
                }
            }
            Path listingFile = new Path("/tmp/file");
            DistCpOptions options = new DistCpOptions.Builder(srcPaths, target).withSyncFolder(true).build();
            this.getConf().setBoolean("distcp.simplelisting.randomize.files", false);
            SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
            listing.buildListing(listingFile, new DistCpContext(options));
            Assert.assertEquals((long)listing.getNumberOfPaths(), (long)25L);
            this.validateFinalListing(listingFile, srcFiles);
            fs.delete(listingFile, true);
            this.getConf().setBoolean("distcp.simplelisting.randomize.files", true);
            listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
            long seed = System.nanoTime();
            listing.setSeedForRandomListing(seed);
            listing.buildListing(listingFile, new DistCpContext(options));
            Assert.assertEquals((long)listing.getNumberOfPaths(), (long)25L);
            Collections.shuffle(srcFiles, new Random(seed));
            this.validateFinalListing(listingFile, srcFiles);
        }
        finally {
            TestDistCpUtils.delete(fs, "/tmp");
        }
    }

    private void validateFinalListing(Path pathToListFile, List<Path> srcFiles) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(config);
        try (SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)pathToListFile)});){
            CopyListingFileStatus currentVal = new CopyListingFileStatus();
            Text currentKey = new Text();
            int idx = 0;
            while (reader.next((Writable)currentKey)) {
                reader.getCurrentValue((Writable)currentVal);
                Assert.assertEquals((String)("srcFiles.size=" + srcFiles.size() + ", idx=" + idx), (Object)fs.makeQualified(srcFiles.get(idx)), (Object)currentVal.getPath());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("val=" + fs.makeQualified(srcFiles.get(idx)));
                }
                ++idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuildListingForSingleFile() {
        block6: {
            FileSystem fs = null;
            String testRootString = "/singleFileListing";
            Path testRoot = new Path(testRootString);
            SequenceFile.Reader reader = null;
            try {
                fs = FileSystem.get((Configuration)this.getConf());
                if (fs.exists(testRoot)) {
                    TestDistCpUtils.delete(fs, testRootString);
                }
                Path sourceFile = new Path(testRoot, "/source/foo/bar/source.txt");
                Path decoyFile = new Path(testRoot, "/target/moo/source.txt");
                Path targetFile = new Path(testRoot, "/target/moo/target.txt");
                TestDistCpUtils.createFile(fs, sourceFile.toString());
                TestDistCpUtils.createFile(fs, decoyFile.toString());
                TestDistCpUtils.createFile(fs, targetFile.toString());
                ArrayList<Path> srcPaths = new ArrayList<Path>();
                srcPaths.add(sourceFile);
                DistCpOptions options = new DistCpOptions.Builder(srcPaths, targetFile).build();
                SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
                Path listFile = new Path(testRoot, "/tmp/fileList.seq");
                listing.buildListing(listFile, new DistCpContext(options));
                reader = new SequenceFile.Reader(this.getConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listFile)});
                CopyListingFileStatus fileStatus = new CopyListingFileStatus();
                Text relativePath = new Text();
                Assert.assertTrue((boolean)reader.next((Writable)relativePath, (Writable)fileStatus));
                Assert.assertTrue((boolean)relativePath.toString().equals(""));
                TestDistCpUtils.delete(fs, testRootString);
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception encountered.");
                LOG.error("Unexpected exception: ", (Throwable)e);
                break block6;
            }
            finally {
                TestDistCpUtils.delete(fs, testRootString);
                IOUtils.closeStream(reader);
            }
            IOUtils.closeStream((Closeable)reader);
        }
    }

    @Test
    public void testFailOnCloseError() throws IOException {
        File inFile = File.createTempFile("TestCopyListingIn", null);
        inFile.deleteOnExit();
        File outFile = File.createTempFile("TestCopyListingOut", null);
        outFile.deleteOnExit();
        ArrayList<Path> srcs = new ArrayList<Path>();
        srcs.add(new Path(inFile.toURI()));
        IOException expectedEx = new IOException("boom");
        SequenceFile.Writer writer = (SequenceFile.Writer)Mockito.mock(SequenceFile.Writer.class);
        ((SequenceFile.Writer)Mockito.doThrow((Throwable[])new Throwable[]{expectedEx}).when((Object)writer)).close();
        SimpleCopyListing listing = new SimpleCopyListing(this.getConf(), CREDENTIALS);
        DistCpOptions options = new DistCpOptions.Builder(srcs, new Path(outFile.toURI())).build();
        Exception actualEx = null;
        try {
            listing.doBuildListing(writer, new DistCpContext(options));
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assert.assertNotNull((String)"close writer didn't fail", (Object)actualEx);
        Assert.assertEquals((Object)expectedEx, (Object)actualEx);
    }
}

