/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.handler.codec.smtp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class SmtpUtils {
    static List<CharSequence> toUnmodifiableList(CharSequence ... sequences) {
        if (sequences == null || sequences.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(sequences));
    }

    static void validateSMTPParameters(CharSequence ... parameters) {
        if (parameters != null) {
            for (CharSequence parameter : parameters) {
                if (parameter == null) continue;
                SmtpUtils.validateSMTPParameter(parameter);
            }
        }
    }

    static void validateSMTPParameters(List<CharSequence> parameters) {
        if (parameters != null) {
            for (CharSequence parameter : parameters) {
                if (parameter == null) continue;
                SmtpUtils.validateSMTPParameter(parameter);
            }
        }
    }

    private static void validateSMTPParameter(CharSequence parameter) {
        if (parameter instanceof String) {
            String paramStr = (String)parameter;
            if (paramStr.indexOf(13) != -1 || paramStr.indexOf(10) != -1) {
                throw new IllegalArgumentException("SMTP parameter contains CRLF characters: " + parameter);
            }
        } else {
            for (int i = 0; i < parameter.length(); ++i) {
                char c = parameter.charAt(i);
                if (c != '\r' && c != '\n') continue;
                throw new IllegalArgumentException("SMTP parameter contains CRLF characters: " + parameter);
            }
        }
    }

    private SmtpUtils() {
    }
}

