/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.CorruptMetaHeaderException;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCorruptMetadataFile {
    private MiniDFSCluster cluster;
    private MiniDFSCluster.Builder clusterBuilder;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.client.max.block.acquire.failures", 1);
        this.clusterBuilder = new MiniDFSCluster.Builder(this.conf).numDataNodes(1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testReadBlockFailsWhenMetaIsCorrupt() throws Exception {
        this.cluster = this.clusterBuilder.build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        Path filePath = new Path("test.dat");
        FSDataOutputStream out = fs.create(filePath, (short)1);
        out.write(1);
        out.hflush();
        out.close();
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
        File metadataFile = this.cluster.getBlockMetadataFile(0, block);
        FSDataInputStream in = fs.open(filePath);
        in.readByte();
        in.close();
        RandomAccessFile raFile = new RandomAccessFile(metadataFile, "rw");
        raFile.setLength(0L);
        FSDataInputStream intrunc = fs.open(filePath);
        LambdaTestUtils.intercept(BlockMissingException.class, () -> intrunc.readByte());
        intrunc.close();
        raFile.write("12345678901".getBytes());
        Assert.assertEquals((long)11L, (long)raFile.length());
        FSDataInputStream ininvalid = fs.open(filePath);
        LambdaTestUtils.intercept(BlockMissingException.class, () -> ininvalid.readByte());
        ininvalid.close();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return TestCorruptMetadataFile.this.cluster.getNameNode().getNamesystem().getBlockManager().getCorruptBlocks() == 1L;
            }
        }, (long)100L, (long)5000L);
        raFile.close();
    }

    @Test
    public void testBlockMetaDataHeaderPReadHandlesCorruptMetaFile() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        RandomAccessFile raFile = new RandomAccessFile(new File(testDir, "metafile"), "rw");
        raFile.writeShort(1);
        raFile.writeByte(1);
        raFile.writeInt(512);
        BlockMetadataHeader header = BlockMetadataHeader.preadHeader((FileChannel)raFile.getChannel());
        raFile.setLength(0L);
        LambdaTestUtils.intercept(CorruptMetaHeaderException.class, () -> BlockMetadataHeader.preadHeader((FileChannel)raFile.getChannel()));
        raFile.writeShort(1);
        raFile.writeByte(1);
        LambdaTestUtils.intercept(CorruptMetaHeaderException.class, () -> BlockMetadataHeader.preadHeader((FileChannel)raFile.getChannel()));
        raFile.setLength(0L);
        raFile.write("1234567".getBytes());
        LambdaTestUtils.intercept(CorruptMetaHeaderException.class, () -> BlockMetadataHeader.preadHeader((FileChannel)raFile.getChannel()));
        raFile.close();
    }
}

