/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.google.gson.JsonArray;
import org.apache.hadoop.shaded.com.google.gson.JsonElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SsoConfigurationUtil.class);
    public static final String HADOOP_JWT_ENABLED = "hadoop.http.authentication.jwt.enabled";
    public static final String EXPECTED_JWT_AUDIENCES = "hadoop.http.authentication.expected.jwt.audiences";
    private static List<String> audiences = new ArrayList<String>();
    private static Map<String, String> ssoConfigMap = null;
    private static SsoConfigurationUtil ssoConfigInstance = null;
    public static final String CLIENT_ID = "clientid";
    private final String CLIENT_SECRET = "clientsecret";
    private final String PROVIDER = "providername";
    public static final String ISSUER = "issuerendpoint";
    private final String JWS_SSO_ALGORITHM = "jws.sso.algorithm";
    public static final String DEFAULT_JWS_SSO_ALGORITHM = "RS256";
    private final String COOKIE_DOMAIN = "jwt.cookie.domain";
    private final String COOKIE_PATH = "jwt.cookie.path";
    public static final String DEFAULT_COOKIE_PATH = "/";
    private final String COOKIE_NAME = "jwt.cookie.name";
    public static final String DEFAULT_COOKIE_NAME = "hadoop-jwt";
    private final String USER_ATTRIBUTE_NAME = "jwt.user.attribute.name";
    public static final String DEFAULT_USER_ATTRIBUTE_NAME = "preferred_username";
    private static final String HADOOP_HOME_PROPERTY = "hadoop.home.dir";
    private static final String YARN_HOME_PROPERTY = "yarn.home.dir";
    private static final String MAPR_ENV_VAR = "MAPR_HOME";
    private static final String MAPR_PROPERTY_HOME = "mapr.home.dir";
    private static final String MAPR_HOME_PATH_DEFAULT = "/opt/mapr";
    public static boolean useDefaultConf = true;
    public static boolean ssoConfEnabled = false;

    private SsoConfigurationUtil() {
    }

    public static SsoConfigurationUtil getInstance() {
        if (ssoConfigInstance == null) {
            SsoConfigurationUtil.readHadoopSsoConf();
            LOG.debug("Initializing SSO configuration.");
            ssoConfigInstance = new SsoConfigurationUtil();
            ssoConfigMap = new HashMap<String, String>();
            ssoConfigInstance.init();
        }
        return ssoConfigInstance;
    }

    private void init() {
        LOG.debug("Getting SSO configuration from maprcli command.");
        JsonArray result = null;
        String[] ssoConfigCommand = new String[]{"cluster", "getssoconf"};
        Map jwtMapConf = new HashMap();
        if (ssoConfEnabled) {
            try {
                if (!useDefaultConf) {
                    Class<?> jwtKlass = Class.forName("org.apache.hadoop.util.JWTConfiguration");
                    Method executeJWTConf = jwtKlass.getMethod("getJWTConfiguration", new Class[0]);
                    Object jwtConf = jwtKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    jwtMapConf = (Map)executeJWTConf.invoke(jwtConf, new Object[0]);
                }
                Class<?> klass = Class.forName("org.apache.hadoop.util.MaprShellCommandExecutor");
                Method execute = klass.getMethod("execute", String[].class, Map.class, Boolean.TYPE);
                Object maprShell = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result = (JsonArray)execute.invoke(maprShell, ssoConfigCommand, null, false);
            }
            catch (Exception ex) {
                LOG.debug("Failed to get SSO configuration from maprcli. Please check 'maprcli cluster getssoconf' command.", (Throwable)ex);
                this.putEmptyMap();
            }
        }
        if (useDefaultConf) {
            this.defineDefaultSsoConfMap();
        } else if (jwtMapConf != null && !jwtMapConf.isEmpty()) {
            if (jwtMapConf.get(EXPECTED_JWT_AUDIENCES) != null) {
                audiences.addAll(Arrays.asList(((String)jwtMapConf.get(EXPECTED_JWT_AUDIENCES)).split(",")));
            }
            ssoConfigMap.put("jws.sso.algorithm", (String)jwtMapConf.get("jws.sso.algorithm"));
            ssoConfigMap.put("jwt.cookie.domain", (String)jwtMapConf.get("jwt.cookie.domain"));
            ssoConfigMap.put("jwt.cookie.path", (String)jwtMapConf.get("jwt.cookie.path"));
            ssoConfigMap.put("jwt.cookie.name", (String)jwtMapConf.get("jwt.cookie.name"));
            ssoConfigMap.put("jwt.user.attribute.name", (String)jwtMapConf.get("jwt.user.attribute.name"));
        }
        if (result != null && !result.isEmpty()) {
            JsonElement clientIdJson = result.get(0).getAsJsonObject().get(CLIENT_ID);
            JsonElement clientSecretJson = result.get(0).getAsJsonObject().get("clientsecret");
            ssoConfigMap.put(CLIENT_ID, clientIdJson != null ? clientIdJson.getAsString() : "");
            ssoConfigMap.put("clientsecret", clientSecretJson != null ? clientSecretJson.getAsString() : "");
            ssoConfigMap.put("providername", result.get(0).getAsJsonObject().get("providername").getAsString());
            ssoConfigMap.put(ISSUER, result.get(0).getAsJsonObject().get(ISSUER).getAsString());
        } else {
            this.putEmptyMap();
        }
    }

    public static void readHadoopSsoConf() {
        String hadoopHome = System.getProperty(HADOOP_HOME_PROPERTY);
        if (hadoopHome == null && (hadoopHome = System.getProperty(YARN_HOME_PROPERTY)) == null) {
            String maprHome = System.getenv(MAPR_ENV_VAR);
            if (maprHome == null && (maprHome = System.getProperty(MAPR_PROPERTY_HOME)) == null) {
                maprHome = MAPR_HOME_PATH_DEFAULT;
            }
            String hadoopVer = "";
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(maprHome + "/hadoop/hadoopversion"));){
                hadoopVer = bufferedReader.readLine().trim();
            }
            catch (Exception ex) {
                LOG.warn("Can't read hadoopversion file: {}", (Object)ex.getMessage());
            }
            hadoopHome = maprHome + "/hadoop/hadoop-" + hadoopVer;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(hadoopHome + "/etc/hadoop/ssoConf"));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.trim().startsWith("ssoEnabled=")) {
                    ssoConfEnabled = Boolean.parseBoolean(line.trim().split("=")[1]);
                    continue;
                }
                if (!line.trim().startsWith("useDefaultConf=")) continue;
                useDefaultConf = Boolean.parseBoolean(line.trim().split("=")[1]);
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to parse ssoConf file: {}", (Object)ex.getMessage());
        }
    }

    private void defineDefaultSsoConfMap() {
        LOG.debug("Initializing default Hadoop SSO configuration");
        String domainName = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String fqdn = localHost.getCanonicalHostName();
            if (fqdn != null && fqdn.contains(".")) {
                domainName = fqdn.substring(fqdn.indexOf(".") + 1);
            }
        }
        catch (UnknownHostException e) {
            LOG.warn("Can't initialize hostname for the service");
        }
        ssoConfigMap.put("jws.sso.algorithm", DEFAULT_JWS_SSO_ALGORITHM);
        ssoConfigMap.put("jwt.cookie.domain", domainName);
        ssoConfigMap.put("jwt.cookie.path", DEFAULT_COOKIE_PATH);
        ssoConfigMap.put("jwt.cookie.name", DEFAULT_COOKIE_NAME);
        ssoConfigMap.put("jwt.user.attribute.name", DEFAULT_USER_ATTRIBUTE_NAME);
    }

    private void putEmptyMap() {
        ssoConfigMap.put(CLIENT_ID, "");
        ssoConfigMap.put("clientsecret", "");
        ssoConfigMap.put("providername", "");
        ssoConfigMap.put(ISSUER, "");
    }

    public Map<String, String> getFullSsoConfig() {
        return ssoConfigMap;
    }

    public String getConf(String key) {
        return ssoConfigMap.get(key);
    }

    public String getClientId() {
        return ssoConfigMap.get(CLIENT_ID);
    }

    public String getClientSecret() {
        return ssoConfigMap.get("clientsecret");
    }

    public String getClientIssuer() {
        return ssoConfigMap.get(ISSUER);
    }

    public String getProvider() {
        return ssoConfigMap.get("providername");
    }

    public String getCookieDomain() {
        return ssoConfigMap.get("jwt.cookie.domain");
    }

    public String getCookiePath() {
        return ssoConfigMap.get("jwt.cookie.path");
    }

    public String getCookieName() {
        return ssoConfigMap.get("jwt.cookie.name");
    }

    public String getUserAttrName() {
        return ssoConfigMap.get("jwt.user.attribute.name");
    }

    public List<String> getAudiences() {
        return audiences;
    }

    public String getJwsSsoAlgorithm() {
        return ssoConfigMap.get("jws.sso.algorithm");
    }

    public boolean isSsoEnabled() {
        return !this.getClientIssuer().isEmpty() && !this.getClientId().isEmpty() && !this.getClientSecret().isEmpty() && !this.getProvider().isEmpty();
    }
}

