/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUpdateService;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterRPCMultipleDestinationMountTableResolver {
    private static final List<String> NS_IDS = Arrays.asList("ns0", "ns1", "ns2");
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver resolver;
    private static DistributedFileSystem nnFs0;
    private static DistributedFileSystem nnFs1;
    private static DistributedFileSystem nnFs2;
    private static DistributedFileSystem routerFs;
    private static RouterRpcServer rpcServer;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 3, MultipleDestinationMountTableResolver.class);
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        Configuration hdfsConf = new Configuration(false);
        hdfsConf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster.addRouterOverrides(routerConf);
        cluster.addNamenodeOverrides(hdfsConf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        resolver = (MountTableResolver)routerContext.getRouter().getSubclusterResolver();
        nnFs0 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(0), null).getFileSystem();
        nnFs1 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(1), null).getFileSystem();
        nnFs2 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(2), null).getFileSystem();
        routerFs = (DistributedFileSystem)routerContext.getFileSystem();
        rpcServer = routerContext.getRouter().getRpcServer();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    public void setupOrderMountPath(DestinationOrder order) throws Exception {
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/tmp");
        destMap.put("ns1", "/tmp");
        nnFs0.mkdirs(new Path("/tmp"));
        nnFs1.mkdirs(new Path("/tmp"));
        MountTable addEntry = MountTable.newInstance((String)"/mount", destMap);
        addEntry.setDestOrder(order);
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        routerFs.mkdirs(new Path("/mount/dir/dir"));
        DFSTestUtil.createFile((FileSystem)routerFs, (Path)new Path("/mount/dir/file"), (long)100L, (short)1, (long)1024L);
        DFSTestUtil.createFile((FileSystem)routerFs, (Path)new Path("/mount/file"), (long)100L, (short)1, (long)1024L);
    }

    @After
    public void resetTestEnvironment() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)"/mount");
        mountTableManager.removeMountTableEntry(req2);
        nnFs0.delete(new Path("/tmp"), true);
        nnFs1.delete(new Path("/tmp"), true);
    }

    @Test
    public void testInvocationSpaceOrder() throws Exception {
        this.setupOrderMountPath(DestinationOrder.SPACE);
        boolean isDirAll = rpcServer.isPathAll("/mount/dir");
        Assert.assertTrue((boolean)isDirAll);
        this.testInvocation(isDirAll);
    }

    @Test
    public void testInvocationHashAllOrder() throws Exception {
        this.setupOrderMountPath(DestinationOrder.HASH_ALL);
        boolean isDirAll = rpcServer.isPathAll("/mount/dir");
        Assert.assertTrue((boolean)isDirAll);
        this.testInvocation(isDirAll);
    }

    @Test
    public void testInvocationRandomOrder() throws Exception {
        this.setupOrderMountPath(DestinationOrder.RANDOM);
        boolean isDirAll = rpcServer.isPathAll("/mount/dir");
        Assert.assertTrue((boolean)isDirAll);
        this.testInvocation(isDirAll);
    }

    @Test
    public void testInvocationHashOrder() throws Exception {
        this.setupOrderMountPath(DestinationOrder.HASH);
        boolean isDirAll = rpcServer.isPathAll("/mount/dir");
        Assert.assertFalse((boolean)isDirAll);
        this.testInvocation(isDirAll);
    }

    @Test
    public void testInvocationLocalOrder() throws Exception {
        this.setupOrderMountPath(DestinationOrder.LOCAL);
        boolean isDirAll = rpcServer.isPathAll("/mount/dir");
        Assert.assertFalse((boolean)isDirAll);
        this.testInvocation(isDirAll);
    }

    private void testInvocation(boolean dirAll) throws IOException {
        Path mountDir = new Path("/mount/dir/dir");
        Path nameSpaceFile = new Path("/tmp/dir/file");
        Path mountFile = new Path("/mount/dir/file");
        Path mountEntry = new Path("/mount");
        Path mountDest = new Path("/tmp");
        Path nameSpaceDir = new Path("/tmp/dir/dir");
        String name = "user.a1";
        byte[] value = new byte[]{49, 50, 51};
        this.testDirectoryAndFileLevelInvocation(dirAll, mountDir, nameSpaceFile, mountFile, nameSpaceDir, "user.a1", value);
        mountDir = new Path("/mount/dir");
        nameSpaceFile = new Path("/tmp/file");
        mountFile = new Path("/mount/file");
        nameSpaceDir = new Path("/tmp/dir");
        this.testDirectoryAndFileLevelInvocation(dirAll, mountDir, nameSpaceFile, mountFile, nameSpaceDir, "user.a1", value);
        routerFs.setOwner(mountEntry, "testuser", "testgroup");
        routerFs.setPermission(mountEntry, FsPermission.createImmutable((short)777));
        Assert.assertEquals((Object)"testuser", (Object)routerFs.getFileStatus(mountEntry).getOwner());
        Assert.assertEquals((Object)"testuser", (Object)nnFs0.getFileStatus(mountDest).getOwner());
        Assert.assertEquals((Object)"testuser", (Object)nnFs1.getFileStatus(mountDest).getOwner());
        Assert.assertEquals((long)777L, (long)routerFs.getFileStatus(mountEntry).getPermission().toShort());
        Assert.assertEquals((long)777L, (long)nnFs0.getFileStatus(mountDest).getPermission().toShort());
        Assert.assertEquals((long)777L, (long)nnFs1.getFileStatus(mountDest).getPermission().toShort());
        routerFs.setStoragePolicy(mountEntry, "COLD");
        Assert.assertEquals((Object)"COLD", (Object)routerFs.getStoragePolicy(mountEntry).getName());
        Assert.assertEquals((Object)"COLD", (Object)nnFs0.getStoragePolicy(mountDest).getName());
        Assert.assertEquals((Object)"COLD", (Object)nnFs1.getStoragePolicy(mountDest).getName());
        routerFs.unsetStoragePolicy(mountEntry);
        Assert.assertEquals((Object)"HOT", (Object)routerFs.getStoragePolicy(mountDest).getName());
        Assert.assertEquals((Object)"HOT", (Object)nnFs0.getStoragePolicy(mountDest).getName());
        Assert.assertEquals((Object)"HOT", (Object)nnFs1.getStoragePolicy(mountDest).getName());
        routerFs.setErasureCodingPolicy(mountEntry, "RS-6-3-1024k");
        Assert.assertEquals((Object)"RS-6-3-1024k", (Object)routerFs.getErasureCodingPolicy(mountEntry).getName());
        Assert.assertEquals((Object)"RS-6-3-1024k", (Object)nnFs0.getErasureCodingPolicy(mountDest).getName());
        Assert.assertEquals((Object)"RS-6-3-1024k", (Object)nnFs1.getErasureCodingPolicy(mountDest).getName());
        routerFs.unsetErasureCodingPolicy(mountEntry);
        Assert.assertNull((Object)routerFs.getErasureCodingPolicy(mountDest));
        Assert.assertNull((Object)nnFs0.getErasureCodingPolicy(mountDest));
        Assert.assertNull((Object)nnFs1.getErasureCodingPolicy(mountDest));
        routerFs.setXAttr(mountEntry, "user.a1", value);
        Assert.assertArrayEquals((byte[])value, (byte[])routerFs.getXAttr(mountEntry, "user.a1"));
        Assert.assertArrayEquals((byte[])value, (byte[])nnFs0.getXAttr(mountDest, "user.a1"));
        Assert.assertArrayEquals((byte[])value, (byte[])nnFs1.getXAttr(mountDest, "user.a1"));
        routerFs.removeXAttr(mountEntry, "user.a1");
        Assert.assertEquals((long)0L, (long)routerFs.getXAttrs(mountEntry).size());
        Assert.assertEquals((long)0L, (long)nnFs0.getXAttrs(mountDest).size());
        Assert.assertEquals((long)0L, (long)nnFs1.getXAttrs(mountDest).size());
    }

    private void testDirectoryAndFileLevelInvocation(boolean dirAll, Path mountDir, Path nameSpaceFile, Path mountFile, Path nameSpaceDir, String name, byte[] value) throws IOException {
        routerFs.setOwner(mountDir, "testuser", "testgroup");
        routerFs.setPermission(mountDir, FsPermission.createImmutable((short)777));
        routerFs.setStoragePolicy(mountDir, "COLD");
        routerFs.setErasureCodingPolicy(mountDir, "RS-6-3-1024k");
        routerFs.setXAttr(mountDir, name, value);
        boolean checkedDir1 = this.verifyDirectoryLevelInvocations(dirAll, nameSpaceDir, nnFs0, name, value);
        boolean checkedDir2 = this.verifyDirectoryLevelInvocations(dirAll, nameSpaceDir, nnFs1, name, value);
        Assert.assertTrue((String)"The file didn't existed in either of the subclusters.", (checkedDir1 || checkedDir2 ? 1 : 0) != 0);
        routerFs.unsetStoragePolicy(mountDir);
        routerFs.removeXAttr(mountDir, name);
        routerFs.unsetErasureCodingPolicy(mountDir);
        checkedDir1 = this.verifyDirectoryLevelUnsetInvocations(dirAll, nnFs0, nameSpaceDir);
        checkedDir2 = this.verifyDirectoryLevelUnsetInvocations(dirAll, nnFs1, nameSpaceDir);
        Assert.assertTrue((String)"The file didn't existed in either of the subclusters.", (checkedDir1 || checkedDir2 ? 1 : 0) != 0);
        routerFs.setOwner(mountFile, "testuser", "testgroup");
        routerFs.setPermission(mountFile, FsPermission.createImmutable((short)777));
        routerFs.setStoragePolicy(mountFile, "COLD");
        routerFs.setReplication(mountFile, (short)2);
        routerFs.setXAttr(mountFile, name, value);
        this.verifyFileLevelInvocations(nameSpaceFile, nnFs0, mountFile, name, value);
        this.verifyFileLevelInvocations(nameSpaceFile, nnFs1, mountFile, name, value);
    }

    private boolean verifyDirectoryLevelUnsetInvocations(boolean dirAll, DistributedFileSystem nnFs, Path nameSpaceDir) throws IOException {
        boolean checked = false;
        if (dirAll || nnFs.exists(nameSpaceDir)) {
            checked = true;
            Assert.assertEquals((Object)"HOT", (Object)nnFs.getStoragePolicy(nameSpaceDir).getName());
            Assert.assertNull((Object)nnFs.getErasureCodingPolicy(nameSpaceDir));
            Assert.assertEquals((long)0L, (long)nnFs.getXAttrs(nameSpaceDir).size());
        }
        return checked;
    }

    private void verifyFileLevelInvocations(Path nameSpaceFile, DistributedFileSystem nnFs, Path mountFile, String name, byte[] value) throws IOException {
        if (nnFs.exists(nameSpaceFile)) {
            Assert.assertEquals((Object)"testuser", (Object)nnFs.getFileStatus(nameSpaceFile).getOwner());
            Assert.assertEquals((long)777L, (long)nnFs.getFileStatus(nameSpaceFile).getPermission().toShort());
            Assert.assertEquals((Object)"COLD", (Object)nnFs.getStoragePolicy(nameSpaceFile).getName());
            Assert.assertEquals((long)2L, (long)nnFs.getFileStatus(nameSpaceFile).getReplication());
            Assert.assertArrayEquals((byte[])value, (byte[])nnFs.getXAttr(nameSpaceFile, name));
            routerFs.unsetStoragePolicy(mountFile);
            routerFs.removeXAttr(mountFile, name);
            Assert.assertEquals((long)0L, (long)nnFs.getXAttrs(nameSpaceFile).size());
            Assert.assertEquals((Object)"HOT", (Object)nnFs.getStoragePolicy(nameSpaceFile).getName());
        }
    }

    private boolean verifyDirectoryLevelInvocations(boolean dirAll, Path nameSpaceDir, DistributedFileSystem nnFs, String name, byte[] value) throws IOException {
        boolean checked = false;
        if (dirAll || nnFs.exists(nameSpaceDir)) {
            checked = true;
            Assert.assertEquals((Object)"testuser", (Object)nnFs.getFileStatus(nameSpaceDir).getOwner());
            Assert.assertEquals((Object)"COLD", (Object)nnFs.getStoragePolicy(nameSpaceDir).getName());
            Assert.assertEquals((Object)"RS-6-3-1024k", (Object)nnFs.getErasureCodingPolicy(nameSpaceDir).getName());
            Assert.assertArrayEquals((byte[])value, (byte[])nnFs.getXAttr(nameSpaceDir, name));
            Assert.assertEquals((long)777L, (long)nnFs.getFileStatus(nameSpaceDir).getPermission().toShort());
        }
        return checked;
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        resolver.loadCache(true);
        return addResponse.getStatus();
    }

    @Test
    public void testECMultipleDestinations() throws Exception {
        this.setupOrderMountPath(DestinationOrder.HASH_ALL);
        Path mountPath = new Path("/mount/dir");
        routerFs.setErasureCodingPolicy(mountPath, "RS-6-3-1024k");
        Assert.assertTrue((boolean)routerFs.getFileStatus(mountPath).isErasureCoded());
    }

    @Test
    public void testACLMultipleDestinations() throws Exception {
        this.setupOrderMountPath(DestinationOrder.HASH_ALL);
        Path mountPath = new Path("/mount/dir/dir");
        Path nsPath = new Path("/tmp/dir/dir");
        List<AclEntry> aclSpec = Collections.singletonList(AclEntry.parseAclEntry((String)"default:USER:TestUser:rwx", (boolean)true));
        routerFs.setAcl(mountPath, aclSpec);
        Assert.assertEquals((long)5L, (long)nnFs0.getAclStatus(nsPath).getEntries().size());
        Assert.assertEquals((long)5L, (long)nnFs1.getAclStatus(nsPath).getEntries().size());
        aclSpec = Collections.singletonList(AclEntry.parseAclEntry((String)"USER:User:rwx::", (boolean)true));
        routerFs.modifyAclEntries(mountPath, aclSpec);
        Assert.assertEquals((long)7L, (long)nnFs0.getAclStatus(nsPath).getEntries().size());
        Assert.assertEquals((long)7L, (long)nnFs1.getAclStatus(nsPath).getEntries().size());
        routerFs.removeAclEntries(mountPath, aclSpec);
        Assert.assertEquals((long)6L, (long)nnFs0.getAclStatus(nsPath).getEntries().size());
        Assert.assertEquals((long)6L, (long)nnFs1.getAclStatus(nsPath).getEntries().size());
        routerFs.modifyAclEntries(mountPath, aclSpec);
        routerFs.removeDefaultAcl(mountPath);
        Assert.assertEquals((long)2L, (long)nnFs0.getAclStatus(nsPath).getEntries().size());
        Assert.assertEquals((long)2L, (long)nnFs1.getAclStatus(nsPath).getEntries().size());
        routerFs.removeAcl(mountPath);
        Assert.assertEquals((long)0L, (long)nnFs0.getAclStatus(nsPath).getEntries().size());
        Assert.assertEquals((long)0L, (long)nnFs1.getAclStatus(nsPath).getEntries().size());
    }

    @Test
    public void testGetDestinationHashAll() throws Exception {
        this.testGetDestination(DestinationOrder.HASH_ALL, Arrays.asList("ns1"), Arrays.asList("ns1"), Arrays.asList("ns1", "ns0"));
    }

    @Test
    public void testGetDestinationHash() throws Exception {
        this.testGetDestination(DestinationOrder.HASH, Arrays.asList("ns1"), Arrays.asList("ns1"), Arrays.asList("ns1"));
    }

    @Test
    public void testGetDestinationRandom() throws Exception {
        this.testGetDestination(DestinationOrder.RANDOM, null, null, Arrays.asList("ns0", "ns1"));
    }

    @Test
    public void testIsMultiDestDir() throws Exception {
        RouterClientProtocol client = routerContext.getRouter().getRpcServer().getClientProtocolModule();
        this.setupOrderMountPath(DestinationOrder.HASH_ALL);
        Assert.assertTrue((boolean)client.isMultiDestDirectory("/mount/dir"));
        Assert.assertFalse((boolean)client.isMultiDestDirectory("/mount/nodir"));
        Assert.assertFalse((boolean)client.isMultiDestDirectory("/mount/dir/file"));
        routerFs.createSymlink(new Path("/mount/dir/file"), new Path("/mount/dir/link"), true);
        Assert.assertFalse((boolean)client.isMultiDestDirectory("/mount/dir/link"));
        routerFs.createSymlink(new Path("/mount/dir/dir"), new Path("/mount/dir/linkDir"), true);
        Assert.assertFalse((boolean)client.isMultiDestDirectory("/mount/dir/linkDir"));
        this.resetTestEnvironment();
        this.setupOrderMountPath(DestinationOrder.HASH);
        Assert.assertFalse((boolean)client.isMultiDestDirectory("/mount/dir"));
    }

    @Test
    public void testSnapshotPathResolution() throws Exception {
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/tmp_ns0");
        destMap.put("ns1", "/tmp_ns1");
        nnFs0.mkdirs(new Path("/tmp_ns0"));
        nnFs1.mkdirs(new Path("/tmp_ns1"));
        MountTable addEntry = MountTable.newInstance((String)"/mountSnap", destMap);
        addEntry.setDestOrder(DestinationOrder.HASH);
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        nnFs0.mkdirs(new Path("/tmp_ns0/snapDir"));
        Path snapDir = new Path("/mountSnap/snapDir");
        Path snapshotPath = new Path("/mountSnap/snapDir/.snapshot/snap");
        routerFs.allowSnapshot(snapDir);
        Path snapshot = routerFs.createSnapshot(snapDir, "snap");
        Assert.assertEquals((Object)snapshotPath, (Object)snapshot);
        SnapshotStatus[] snapshots = routerFs.getSnapshotListing(snapDir);
        Assert.assertEquals((Object)snapshotPath, (Object)snapshots[0].getFullPath());
    }

    @Test
    public void testRenameMultipleDestDirectories() throws Exception {
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.HASH_ALL, false);
        this.resetTestEnvironment();
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.RANDOM, false);
        this.resetTestEnvironment();
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.SPACE, false);
        this.resetTestEnvironment();
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.HASH_ALL, true);
        this.resetTestEnvironment();
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.RANDOM, true);
        this.resetTestEnvironment();
        this.verifyRenameOnMultiDestDirectories(DestinationOrder.SPACE, true);
    }

    @Test
    public void testClearQuota() throws Exception {
        long nsQuota = 5L;
        long ssQuota = 100L;
        Path path = new Path("/router_test");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/router_test", Collections.singletonMap("ns0", "/router_test"));
        addEntry.setQuota(new RouterQuotaUsage.Builder().build());
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        RouterAdmin admin = this.getRouterAdmin();
        String[] argv = new String[]{"-setQuota", path.toString(), "-nsQuota", String.valueOf(nsQuota), "-ssQuota", String.valueOf(ssQuota)};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        updateService.periodicInvoke();
        resolver.loadCache(true);
        ContentSummary cs = routerFs.getContentSummary(path);
        Assert.assertEquals((long)nsQuota, (long)cs.getQuota());
        Assert.assertEquals((long)ssQuota, (long)cs.getSpaceQuota());
        argv = new String[]{"-clrQuota", path.toString()};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)admin, (String[])argv));
        updateService.periodicInvoke();
        resolver.loadCache(true);
        ContentSummary cs1 = routerFs.getContentSummary(path);
        Assert.assertEquals((long)-1L, (long)cs1.getQuota());
        Assert.assertEquals((long)-1L, (long)cs1.getSpaceQuota());
    }

    @Test
    public void testContentSummaryWithMultipleDest() throws Exception {
        long nsQuota = 5L;
        long ssQuota = 100L;
        Path path = new Path("/testContentSummaryWithMultipleDest");
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/testContentSummaryWithMultipleDest");
        destMap.put("ns1", "/testContentSummaryWithMultipleDest");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/testContentSummaryWithMultipleDest", destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        ContentSummary cs = routerFs.getContentSummary(path);
        Assert.assertEquals((long)nsQuota, (long)cs.getQuota());
        Assert.assertEquals((long)ssQuota, (long)cs.getSpaceQuota());
        ContentSummary ns0Cs = nnFs0.getContentSummary(path);
        Assert.assertEquals((long)nsQuota, (long)ns0Cs.getQuota());
        Assert.assertEquals((long)ssQuota, (long)ns0Cs.getSpaceQuota());
        ContentSummary ns1Cs = nnFs1.getContentSummary(path);
        Assert.assertEquals((long)nsQuota, (long)ns1Cs.getQuota());
        Assert.assertEquals((long)ssQuota, (long)ns1Cs.getSpaceQuota());
    }

    @Test
    public void testContentSummaryMultipleDestWithMaxValue() throws Exception {
        long nsQuota = 0x7FFFFFFFFFFFFFFDL;
        long ssQuota = 0x7FFFFFFFFFFFFFFDL;
        Path path = new Path("/testContentSummaryMultipleDestWithMaxValue");
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/testContentSummaryMultipleDestWithMaxValue");
        destMap.put("ns1", "/testContentSummaryMultipleDestWithMaxValue");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/testContentSummaryMultipleDestWithMaxValue", destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().quota(nsQuota).spaceQuota(ssQuota).build());
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        RouterQuotaUpdateService updateService = routerContext.getRouter().getQuotaCacheUpdateService();
        updateService.periodicInvoke();
        ContentSummary cs = routerFs.getContentSummary(path);
        Assert.assertEquals((long)nsQuota, (long)cs.getQuota());
        Assert.assertEquals((long)ssQuota, (long)cs.getSpaceQuota());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvokeAtAvailableNs() throws IOException {
        Path path = new Path("/testInvokeAtAvailableNs");
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/testInvokeAtAvailableNs");
        destMap.put("ns1", "/testInvokeAtAvailableNs");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/testInvokeAtAvailableNs", destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().build());
        addEntry.setDestOrder(DestinationOrder.RANDOM);
        addEntry.setFaultTolerant(true);
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        MiniDFSCluster dfsCluster = cluster.getCluster();
        dfsCluster.shutdownNameNode(0);
        dfsCluster.shutdownNameNode(1);
        try {
            RemoteMethod method = new RemoteMethod("getServerDefaults");
            FsServerDefaults serverDefaults = (FsServerDefaults)rpcServer.invokeAtAvailableNs(method, FsServerDefaults.class);
            Assert.assertNotNull((Object)serverDefaults);
        }
        finally {
            dfsCluster.restartNameNode(0);
            dfsCluster.restartNameNode(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWithUnavailableSubCluster() throws IOException {
        Path path = new Path("/testWriteWithUnavailableSubCluster");
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/testWriteWithUnavailableSubCluster");
        destMap.put("ns1", "/testWriteWithUnavailableSubCluster");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/testWriteWithUnavailableSubCluster", destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().build());
        addEntry.setDestOrder(DestinationOrder.RANDOM);
        addEntry.setFaultTolerant(true);
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        MiniDFSCluster dfsCluster = cluster.getCluster();
        dfsCluster.shutdownNameNode(0);
        FSDataOutputStream out = null;
        Path filePath = new Path(path, "aa");
        try {
            out = routerFs.create(filePath);
            out.write("hello".getBytes());
            out.hflush();
            Assert.assertTrue((boolean)routerFs.exists(filePath));
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            dfsCluster.restartNameNode(0);
        }
    }

    @Test
    public void testRenameWithMultiDestinations() throws Exception {
        String srcDir = "/mount-source-dir";
        Path path = new Path(srcDir);
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", srcDir);
        destMap.put("ns1", srcDir);
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)srcDir, destMap);
        addEntry.setDestOrder(DestinationOrder.RANDOM);
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        String targetDir = "/ns0_test";
        nnFs0.mkdirs(new Path(targetDir));
        MountTable addDstEntry = MountTable.newInstance((String)targetDir, Collections.singletonMap("ns0", targetDir));
        Assert.assertTrue((boolean)this.addMountTable(addDstEntry));
        routerFs.mkdirs(new Path(srcDir + "/dir1"));
        routerFs.mkdirs(new Path(srcDir + "/dir1/dir_1"));
        routerFs.mkdirs(new Path(srcDir + "/dir1/dir_2"));
        routerFs.mkdirs(new Path(targetDir));
        LambdaTestUtils.intercept(IOException.class, (String)"The number of remote locations for both source and target should be same.", () -> routerFs.rename(new Path(srcDir + "/dir1/dir_1"), new Path(targetDir)));
    }

    private void verifyRenameOnMultiDestDirectories(DestinationOrder order, boolean isRename2) throws Exception {
        this.setupOrderMountPath(order);
        Path src = new Path("/mount/dir/dir");
        Path nnSrc = new Path("/tmp/dir/dir");
        Path dst = new Path("/mount/dir/subdir");
        Path nnDst = new Path("/tmp/dir/subdir");
        Path fileSrc = new Path("/mount/dir/dir/file");
        Path nnFileSrc = new Path("/tmp/dir/dir/file");
        Path fileDst = new Path("/mount/dir/subdir/file");
        Path nnFileDst = new Path("/tmp/dir/subdir/file");
        DFSTestUtil.createFile((FileSystem)routerFs, (Path)fileSrc, (long)100L, (short)1, (long)1024L);
        if (isRename2) {
            routerFs.rename(src, dst, new Options.Rename[]{Options.Rename.NONE});
        } else {
            Assert.assertTrue((boolean)routerFs.rename(src, dst));
        }
        Assert.assertTrue((boolean)nnFs0.exists(nnDst));
        Assert.assertTrue((boolean)nnFs1.exists(nnDst));
        Assert.assertFalse((boolean)nnFs0.exists(nnSrc));
        Assert.assertFalse((boolean)nnFs1.exists(nnSrc));
        Assert.assertFalse((boolean)routerFs.exists(fileSrc));
        Assert.assertTrue((boolean)routerFs.exists(fileDst));
        Assert.assertTrue((nnFs0.exists(nnFileDst) || nnFs1.exists(nnFileDst) ? 1 : 0) != 0);
        Assert.assertFalse((nnFs0.exists(nnFileSrc) || nnFs1.exists(nnFileSrc) ? 1 : 0) != 0);
        Path fileRenamed = new Path("/mount/dir/subdir/renamedFile");
        Path nnFileRenamed = new Path("/tmp/dir/subdir/renamedFile");
        if (isRename2) {
            routerFs.rename(fileDst, fileRenamed, new Options.Rename[]{Options.Rename.NONE});
        } else {
            Assert.assertTrue((boolean)routerFs.rename(fileDst, fileRenamed));
        }
        Assert.assertTrue((boolean)routerFs.exists(fileRenamed));
        Assert.assertFalse((boolean)routerFs.exists(fileDst));
        Assert.assertTrue((nnFs0.exists(nnFileRenamed) || nnFs1.exists(nnFileRenamed) ? 1 : 0) != 0);
        Assert.assertFalse((nnFs0.exists(nnFileDst) || nnFs1.exists(nnFileDst) ? 1 : 0) != 0);
        Path dst1 = new Path("/mount/dir/renameddir");
        Path nnDst1 = new Path("/tmp/dir/renameddir");
        nnFs1.delete(nnDst, true);
        if (isRename2) {
            routerFs.rename(dst, dst1, new Options.Rename[]{Options.Rename.NONE});
        } else {
            Assert.assertTrue((boolean)routerFs.rename(dst, dst1));
        }
        Assert.assertTrue((boolean)nnFs0.exists(nnDst1));
        Assert.assertFalse((boolean)nnFs0.exists(nnDst));
        Path src1 = new Path("/mount/dir");
        Path dst2 = new Path("/mount/OneDest");
        Path nnDst2 = new Path("/tmp/OneDest");
        nnFs0.mkdirs(nnDst2);
        if (isRename2) {
            routerFs.rename(src1, dst2, new Options.Rename[]{Options.Rename.NONE});
        } else {
            Assert.assertTrue((boolean)routerFs.rename(src1, dst2));
        }
        Assert.assertTrue((boolean)nnFs0.exists(nnDst2));
        Assert.assertTrue((boolean)nnFs1.exists(nnDst2));
    }

    private void testGetDestination(DestinationOrder order, List<String> expectFileLocation, List<String> expectNoFileLocation, List<String> expectDirLocation) throws Exception {
        this.setupOrderMountPath(order);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        String pathFile = "dir/file";
        Path pathRouterFile = new Path("/mount", "dir/file");
        Path pathLocalFile = new Path("/tmp", "dir/file");
        FileStatus fileStatus = routerFs.getFileStatus(pathRouterFile);
        Assert.assertTrue((String)(fileStatus + " should be a file"), (boolean)fileStatus.isFile());
        GetDestinationResponse respFile = mountTableManager.getDestination(GetDestinationRequest.newInstance((Path)pathRouterFile));
        if (expectFileLocation != null) {
            Assert.assertEquals(expectFileLocation, (Object)respFile.getDestinations());
            this.assertPathStatus(expectFileLocation, pathLocalFile, false);
        } else {
            Collection dests = respFile.getDestinations();
            this.assertPathStatus(dests, pathLocalFile, false);
        }
        String pathNoFile = "dir/no-file";
        Path pathRouterNoFile = new Path("/mount", "dir/no-file");
        Path pathLocalNoFile = new Path("/tmp", "dir/no-file");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> routerFs.getFileStatus(pathRouterNoFile));
        GetDestinationResponse respNoFile = mountTableManager.getDestination(GetDestinationRequest.newInstance((Path)pathRouterNoFile));
        if (expectNoFileLocation != null) {
            Assert.assertEquals(expectNoFileLocation, (Object)respNoFile.getDestinations());
        }
        this.assertPathStatus(Collections.emptyList(), pathLocalNoFile, false);
        String pathNestedDir = "dir/dir";
        Path pathRouterNestedDir = new Path("/mount", "dir/dir");
        Path pathLocalNestedDir = new Path("/tmp", "dir/dir");
        FileStatus dirStatus = routerFs.getFileStatus(pathRouterNestedDir);
        Assert.assertTrue((String)(dirStatus + " should be a directory"), (boolean)dirStatus.isDirectory());
        GetDestinationResponse respDir = mountTableManager.getDestination(GetDestinationRequest.newInstance((Path)pathRouterNestedDir));
        TestRouterRPCMultipleDestinationMountTableResolver.assertEqualsCollection(expectDirLocation, respDir.getDestinations());
        this.assertPathStatus(expectDirLocation, pathLocalNestedDir, true);
    }

    private void assertPathStatus(Collection<String> expectedLocations, Path path, boolean isDir) throws Exception {
        for (String nsId : NS_IDS) {
            FileSystem fs = TestRouterRPCMultipleDestinationMountTableResolver.getFileSystem(nsId);
            if (expectedLocations.contains(nsId)) {
                Assert.assertTrue((String)(path + " should exist in " + nsId), (boolean)fs.exists(path));
                FileStatus status = fs.getFileStatus(path);
                if (isDir) {
                    Assert.assertTrue((String)(path + " should be a directory"), (boolean)status.isDirectory());
                    continue;
                }
                Assert.assertTrue((String)(path + " should be a file"), (boolean)status.isFile());
                continue;
            }
            Assert.assertFalse((String)(path + " should not exist in " + nsId), (boolean)fs.exists(path));
        }
    }

    private static void assertEqualsCollection(Collection<String> col1, Collection<String> col2) {
        Assert.assertEquals(new TreeSet<String>(col1), new TreeSet<String>(col2));
    }

    private static FileSystem getFileSystem(String nsId) {
        if (nsId.equals("ns0")) {
            return nnFs0;
        }
        if (nsId.equals("ns1")) {
            return nnFs1;
        }
        if (nsId.equals("ns2")) {
            return nnFs2;
        }
        return null;
    }

    private RouterAdmin getRouterAdmin() {
        Router router = routerContext.getRouter();
        Configuration configuration = routerContext.getConf();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        configuration.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
        return new RouterAdmin(configuration);
    }
}

