/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;

public final class OnSubscribeMapLast<T>
implements Observable.OnSubscribe<T> {
    private final Observable<T> source;
    private final Func1<? super T, ? extends T> function;

    public OnSubscribeMapLast(Observable<T> source, Func1<? super T, ? extends T> function) {
        this.source = source;
        this.function = function;
    }

    public void call(Subscriber<? super T> child) {
        final MapLastSubscriber<? extends T> parent = new MapLastSubscriber<T>(child, this.function);
        child.add(parent);
        child.setProducer(new Producer(){

            public void request(long n) {
                parent.requestMore(n);
            }
        });
        this.source.unsafeSubscribe(parent);
    }

    private static final class MapLastSubscriber<T>
    extends Subscriber<T> {
        private static final Object EMPTY = new Object();
        private final Subscriber<? super T> child;
        private final Func1<? super T, ? extends T> function;
        private final AtomicBoolean firstRequest = new AtomicBoolean(true);
        private T value = EMPTY;

        public MapLastSubscriber(Subscriber<? super T> child, Func1<? super T, ? extends T> function) {
            this.child = child;
            this.function = function;
        }

        public void requestMore(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("cannot request negative amount");
            }
            if (n == 0L) {
                return;
            }
            if (this.firstRequest.compareAndSet(true, false)) {
                long m = n + 1L;
                if (m < 0L) {
                    m = Long.MAX_VALUE;
                }
                this.request(m);
            } else {
                this.request(n);
            }
        }

        public void onCompleted() {
            if (this.value != EMPTY) {
                Object value2;
                try {
                    value2 = this.function.call(this.value);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)e, this.value));
                    return;
                }
                this.child.onNext(value2);
            }
            this.child.onCompleted();
        }

        public void onError(Throwable e) {
            if (this.value != EMPTY) {
                this.child.onNext(this.value);
            }
            this.child.onError(e);
        }

        public void onNext(T t) {
            if (this.value == EMPTY) {
                this.value = t;
            } else {
                this.child.onNext(this.value);
                this.value = t;
            }
        }
    }
}

