/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.GeneratedMessageV3;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDefinitionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationRequestsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class RouterServerUtil {
    private static final String APPLICATION_ID_PREFIX = "application_";
    private static final String APP_ATTEMPT_ID_PREFIX = "appattempt_";
    private static final String CONTAINER_PREFIX = "container_";
    private static final String EPOCH_PREFIX = "e";
    private static final String RESERVEIDSTR_PREFIX = "reservation_";
    public static final Logger LOG = LoggerFactory.getLogger(RouterServerUtil.class);

    private RouterServerUtil() {
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowException(Throwable t, String errMsgFormat, Object ... args) throws YarnException {
        String msg = String.format(errMsgFormat, args);
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(msg, t);
            LOG.error(newErrMsg, t);
            throw new YarnException(newErrMsg, t);
        }
        LOG.error(msg);
        throw new YarnException(msg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowException(String errMsg, Throwable t) throws YarnException {
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(errMsg, t);
            LOG.error(newErrMsg, t);
            throw new YarnException(newErrMsg, t);
        }
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowException(String errMsg) throws YarnException {
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    private static String getErrorMsg(String errMsg, Throwable t) {
        if (t.getMessage() != null) {
            return errMsg + "" + t.getMessage();
        }
        return errMsg;
    }

    public static <R> R createRequestInterceptorChain(Configuration conf, String pipeLineClassName, String interceptorClassName, Class<R> clazz) {
        List<String> interceptorClassNames = RouterServerUtil.getInterceptorClassNames(conf, pipeLineClassName, interceptorClassName);
        R pipeline = null;
        Object current = null;
        for (String className : interceptorClassNames) {
            try {
                Class interceptorClass = conf.getClassByName(className);
                if (clazz.isAssignableFrom(interceptorClass)) {
                    Object interceptorInstance = ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)conf);
                    if (pipeline == null) {
                        pipeline = clazz.cast(interceptorInstance);
                        current = clazz.cast(interceptorInstance);
                        continue;
                    }
                    Method method = clazz.getMethod("setNextInterceptor", clazz);
                    method.invoke(current, interceptorInstance);
                    current = clazz.cast(interceptorInstance);
                    continue;
                }
                LOG.error("Class: {} not instance of {}.", (Object)className, (Object)clazz.getCanonicalName());
                throw new YarnRuntimeException("Class: " + className + " not instance of " + clazz.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Could not instantiate RequestInterceptor: {}", (Object)className, (Object)e);
                throw new YarnRuntimeException("Could not instantiate RequestInterceptor: " + className, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("RequestInterceptor {} call setNextInterceptor error.", (Object)className, (Object)e);
                throw new YarnRuntimeException("RequestInterceptor " + className + " call setNextInterceptor error.", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error("RequestInterceptor {} does not contain the method setNextInterceptor.", (Object)className);
                throw new YarnRuntimeException("RequestInterceptor " + className + " does not contain the method setNextInterceptor.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("RequestInterceptor {} call the method setNextInterceptor does not have access.", (Object)className);
                throw new YarnRuntimeException("RequestInterceptor " + className + " call the method setNextInterceptor does not have access.", (Throwable)e);
            }
        }
        if (pipeline == null) {
            throw new YarnRuntimeException("RequestInterceptor pipeline is not configured in the system.");
        }
        return pipeline;
    }

    private static List<String> getInterceptorClassNames(Configuration conf, String pipeLineClass, String interceptorClass) {
        String configuredInterceptorClassNames = conf.get(pipeLineClass, interceptorClass);
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        Collection tempList = StringUtils.getStringCollection((String)configuredInterceptorClassNames);
        for (String item : tempList) {
            interceptorClassNames.add(item.trim());
        }
        return interceptorClassNames;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowIOException(String errMsg, Throwable t) throws IOException {
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(errMsg, t);
            LOG.error(newErrMsg, t);
            throw new IOException(newErrMsg, t);
        }
        LOG.error(errMsg);
        throw new IOException(errMsg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowIOException(Throwable t, String errMsgFormat, Object ... args) throws IOException {
        String msg = String.format(errMsgFormat, args);
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(msg, t);
            LOG.error(newErrMsg, t);
            throw new IOException(newErrMsg, t);
        }
        LOG.error(msg);
        throw new IOException(msg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowRunTimeException(String errMsg, Throwable t) throws RuntimeException {
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(errMsg, t);
            LOG.error(newErrMsg, t);
            throw new RuntimeException(newErrMsg, t);
        }
        LOG.error(errMsg);
        throw new RuntimeException(errMsg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void logAndThrowRunTimeException(Throwable t, String errMsgFormat, Object ... args) throws RuntimeException {
        String msg = String.format(errMsgFormat, args);
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(msg, t);
            LOG.error(newErrMsg, t);
            throw new RuntimeException(newErrMsg, t);
        }
        LOG.error(msg);
        throw new RuntimeException(msg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static RuntimeException logAndReturnRunTimeException(Throwable t, String errMsgFormat, Object ... args) {
        String msg = String.format(errMsgFormat, args);
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(msg, t);
            LOG.error(newErrMsg, t);
            return new RuntimeException(newErrMsg, t);
        }
        LOG.error(msg);
        return new RuntimeException(msg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static RuntimeException logAndReturnRunTimeException(String errMsgFormat, Object ... args) {
        return RouterServerUtil.logAndReturnRunTimeException(null, errMsgFormat, args);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static YarnRuntimeException logAndReturnYarnRunTimeException(Throwable t, String errMsgFormat, Object ... args) {
        String msg = String.format(errMsgFormat, args);
        if (t != null) {
            String newErrMsg = RouterServerUtil.getErrorMsg(msg, t);
            LOG.error(newErrMsg, t);
            return new YarnRuntimeException(newErrMsg, t);
        }
        LOG.error(msg);
        return new YarnRuntimeException(msg);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void validateApplicationId(String applicationId) throws IllegalArgumentException {
        if (applicationId == null || applicationId.isEmpty()) {
            throw new IllegalArgumentException("Parameter error, the appId is empty or null.");
        }
        if (!applicationId.startsWith(APPLICATION_ID_PREFIX)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + applicationId + ". The valid ApplicationId should start with prefix application");
        }
        int pos1 = APPLICATION_ID_PREFIX.length() - 1;
        int pos2 = applicationId.indexOf(95, pos1 + 1);
        if (pos2 < 0) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + applicationId);
        }
        String rmId = applicationId.substring(pos1 + 1, pos2);
        String appId = applicationId.substring(pos2 + 1);
        if (!NumberUtils.isDigits((String)rmId) || !NumberUtils.isDigits((String)appId)) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + applicationId);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void validateApplicationAttemptId(String appAttemptId) throws IllegalArgumentException {
        if (appAttemptId == null || appAttemptId.isEmpty()) {
            throw new IllegalArgumentException("Parameter error, the appAttemptId is empty or null.");
        }
        if (!appAttemptId.startsWith(APP_ATTEMPT_ID_PREFIX)) {
            throw new IllegalArgumentException("Invalid AppAttemptId prefix: " + appAttemptId);
        }
        int pos1 = APP_ATTEMPT_ID_PREFIX.length() - 1;
        int pos2 = appAttemptId.indexOf(95, pos1 + 1);
        if (pos2 < 0) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptId);
        }
        int pos3 = appAttemptId.indexOf(95, pos2 + 1);
        if (pos3 < 0) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptId);
        }
        String rmId = appAttemptId.substring(pos1 + 1, pos2);
        String appId = appAttemptId.substring(pos2 + 1, pos3);
        String attemptId = appAttemptId.substring(pos3 + 1);
        if (!(NumberUtils.isDigits((String)rmId) && NumberUtils.isDigits((String)appId) && NumberUtils.isDigits((String)attemptId))) {
            throw new IllegalArgumentException("Invalid AppAttemptId: " + appAttemptId);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void validateContainerId(String containerId) throws IllegalArgumentException {
        int pos2;
        if (containerId == null || containerId.isEmpty()) {
            throw new IllegalArgumentException("Parameter error, the containerId is empty or null.");
        }
        if (!containerId.startsWith(CONTAINER_PREFIX)) {
            throw new IllegalArgumentException("Invalid ContainerId prefix: " + containerId);
        }
        int pos1 = CONTAINER_PREFIX.length() - 1;
        String epoch = "0";
        if (containerId.regionMatches(pos1 + 1, EPOCH_PREFIX, 0, EPOCH_PREFIX.length())) {
            String epochStr;
            pos2 = containerId.indexOf(95, pos1 + 1);
            if (pos2 < 0) {
                throw new IllegalArgumentException("Invalid ContainerId: " + containerId);
            }
            epoch = epochStr = containerId.substring(pos1 + 1 + EPOCH_PREFIX.length(), pos2);
            pos1 = pos2;
        }
        if ((pos2 = containerId.indexOf(95, pos1 + 1)) < 0) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerId);
        }
        int pos3 = containerId.indexOf(95, pos2 + 1);
        if (pos3 < 0) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerId);
        }
        int pos4 = containerId.indexOf(95, pos3 + 1);
        if (pos4 < 0) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerId);
        }
        String appId = containerId.substring(pos2 + 1, pos3);
        String clusterTimestamp = containerId.substring(pos1 + 1, pos2);
        String attemptId = containerId.substring(pos3 + 1, pos4);
        String cid = containerId.substring(pos4 + 1);
        if (!(NumberUtils.isDigits((String)appId) && NumberUtils.isDigits((String)clusterTimestamp) && NumberUtils.isDigits((String)attemptId) && NumberUtils.isDigits((String)cid) && NumberUtils.isDigits((String)epoch))) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerId);
        }
    }

    public static boolean isAllowedDelegationTokenOp() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            return EnumSet.of(UserGroupInformation.AuthenticationMethod.KERBEROS, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, UserGroupInformation.AuthenticationMethod.CERTIFICATE).contains(UserGroupInformation.getCurrentUser().getRealAuthenticationMethod());
        }
        return true;
    }

    public static String getRenewerForToken(Token<RMDelegationTokenIdentifier> token) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        return loginUser.getUserName().equals(user.getUserName()) ? ((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString() : user.getShortUserName();
    }

    public static UserGroupInformation setupUser(String userName) {
        UserGroupInformation user = null;
        try {
            user = userName == null || userName.trim().isEmpty() ? UserGroupInformation.getCurrentUser() : (UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getLoginUser()) : (userName.equalsIgnoreCase(UserGroupInformation.getCurrentUser().getUserName()) ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getCurrentUser())));
            return user;
        }
        catch (IOException e) {
            throw RouterServerUtil.logAndReturnYarnRunTimeException(e, "Error while creating Router Service for user : %s.", user);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void validateReservationId(String reservationId) throws IllegalArgumentException {
        if (reservationId == null || reservationId.isEmpty()) {
            throw new IllegalArgumentException("Parameter error, the reservationId is empty or null.");
        }
        if (!reservationId.startsWith(RESERVEIDSTR_PREFIX)) {
            throw new IllegalArgumentException("Invalid ReservationId: " + reservationId);
        }
        String[] resFields = reservationId.split("_");
        if (resFields.length != 3) {
            throw new IllegalArgumentException("Invalid ReservationId: " + reservationId);
        }
        String clusterTimestamp = resFields[1];
        String id = resFields[2];
        if (!NumberUtils.isDigits((String)id) || !NumberUtils.isDigits((String)clusterTimestamp)) {
            throw new IllegalArgumentException("Invalid ReservationId: " + reservationId);
        }
    }

    public static ReservationDefinition convertReservationDefinition(ReservationDefinitionInfo definitionInfo) {
        if (definitionInfo == null || definitionInfo.getReservationRequests() == null || definitionInfo.getReservationRequests().getReservationRequest() == null || definitionInfo.getReservationRequests().getReservationRequest().isEmpty()) {
            throw new RuntimeException("definitionInfo Or ReservationRequests is Null.");
        }
        long arrival = definitionInfo.getArrival();
        long deadline = definitionInfo.getDeadline();
        String name = definitionInfo.getReservationName();
        String recurrenceExpression = definitionInfo.getRecurrenceExpression();
        Priority priority = Priority.newInstance((int)definitionInfo.getPriority());
        ArrayList<ReservationRequest> reservationRequestList = new ArrayList<ReservationRequest>();
        ReservationRequestsInfo reservationRequestsInfo = definitionInfo.getReservationRequests();
        ArrayList reservationRequestInfos = reservationRequestsInfo.getReservationRequest();
        for (ReservationRequestInfo resRequestInfo : reservationRequestInfos) {
            ResourceInfo resourceInfo = resRequestInfo.getCapability();
            Resource capability = Resource.newInstance((long)resourceInfo.getMemorySize(), (int)resourceInfo.getvCores());
            ReservationRequest reservationRequest = ReservationRequest.newInstance((Resource)capability, (int)resRequestInfo.getNumContainers(), (int)resRequestInfo.getMinConcurrency(), (long)resRequestInfo.getDuration());
            reservationRequestList.add(reservationRequest);
        }
        ReservationRequestInterpreter[] values = ReservationRequestInterpreter.values();
        ReservationRequestInterpreter reservationRequestInterpreter = values[reservationRequestsInfo.getReservationRequestsInterpreter()];
        ReservationRequests reservationRequests = ReservationRequests.newInstance(reservationRequestList, (ReservationRequestInterpreter)reservationRequestInterpreter);
        ReservationDefinition definition = ReservationDefinition.newInstance((long)arrival, (long)deadline, (ReservationRequests)reservationRequests, (String)name, (String)recurrenceExpression, (Priority)priority);
        return definition;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void checkAppSubmissionContext(ApplicationSubmissionContextPBImpl appContext, Configuration conf) throws IOException, YarnException {
        int bytesOfSerializedSize;
        double bytesOfMaxAscSize = conf.getStorageSize("yarn.router.asc-interceptor-max-size", "1MB", StorageUnit.BYTES);
        if (appContext != null && (double)(bytesOfSerializedSize = appContext.getProto().getSerializedSize()) >= bytesOfMaxAscSize) {
            RouterServerUtil.logContainerLaunchContext(appContext);
            String applicationId = appContext.getApplicationId().toString();
            String limit = StringUtils.byteDesc((long)((long)bytesOfMaxAscSize));
            String appContentSize = StringUtils.byteDesc((long)bytesOfSerializedSize);
            String errMsg = String.format("The size of the ApplicationSubmissionContext of the application %s is above the limit %s, size = %s.", applicationId, limit, appContentSize);
            LOG.error(errMsg);
            throw new YarnException(errMsg);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    private static void logContainerLaunchContext(ApplicationSubmissionContextPBImpl appContext) throws IOException {
        if (appContext == null || appContext.getAMContainerSpec() == null || !(appContext.getAMContainerSpec() instanceof ContainerLaunchContextPBImpl)) {
            return;
        }
        ContainerLaunchContext launchContext = appContext.getAMContainerSpec();
        ContainerLaunchContextPBImpl clc = (ContainerLaunchContextPBImpl)launchContext;
        LOG.warn("ContainerLaunchContext size: {}.", (Object)clc.getProto().getSerializedSize());
        List lrs = clc.getProto().getLocalResourcesList();
        RouterServerUtil.logContainerLaunchContext("LocalResource size: {}. Length: {}.", lrs);
        List envs = clc.getProto().getEnvironmentList();
        RouterServerUtil.logContainerLaunchContext("Environment size: {}. Length: {}.", envs);
        List cmds = clc.getCommands();
        if (CollectionUtils.isNotEmpty((Collection)cmds)) {
            LOG.warn("Commands size: {}. Length: {}.", (Object)cmds.size(), (Object)RouterServerUtil.serialize(cmds).length);
        }
        List serviceData = clc.getProto().getServiceDataList();
        RouterServerUtil.logContainerLaunchContext("ServiceData size: {}. Length: {}.", serviceData);
        List acls = clc.getProto().getApplicationACLsList();
        RouterServerUtil.logContainerLaunchContext("ACLs size: {}. Length: {}.", acls);
    }

    private static <R extends GeneratedMessageV3> void logContainerLaunchContext(String format, List<R> lists) {
        if (CollectionUtils.isNotEmpty(lists)) {
            int sumLength = 0;
            for (GeneratedMessageV3 item : lists) {
                sumLength += item.getSerializedSize();
            }
            LOG.warn(format, (Object)lists.size(), (Object)sumLength);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    private static byte[] serialize(Object obj) throws IOException {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            try (ObjectOutputStream o = new ObjectOutputStream(b);){
                o.writeObject(obj);
            }
            byte[] byArray = b.toByteArray();
            return byArray;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationSubmissionContext getTrimmedAppSubmissionContext(ApplicationSubmissionContext actualContext) {
        if (actualContext == null) {
            return null;
        }
        ApplicationSubmissionContext trimmedContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        trimmedContext.setApplicationId(actualContext.getApplicationId());
        trimmedContext.setApplicationName(actualContext.getApplicationName());
        trimmedContext.setQueue(actualContext.getQueue());
        trimmedContext.setPriority(actualContext.getPriority());
        trimmedContext.setApplicationType(actualContext.getApplicationType());
        trimmedContext.setNodeLabelExpression(actualContext.getNodeLabelExpression());
        trimmedContext.setLogAggregationContext(actualContext.getLogAggregationContext());
        trimmedContext.setApplicationTags(actualContext.getApplicationTags());
        trimmedContext.setApplicationSchedulingPropertiesMap(actualContext.getApplicationSchedulingPropertiesMap());
        trimmedContext.setKeepContainersAcrossApplicationAttempts(actualContext.getKeepContainersAcrossApplicationAttempts());
        trimmedContext.setApplicationTimeouts(actualContext.getApplicationTimeouts());
        return trimmedContext;
    }

    public static boolean isRouterWebProxyEnable(Configuration conf) {
        return conf.getBoolean("yarn.router.webapp.proxy.enable", true);
    }

    public static boolean checkPolicyManagerValid(String policyManager, List<String> supportWeightList) throws YarnException {
        return supportWeightList.contains(policyManager);
    }
}

