/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupMapping;
import org.apache.hadoop.util.StringUtils;

public class UsersACLsManager {
    private Map<String, UserGroupMapping> usersAclMapping = new HashMap<String, UserGroupMapping>();
    private Map<String, UserGroupMapping> groupAclMapping = new HashMap<String, UserGroupMapping>();

    public UsersACLsManager(Configuration conf) {
        String userACLs = conf.get("hadoop.users.acl.mapping", "").trim();
        if (!userACLs.isEmpty()) {
            this.parseMapping(userACLs);
        }
    }

    private void parseMapping(String userACLs) {
        Collection<String> mappingParts = StringUtils.getStringCollection(userACLs, ";");
        for (String part : mappingParts) {
            UserGroupMapping userGroupValue;
            String[] mappingPart = StringUtils.getStrings(part.trim(), "=");
            if (mappingPart == null || mappingPart.length != 2) {
                throw new HadoopIllegalArgumentException("Configuration yarn.users.acl.mapping is invalid");
            }
            Map<UserGroupMapping.EntityType, List<String>> reqLists = UsersACLsManager.parseUserGroupLists(mappingPart[0]);
            Map<UserGroupMapping.EntityType, List<String>> mapLists = UsersACLsManager.parseUserGroupLists(mappingPart[1]);
            for (String userName : reqLists.get((Object)UserGroupMapping.EntityType.USER)) {
                userGroupValue = new UserGroupMapping(UserGroupMapping.EntityType.USER, userName, mapLists.get((Object)UserGroupMapping.EntityType.USER), mapLists.get((Object)UserGroupMapping.EntityType.GROUP));
                this.usersAclMapping.put(userName, userGroupValue);
            }
            for (String groupName : reqLists.get((Object)UserGroupMapping.EntityType.GROUP)) {
                userGroupValue = new UserGroupMapping(UserGroupMapping.EntityType.GROUP, groupName, mapLists.get((Object)UserGroupMapping.EntityType.USER), mapLists.get((Object)UserGroupMapping.EntityType.GROUP));
                this.groupAclMapping.put(groupName, userGroupValue);
            }
        }
    }

    private static Map<UserGroupMapping.EntityType, List<String>> parseUserGroupLists(String userGroupStr) {
        HashMap<UserGroupMapping.EntityType, List<String>> parsedStringMap = new HashMap<UserGroupMapping.EntityType, List<String>>();
        ArrayList<String> userList = new ArrayList<String>();
        ArrayList<String> groupList = new ArrayList<String>();
        Collection<String> userGroupList = StringUtils.getStringCollection(userGroupStr.trim(), ",");
        for (String entity : userGroupList) {
            String[] reqEntity = StringUtils.getStrings(entity.trim(), ":");
            if (reqEntity == null) {
                throw new HadoopIllegalArgumentException("User/group entity is invalid: " + entity.trim());
            }
            if (reqEntity.length != 2 || !reqEntity[0].equals(UserGroupMapping.EntityType.USER.toString()) && !reqEntity[0].equals(UserGroupMapping.EntityType.GROUP.toString())) {
                throw new HadoopIllegalArgumentException("User/group entity is invalid: " + reqEntity[0]);
            }
            if (reqEntity[0].equals(UserGroupMapping.EntityType.USER.toString())) {
                userList.add(reqEntity[1]);
            }
            if (!reqEntity[0].equals(UserGroupMapping.EntityType.GROUP.toString())) continue;
            groupList.add(reqEntity[1]);
        }
        parsedStringMap.put(UserGroupMapping.EntityType.USER, userList);
        parsedStringMap.put(UserGroupMapping.EntityType.GROUP, groupList);
        return parsedStringMap;
    }

    public boolean isUsersACLEnable() {
        return !this.usersAclMapping.isEmpty() || !this.groupAclMapping.isEmpty();
    }

    public boolean checkUserAccess(String reqUser, String owner) {
        return this.checkUserAccess(UserGroupInformation.createRemoteUser(reqUser), owner);
    }

    public boolean checkUserAccess(UserGroupInformation reqUser, String owner) {
        if (!this.usersAclMapping.isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()) != null && !this.usersAclMapping.get(reqUser.getShortUserName()).getUserList().isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()).getUserList().contains(owner)) {
            return true;
        }
        List<String> ownerGroups = UserGroupInformation.createRemoteUser(owner).getGroups();
        if (!this.usersAclMapping.isEmpty() && this.usersAclMapping.get(reqUser.getShortUserName()) != null && !this.usersAclMapping.get(reqUser.getShortUserName()).getGroupList().isEmpty()) {
            for (String expectedGroup : ownerGroups) {
                if (!this.usersAclMapping.get(reqUser.getShortUserName()).getGroupList().contains(expectedGroup)) continue;
                return true;
            }
        }
        if (!this.groupAclMapping.isEmpty()) {
            List<String> reqGroups = reqUser.getGroups();
            for (String group : reqGroups) {
                if (this.groupAclMapping.get(group) == null || !this.groupAclMapping.get(group).getUserList().contains(owner)) continue;
                return true;
            }
            for (String group : reqGroups) {
                if (this.groupAclMapping.get(group) == null) continue;
                for (String expectedGroup : ownerGroups) {
                    if (!this.groupAclMapping.get(group).getGroupList().contains(expectedGroup)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

