/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class JobsBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobsBlock(AppContext appCtx) {
        this.appContext = appCtx;
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.h2("Active Jobs").table("#jobs").thead().tr().th(".id", "Job ID").th(".name", "Name").th(".state", "State").th("Map Progress").th("Maps Total").th("Maps Completed").th("Reduce Progress").th("Reduces Total").th("Reduces Completed").__()).__()).tbody();
        for (Job j : this.appContext.getAllJobs().values()) {
            JobInfo job = new JobInfo(j, false);
            ((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)tbody.tr().td().span().$title(String.valueOf(job.getId())).__()).a(this.url(new String[]{"job", job.getId()}), job.getId()).__()).td(job.getName()).td(job.getState()).td().span().$title(job.getMapProgressPercent()).__()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{job.getMapProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", job.getMapProgressPercent(), Character.valueOf('%')})).__()).__()).__()).td(String.valueOf(job.getMapsTotal())).td(String.valueOf(job.getMapsCompleted())).td().span().$title(job.getReduceProgressPercent()).__()).div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{job.getReduceProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", job.getReduceProgressPercent(), Character.valueOf('%')})).__()).__()).__()).td(String.valueOf(job.getReducesTotal())).td(String.valueOf(job.getReducesCompleted())).__();
        }
        ((Hamlet.TABLE)tbody.__()).__();
    }
}

