/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Arrays;
import java.util.Objects;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.RandomNumber;

public final class SampleSet
implements Access1D<Double> {
    private transient double myMax = Double.NaN;
    private transient double myMean = Double.NaN;
    private transient double myMin = Double.NaN;
    private transient double myQuartile1 = Double.NaN;
    private transient double myQuartile2 = Double.NaN;
    private transient double myQuartile3 = Double.NaN;
    private Access1D<?> mySamples;
    private transient double[] mySortedCopy = null;
    private transient double myVariance = Double.NaN;

    public static SampleSet make() {
        return new SampleSet(Primitive64Array.make(4));
    }

    public static SampleSet make(RandomNumber randomNumber, int size) {
        Primitive64Array retVal = Primitive64Array.make(size);
        double[] tmpData = retVal.data;
        for (int i = 0; i < size; ++i) {
            tmpData[i] = randomNumber.doubleValue();
        }
        return new SampleSet(retVal);
    }

    public static SampleSet wrap(Access1D<?> someSamples) {
        return new SampleSet(someSamples);
    }

    private SampleSet() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    SampleSet(Access1D<?> samples) {
        this.mySamples = samples;
        this.reset();
    }

    @Override
    public long count() {
        return this.mySamples.count();
    }

    @Override
    public double doubleValue(long index) {
        return this.mySamples.doubleValue(index);
    }

    @Override
    public Double get(long index) {
        return this.mySamples.doubleValue(index);
    }

    public double getCorrelation(SampleSet anotherSampleSet) {
        double retVal = PrimitiveMath.ZERO;
        double tmpCovar = this.getCovariance(anotherSampleSet);
        if (Double.compare(tmpCovar, PrimitiveMath.ZERO) != 0) {
            double tmpThisStdDev = this.getStandardDeviation();
            double tmpThatStdDev = anotherSampleSet.getStandardDeviation();
            retVal = tmpCovar / (tmpThisStdDev * tmpThatStdDev);
        }
        return retVal;
    }

    public double getCovariance(SampleSet anotherSampleSet) {
        double retVal = PrimitiveMath.ZERO;
        double tmpThisMean = this.getMean();
        double tmpThatMean = anotherSampleSet.getMean();
        long tmpLimit = Math.min(this.mySamples.count(), anotherSampleSet.count());
        Access1D<?> tmpValues = anotherSampleSet.getSamples();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal += (this.mySamples.doubleValue(i) - tmpThisMean) * (tmpValues.doubleValue(i) - tmpThatMean);
        }
        return retVal /= (double)(tmpLimit - 1L);
    }

    public double getFirst() {
        if (this.mySamples.count() > 0L) {
            return this.mySamples.doubleValue(0L);
        }
        return PrimitiveMath.ZERO;
    }

    public double getInterquartileRange() {
        return this.getQuartile3() - this.getQuartile1();
    }

    public double getLargest() {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = this.mySamples.count();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal = PrimitiveFunction.MAX.invoke(retVal, PrimitiveFunction.ABS.invoke(this.mySamples.doubleValue(i)));
        }
        return retVal;
    }

    public double getLast() {
        if (this.mySamples.count() > 0L) {
            return this.mySamples.doubleValue(this.mySamples.count() - 1L);
        }
        return PrimitiveMath.ZERO;
    }

    public double getMaximum() {
        if (Double.isNaN(this.myMax)) {
            this.myMax = Double.NEGATIVE_INFINITY;
            long tmpLimit = this.mySamples.count();
            for (long i = 0L; i < tmpLimit; ++i) {
                this.myMax = PrimitiveFunction.MAX.invoke(this.myMax, this.mySamples.doubleValue(i));
            }
        }
        return this.myMax;
    }

    public double getMean() {
        if (Double.isNaN(this.myMean)) {
            this.myMean = PrimitiveMath.ZERO;
            long tmpLimit = this.mySamples.count();
            for (long i = 0L; i < tmpLimit; ++i) {
                this.myMean += this.mySamples.doubleValue(i);
            }
            this.myMean /= (double)this.mySamples.count();
        }
        return this.myMean;
    }

    public double getMedian() {
        return this.getQuartile2();
    }

    public double getMinimum() {
        if (Double.isNaN(this.myMin)) {
            this.myMin = Double.POSITIVE_INFINITY;
            long tmpLimit = this.mySamples.count();
            for (long i = 0L; i < tmpLimit; ++i) {
                this.myMin = PrimitiveFunction.MIN.invoke(this.myMin, this.mySamples.doubleValue(i));
            }
        }
        return this.myMin;
    }

    public double getQuartile1() {
        if (Double.isNaN(this.myQuartile1)) {
            this.calculateQuartiles();
        }
        return this.myQuartile1;
    }

    public double getQuartile2() {
        if (Double.isNaN(this.myQuartile2)) {
            this.calculateQuartiles();
        }
        return this.myQuartile2;
    }

    public double getQuartile3() {
        if (Double.isNaN(this.myQuartile3)) {
            this.calculateQuartiles();
        }
        return this.myQuartile3;
    }

    public double getSmallest() {
        double retVal = Double.POSITIVE_INFINITY;
        long tmpLimit = this.mySamples.count();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal = PrimitiveFunction.MIN.invoke(retVal, PrimitiveFunction.ABS.invoke(this.mySamples.doubleValue(i)));
        }
        return retVal;
    }

    public double getStandardDeviation() {
        return PrimitiveFunction.SQRT.invoke(this.getVariance());
    }

    public double getStandardScore(long index) {
        return (this.doubleValue(index) - this.getMean()) / this.getStandardDeviation();
    }

    public double getSumOfSquares() {
        double retVal = PrimitiveMath.ZERO;
        double tmpMean = this.getMean();
        long tmpLimit = this.mySamples.count();
        for (long i = 0L; i < tmpLimit; ++i) {
            double tmpVal = this.mySamples.doubleValue(i) - tmpMean;
            retVal += tmpVal * tmpVal;
        }
        return retVal;
    }

    public double[] getValues() {
        return this.mySamples.toRawCopy1D();
    }

    public double getVariance() {
        if (Double.isNaN(this.myVariance)) {
            this.myVariance = this.getCovariance(this);
        }
        return this.myVariance;
    }

    public void reset() {
        this.myMin = Double.NaN;
        this.myMax = Double.NaN;
        this.myMean = Double.NaN;
        this.myVariance = Double.NaN;
        this.myQuartile1 = Double.NaN;
        this.myQuartile2 = Double.NaN;
        this.myQuartile3 = Double.NaN;
        if (this.mySortedCopy != null) {
            Arrays.fill(this.mySortedCopy, Double.POSITIVE_INFINITY);
        }
    }

    public int size() {
        return (int)this.mySamples.count();
    }

    public void swap(Access1D<?> samples) {
        Objects.requireNonNull(samples);
        this.mySamples = samples;
        this.reset();
    }

    public String toString() {
        return "Sample set Size=" + this.count() + ", Mean=" + this.getMean() + ", Var=" + this.getVariance() + ", StdDev=" + this.getStandardDeviation() + ", Min=" + this.getMinimum() + ", Max=" + this.getMaximum();
    }

    private void calculateQuartiles() {
        int tmpSize = (int)this.getSamples().count();
        double[] tmpSortedCopy = this.getSortedCopy();
        block0 : switch (tmpSize) {
            case 0: {
                this.myMin = PrimitiveMath.ZERO;
                this.myMax = PrimitiveMath.ZERO;
                this.myQuartile1 = PrimitiveMath.ZERO;
                this.myQuartile2 = PrimitiveMath.ZERO;
                this.myQuartile3 = PrimitiveMath.ZERO;
                break;
            }
            case 1: {
                this.myMin = tmpSortedCopy[0];
                this.myMax = tmpSortedCopy[0];
                this.myQuartile1 = tmpSortedCopy[0];
                this.myQuartile2 = tmpSortedCopy[0];
                this.myQuartile3 = tmpSortedCopy[0];
                break;
            }
            default: {
                this.myMin = tmpSortedCopy[0];
                this.myMax = tmpSortedCopy[tmpSize - 1];
                int n = tmpSize / 4;
                int r = tmpSize % 4;
                switch (r) {
                    case 1: {
                        this.myQuartile1 = 0.25 * tmpSortedCopy[n - 1] + 0.75 * tmpSortedCopy[n];
                        this.myQuartile2 = tmpSortedCopy[2 * n];
                        this.myQuartile3 = 0.75 * tmpSortedCopy[3 * n] + 0.25 * tmpSortedCopy[3 * n + 1];
                        break block0;
                    }
                    case 2: {
                        this.myQuartile1 = tmpSortedCopy[n];
                        this.myQuartile2 = 0.5 * tmpSortedCopy[2 * n] + 0.5 * tmpSortedCopy[2 * n + 1];
                        this.myQuartile3 = tmpSortedCopy[3 * n + 1];
                        break block0;
                    }
                    case 3: {
                        this.myQuartile1 = 0.75 * tmpSortedCopy[n] + 0.25 * tmpSortedCopy[n + 1];
                        this.myQuartile2 = tmpSortedCopy[2 * n + 1];
                        this.myQuartile3 = 0.25 * tmpSortedCopy[3 * n + 1] + 0.75 * tmpSortedCopy[3 * n + 2];
                        break block0;
                    }
                }
                this.myQuartile1 = 0.5 * tmpSortedCopy[n - 1] + 0.5 * tmpSortedCopy[n];
                this.myQuartile2 = 0.5 * tmpSortedCopy[2 * n - 1] + 0.5 * tmpSortedCopy[2 * n];
                this.myQuartile3 = 0.5 * tmpSortedCopy[3 * n - 1] + 0.5 * tmpSortedCopy[3 * n];
            }
        }
    }

    Access1D<?> getSamples() {
        return this.mySamples;
    }

    double[] getSortedCopy() {
        Access1D<?> tmpSamples = this.getSamples();
        int tmpSamplesCount = (int)tmpSamples.count();
        if (this.mySortedCopy == null || this.mySortedCopy.length < tmpSamplesCount || this.mySortedCopy.length == 0) {
            this.mySortedCopy = tmpSamples.toRawCopy1D();
            Arrays.parallelSort(this.mySortedCopy);
        } else if (this.mySortedCopy[0] == Double.POSITIVE_INFINITY) {
            for (int i = 0; i < tmpSamplesCount; ++i) {
                this.mySortedCopy[i] = tmpSamples.doubleValue(i);
            }
            Arrays.parallelSort(this.mySortedCopy, 0, tmpSamplesCount);
        }
        return this.mySortedCopy;
    }
}

