/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.context.NumberContext;

public final class BigFunction
extends FunctionSet<BigDecimal> {
    public static final Unary ABS = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.abs();
        }
    };
    public static final Unary ACOS = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ACOS.invoke(arg.doubleValue()));
        }
    };
    public static final Unary ACOSH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ACOSH.invoke(arg.doubleValue()));
        }
    };
    public static final Binary ADD = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.add(arg2);
        }
    };
    public static final Unary ASIN = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ASIN.invoke(arg.doubleValue()));
        }
    };
    public static final Unary ASINH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ASINH.invoke(arg.doubleValue()));
        }
    };
    public static final Unary ATAN = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ATAN.invoke(arg.doubleValue()));
        }
    };
    public static final Binary ATAN2 = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return BigDecimal.valueOf(PrimitiveFunction.ATAN2.invoke(arg1.doubleValue(), arg2.doubleValue()));
        }
    };
    public static final Unary ATANH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.ATANH.invoke(arg.doubleValue()));
        }
    };
    public static final Unary CARDINALITY = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.signum() == 0 ? BigMath.ZERO : BigMath.ONE;
        }
    };
    public static final Unary CBRT = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return ROOT.invoke(arg, 3);
        }
    };
    public static final Unary CEIL = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.setScale(0, RoundingMode.CEILING);
        }
    };
    public static final Unary CONJUGATE = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg;
        }
    };
    public static final Unary COS = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.COS.invoke(arg.doubleValue()));
        }
    };
    public static final Unary COSH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.COSH.invoke(arg.doubleValue()));
        }
    };
    public static final Binary DIVIDE = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.divide(arg2, CONTEXT);
        }
    };
    public static final Unary EXP = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.EXP.invoke(arg.doubleValue()));
        }
    };
    public static final Unary EXPM1 = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.EXPM1.invoke(arg.doubleValue()));
        }
    };
    public static final Unary FLOOR = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.setScale(0, RoundingMode.FLOOR);
        }
    };
    public static final Binary HYPOT = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return SQRT.invoke(arg1.multiply(arg1).add(arg2.multiply(arg2)));
        }
    };
    public static final Unary INVERT = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return DIVIDE.invoke(BigMath.ONE, arg);
        }
    };
    public static final Unary LOG = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.LOG.invoke(arg.doubleValue()));
        }
    };
    public static final Unary LOG10 = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.LOG10.invoke(arg.doubleValue()));
        }
    };
    public static final Unary LOG1P = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.LOG1P.invoke(arg.doubleValue()));
        }
    };
    public static final Unary LOGISTIC = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.LOGISTIC.invoke(arg.doubleValue()));
        }
    };
    public static final Unary LOGIT = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.LOGIT.invoke(arg.doubleValue()));
        }
    };
    public static final Binary MAX = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.max(arg2);
        }
    };
    public static final Binary MIN = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.min(arg2);
        }
    };
    public static final Binary MULTIPLY = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.multiply(arg2);
        }
    };
    public static final Unary NEGATE = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.negate();
        }
    };
    public static final Binary POW = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            if (arg1.signum() == 0) {
                return BigMath.ZERO;
            }
            if (arg2.signum() == 0) {
                return BigMath.ONE;
            }
            if (arg2.compareTo(BigMath.ONE) == 0) {
                return arg1;
            }
            if (arg1.signum() == -1) {
                throw new IllegalArgumentException();
            }
            return EXP.invoke(LOG.invoke(arg1).multiply(arg2));
        }
    };
    public static final Parameter POWER = new Parameter(){

        @Override
        public final BigDecimal invoke(BigDecimal arg, int param) {
            return arg.pow(param);
        }
    };
    public static final Unary RINT = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg.setScale(0, CONTEXT.getRoundingMode());
        }
    };
    public static final Parameter ROOT = new Parameter(){

        @Override
        public final BigDecimal invoke(BigDecimal arg, int param) {
            BigDecimal tmpShouldBeZero;
            if (param <= 0) {
                throw new IllegalArgumentException();
            }
            if (param == 1) {
                return arg;
            }
            if (param == 2) {
                return SQRT.invoke(arg);
            }
            BigDecimal tmpArg = arg.round(CONTEXT);
            BigDecimal tmpParam = BigDecimal.valueOf(param);
            BigDecimal retVal = BigMath.ZERO;
            double tmpDoubleArg = arg.doubleValue();
            if (!Double.isInfinite(tmpDoubleArg) && !Double.isNaN(tmpDoubleArg)) {
                retVal = BigDecimal.valueOf(PrimitiveFunction.ROOT.invoke(tmpDoubleArg, param));
            }
            while ((tmpShouldBeZero = retVal.pow(param, CONTEXT).subtract(tmpArg)).signum() != 0) {
                retVal = retVal.subtract(tmpShouldBeZero.divide(tmpParam.multiply(retVal.pow(param - 1)), CONTEXT));
            }
            return retVal;
        }
    };
    public static final Parameter SCALE = new Parameter(){

        @Override
        public final BigDecimal invoke(BigDecimal arg, int param) {
            return arg.setScale(param, CONTEXT.getRoundingMode());
        }
    };
    public static final Unary SIGNUM = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            switch (arg.signum()) {
                case 1: {
                    return BigMath.ONE;
                }
                case -1: {
                    return BigMath.ONE.negate();
                }
            }
            return BigMath.ZERO;
        }
    };
    public static final Unary SIN = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.SIN.invoke(arg.doubleValue()));
        }
    };
    public static final Unary SINH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.SINH.invoke(arg.doubleValue()));
        }
    };
    public static final Unary SQRT = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            BigDecimal tmpShouldBeZero;
            BigDecimal tmpArg = arg.round(CONTEXT);
            BigDecimal retVal = BigMath.ZERO;
            double tmpDoubleArg = arg.doubleValue();
            if (!Double.isInfinite(tmpDoubleArg) && !Double.isNaN(tmpDoubleArg)) {
                retVal = BigDecimal.valueOf(PrimitiveFunction.SQRT.invoke(tmpDoubleArg));
            }
            while ((tmpShouldBeZero = retVal.multiply(retVal, CONTEXT).subtract(tmpArg)).signum() != 0) {
                retVal = retVal.subtract(tmpShouldBeZero.divide(BigMath.TWO.multiply(retVal), CONTEXT));
            }
            return retVal;
        }
    };
    public static final Unary SQRT1PX2 = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return SQRT.invoke(BigMath.ONE.add(arg.multiply(arg)));
        }
    };
    public static final Binary SUBTRACT = new Binary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg1, BigDecimal arg2) {
            return arg1.subtract(arg2);
        }
    };
    public static final Unary TAN = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.TAN.invoke(arg.doubleValue()));
        }
    };
    public static final Unary TANH = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return BigDecimal.valueOf(PrimitiveFunction.TANH.invoke(arg.doubleValue()));
        }
    };
    public static final Unary VALUE = new Unary(){

        @Override
        public final BigDecimal invoke(BigDecimal arg) {
            return arg;
        }
    };
    private static final MathContext CONTEXT = MathContext.DECIMAL128;
    private static final BigFunction SET = new BigFunction();

    public static BigFunction getSet() {
        return SET;
    }

    private BigFunction() {
    }

    @Override
    public UnaryFunction<BigDecimal> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<BigDecimal> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<BigDecimal> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<BigDecimal> add() {
        return ADD;
    }

    @Override
    public UnaryFunction<BigDecimal> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<BigDecimal> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<BigDecimal> atan() {
        return ATAN;
    }

    @Override
    public BinaryFunction<BigDecimal> atan2() {
        return ATAN2;
    }

    @Override
    public UnaryFunction<BigDecimal> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<BigDecimal> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<BigDecimal> cbrt() {
        return CBRT;
    }

    @Override
    public UnaryFunction<BigDecimal> ceil() {
        return CEIL;
    }

    @Override
    public UnaryFunction<BigDecimal> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<BigDecimal> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<BigDecimal> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<BigDecimal> divide() {
        return DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> context.enforce((BigDecimal)t);
    }

    @Override
    public UnaryFunction<BigDecimal> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<BigDecimal> expm1() {
        return EXPM1;
    }

    @Override
    public UnaryFunction<BigDecimal> floor() {
        return FLOOR;
    }

    @Override
    public BinaryFunction<BigDecimal> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<BigDecimal> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<BigDecimal> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<BigDecimal> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<BigDecimal> log1p() {
        return LOG1P;
    }

    @Override
    public UnaryFunction<BigDecimal> logistic() {
        return LOGISTIC;
    }

    @Override
    public UnaryFunction<BigDecimal> logit() {
        return LOGIT;
    }

    @Override
    public BinaryFunction<BigDecimal> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<BigDecimal> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<BigDecimal> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<BigDecimal> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<BigDecimal> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<BigDecimal> power() {
        return POWER;
    }

    @Override
    public UnaryFunction<BigDecimal> rint() {
        return RINT;
    }

    @Override
    public ParameterFunction<BigDecimal> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<BigDecimal> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<BigDecimal> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<BigDecimal> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<BigDecimal> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<BigDecimal> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<BigDecimal> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<BigDecimal> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<BigDecimal> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<BigDecimal> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<BigDecimal> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<BigDecimal> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(BigDecimal.valueOf(arg)).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<BigDecimal> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(BigDecimal.valueOf(arg), param).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<BigDecimal> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(BigDecimal.valueOf(arg1), BigDecimal.valueOf(arg2)).doubleValue();
        }
    }
}

