/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RouterGenericManager;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.NameserviceManager;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateManager;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDestinationResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RefreshMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolClientSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolClientSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RouterAdmin
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdmin.class);
    private RouterClient client;
    private static final Pattern SLASHES = Pattern.compile("/+");

    public static void main(String[] argv) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        RouterAdmin admin = new RouterAdmin((Configuration)conf);
        int res = ToolRunner.run((Tool)admin, (String[])argv);
        System.exit(res);
    }

    public RouterAdmin(Configuration conf) {
        super(conf);
    }

    public void printUsage() {
        String usage = this.getUsage(null);
        System.out.println(usage);
    }

    private void printUsage(String cmd) {
        String usage = this.getUsage(cmd);
        System.out.println(usage);
    }

    private String getUsage(String cmd) {
        if (cmd == null) {
            String[] commands = new String[]{"-add", "-update", "-rm", "-ls", "-getDestination", "-setQuota", "-setStorageTypeQuota", "-clrQuota", "-clrStorageTypeQuota", "-safemode", "-nameservice", "-getDisabledNameservices", "-refresh", "-refreshRouterArgs", "-refreshSuperUserGroupsConfiguration", "-refreshCallQueue"};
            StringBuilder usage = new StringBuilder();
            usage.append("Usage: hdfs dfsrouteradmin :\n");
            for (int i = 0; i < commands.length; ++i) {
                usage.append(this.getUsage(commands[i]));
                if (i + 1 >= commands.length) continue;
                usage.append("\n");
            }
            return usage.toString();
        }
        if (cmd.equals("-add")) {
            return "\t[-add <source> <nameservice1, nameservice2, ...> <destination> [-readonly] [-faulttolerant] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]";
        }
        if (cmd.equals("-update")) {
            return "\t[-update <source> [<nameservice1, nameservice2, ...> <destination>] [-readonly true|false] [-faulttolerant true|false] [-order HASH|LOCAL|RANDOM|HASH_ALL|SPACE] -owner <owner> -group <group> -mode <mode>]";
        }
        if (cmd.equals("-rm")) {
            return "\t[-rm <source>]";
        }
        if (cmd.equals("-ls")) {
            return "\t[-ls [-d] <path>]";
        }
        if (cmd.equals("-getDestination")) {
            return "\t[-getDestination <path>]";
        }
        if (cmd.equals("-setQuota")) {
            return "\t[-setQuota <path> -nsQuota <nsQuota> -ssQuota <quota in bytes or quota size string>]";
        }
        if (cmd.equals("-setStorageTypeQuota")) {
            return "\t[-setStorageTypeQuota <path> -storageType <storage type> <quota in bytes or quota size string>]";
        }
        if (cmd.equals("-clrQuota")) {
            return "\t[-clrQuota <path>]";
        }
        if (cmd.equals("-clrStorageTypeQuota")) {
            return "\t[-clrStorageTypeQuota <path>]";
        }
        if (cmd.equals("-safemode")) {
            return "\t[-safemode enter | leave | get]";
        }
        if (cmd.equals("-nameservice")) {
            return "\t[-nameservice enable | disable <nameservice>]";
        }
        if (cmd.equals("-getDisabledNameservices")) {
            return "\t[-getDisabledNameservices]";
        }
        if (cmd.equals("-refresh")) {
            return "\t[-refresh]";
        }
        if (cmd.equals("-refreshRouterArgs")) {
            return "\t[-refreshRouterArgs <host:ipc_port> <key> [arg1..argn]]";
        }
        if (cmd.equals("-refreshSuperUserGroupsConfiguration")) {
            return "\t[-refreshSuperUserGroupsConfiguration]";
        }
        if (cmd.equals("-refreshCallQueue")) {
            return "\t[-refreshCallQueue]";
        }
        return this.getUsage(null);
    }

    private void validateMax(String[] arg) {
        if (arg[0].equals("-ls")) {
            if (arg.length > 3) {
                throw new IllegalArgumentException("Too many arguments, Max=2 argument allowed");
            }
        } else if (arg[0].equals("-getDestination")) {
            if (arg.length > 2) {
                throw new IllegalArgumentException("Too many arguments, Max=1 argument allowed only");
            }
        } else if (arg[0].equals("-safemode")) {
            if (arg.length > 2) {
                throw new IllegalArgumentException("Too many arguments, Max=1 argument allowed only");
            }
        } else if (arg[0].equals("-nameservice")) {
            if (arg.length > 3) {
                throw new IllegalArgumentException("Too many arguments, Max=2 arguments allowed");
            }
        } else if (arg[0].equals("-getDisabledNameservices") ? arg.length > 1 : (arg[0].equals("-refreshSuperUserGroupsConfiguration") ? arg.length > 1 : arg[0].equals("-refreshCallQueue") && arg.length > 1)) {
            throw new IllegalArgumentException("No arguments allowed");
        }
    }

    private boolean validateMin(String[] argv) {
        String cmd = argv[0];
        return !("-add".equals(cmd) ? argv.length < 4 : ("-update".equals(cmd) ? argv.length < 4 : ("-rm".equals(cmd) ? argv.length < 2 : ("-getDestination".equals(cmd) ? argv.length < 2 : ("-setQuota".equals(cmd) ? argv.length < 4 : ("-setStorageTypeQuota".equals(cmd) ? argv.length < 5 : ("-clrQuota".equals(cmd) ? argv.length < 2 : ("-clrStorageTypeQuota".equals(cmd) ? argv.length < 2 : ("-safemode".equals(cmd) ? argv.length < 2 : ("-nameservice".equals(cmd) ? argv.length < 3 : "-refreshRouterArgs".equals(cmd) && argv.length < 2))))))))));
    }

    public int run(String[] argv) throws Exception {
        Throwable debugException;
        int exitCode;
        block41: {
            if (argv.length < 1) {
                System.err.println("Not enough parameters specified");
                this.printUsage();
                return -1;
            }
            exitCode = -1;
            int i = 0;
            String cmd = argv[i++];
            if (!this.validateMin(argv)) {
                System.err.println("Not enough parameters specificed for cmd " + cmd);
                this.printUsage(cmd);
                return exitCode;
            }
            String address = null;
            try {
                address = this.getConf().getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
                InetSocketAddress routerSocket = NetUtils.createSocketAddr((String)address);
                this.client = new RouterClient(routerSocket, this.getConf());
            }
            catch (RPC.VersionMismatch v) {
                System.err.println("Version mismatch between client and server... command aborted");
                return exitCode;
            }
            catch (IOException e) {
                System.err.println("Bad connection to Router... command aborted");
                return exitCode;
            }
            debugException = null;
            exitCode = 0;
            try {
                this.validateMax(argv);
                if ("-add".equals(cmd)) {
                    if (this.addMount(argv, i)) {
                        System.out.println("Successfully added mount point " + argv[i]);
                    } else {
                        exitCode = -1;
                    }
                    break block41;
                }
                if ("-update".equals(cmd)) {
                    if (this.updateMount(argv, i)) {
                        System.out.println("Successfully updated mount point " + argv[i]);
                        System.out.println("WARN: Changing order/destinations may lead to inconsistencies");
                    } else {
                        exitCode = -1;
                    }
                    break block41;
                }
                if ("-rm".equals(cmd)) {
                    while (i < argv.length) {
                        try {
                            if (this.removeMount(argv[i])) {
                                System.out.println("Successfully removed mount point " + argv[i]);
                            }
                        }
                        catch (IOException e) {
                            exitCode = -1;
                            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
                        }
                        ++i;
                    }
                    break block41;
                }
                if ("-ls".equals(cmd)) {
                    this.listMounts(argv, i);
                    break block41;
                }
                if ("-getDestination".equals(cmd)) {
                    this.getDestination(argv[i]);
                    break block41;
                }
                if ("-setQuota".equals(cmd)) {
                    if (this.setQuota(argv, i)) {
                        System.out.println("Successfully set quota for mount point " + argv[i]);
                    }
                    break block41;
                }
                if ("-setStorageTypeQuota".equals(cmd)) {
                    if (this.setStorageTypeQuota(argv, i)) {
                        System.out.println("Successfully set storage type quota for mount point " + argv[i]);
                    }
                    break block41;
                }
                if ("-clrQuota".equals(cmd)) {
                    while (i < argv.length) {
                        if (!this.clrQuota(argv[i])) continue;
                        System.out.println("Successfully clear quota for mount point " + argv[i]);
                        ++i;
                    }
                    break block41;
                }
                if ("-clrStorageTypeQuota".equals(cmd)) {
                    while (i < argv.length) {
                        if (!this.clrStorageTypeQuota(argv[i])) continue;
                        System.out.println("Successfully clear storage type quota for mount point " + argv[i]);
                        ++i;
                    }
                    break block41;
                }
                if ("-safemode".equals(cmd)) {
                    this.manageSafeMode(argv[i]);
                    break block41;
                }
                if ("-nameservice".equals(cmd)) {
                    String subcmd = argv[i];
                    String nsId = argv[i + 1];
                    this.manageNameservice(subcmd, nsId);
                    break block41;
                }
                if ("-getDisabledNameservices".equals(cmd)) {
                    this.getDisabledNameservices();
                    break block41;
                }
                if ("-refresh".equals(cmd)) {
                    this.refresh(address);
                    break block41;
                }
                if ("-refreshRouterArgs".equals(cmd)) {
                    exitCode = this.genericRefresh(argv, i);
                    break block41;
                }
                if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                    exitCode = this.refreshSuperUserGroupsConfiguration();
                    break block41;
                }
                if ("-refreshCallQueue".equals(cmd)) {
                    exitCode = this.refreshCallQueue();
                    break block41;
                }
                throw new IllegalArgumentException("Unknown Command: " + cmd);
            }
            catch (IllegalArgumentException arge) {
                debugException = arge;
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
                this.printUsage(cmd);
            }
            catch (RemoteException e) {
                exitCode = -1;
                debugException = e;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    System.err.println(cmd.substring(1) + ": " + content[0]);
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                    e.printStackTrace();
                    debugException = ex;
                }
            }
            catch (IOException ioe) {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + ioe.getLocalizedMessage());
                this.printUsage(cmd);
            }
            catch (Exception e) {
                exitCode = -1;
                debugException = e;
                System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (debugException != null) {
            LOG.debug("Exception encountered", debugException);
        }
        return exitCode;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException {
        RouterGenericManager proxy = this.client.getRouterGenericManager();
        String address = this.getConf().getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
        if (proxy.refreshSuperUserGroupsConfiguration()) {
            System.out.println("Successfully updated superuser proxy groups on router " + address);
            return 0;
        }
        return -1;
    }

    private void refresh(String address) throws IOException {
        if (this.refreshRouterCache()) {
            System.out.println("Successfully updated mount table cache on router " + address);
        }
    }

    private boolean refreshRouterCache() throws IOException {
        RefreshMountTableEntriesResponse response = this.client.getMountTableManager().refreshMountTableEntries(RefreshMountTableEntriesRequest.newInstance());
        return response.getResult();
    }

    public boolean addMount(String[] parameters, int i) throws IOException {
        String mount = parameters[i++];
        String[] nss = parameters[i++].split(",");
        String dest = parameters[i++];
        boolean readOnly = false;
        boolean faultTolerant = false;
        String owner = null;
        String group = null;
        FsPermission mode = null;
        DestinationOrder order = DestinationOrder.HASH;
        while (i < parameters.length) {
            if (parameters[i].equals("-readonly")) {
                readOnly = true;
            } else if (parameters[i].equals("-faulttolerant")) {
                faultTolerant = true;
            } else if (parameters[i].equals("-order")) {
                ++i;
                try {
                    order = DestinationOrder.valueOf(parameters[i]);
                }
                catch (Exception e) {
                    System.err.println("Cannot parse order: " + parameters[i]);
                }
            } else if (parameters[i].equals("-owner")) {
                owner = parameters[++i];
            } else if (parameters[i].equals("-group")) {
                group = parameters[++i];
            } else if (parameters[i].equals("-mode")) {
                short modeValue = Short.parseShort(parameters[++i], 8);
                mode = new FsPermission(modeValue);
            } else {
                this.printUsage("-add");
                return false;
            }
            ++i;
        }
        return this.addMount(mount, nss, dest, readOnly, faultTolerant, order, new ACLEntity(owner, group, mode));
    }

    public boolean addMount(String mount, String[] nss, String dest, boolean readonly, boolean faultTolerant, DestinationOrder order, ACLEntity aclInfo) throws IOException {
        MountTableManager mountTable;
        MountTable existingEntry = this.getMountEntry(mount = RouterAdmin.normalizeFileSystemPath(mount), mountTable = this.client.getMountTableManager());
        if (existingEntry == null) {
            LinkedHashMap<String, String> destMap = new LinkedHashMap<String, String>();
            for (String ns : nss) {
                destMap.put(ns, dest);
            }
            MountTable newEntry = MountTable.newInstance(mount, destMap);
            if (readonly) {
                newEntry.setReadOnly(true);
            }
            if (faultTolerant) {
                newEntry.setFaultTolerant(true);
            }
            if (order != null) {
                newEntry.setDestOrder(order);
            }
            if (aclInfo.getOwner() != null) {
                newEntry.setOwnerName(aclInfo.getOwner());
            }
            if (aclInfo.getGroup() != null) {
                newEntry.setGroupName(aclInfo.getGroup());
            }
            if (aclInfo.getMode() != null) {
                newEntry.setMode(aclInfo.getMode());
            }
            newEntry.validate();
            AddMountTableEntryRequest request = AddMountTableEntryRequest.newInstance(newEntry);
            AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(request);
            boolean added = addResponse.getStatus();
            if (!added) {
                System.err.println("Cannot add mount point " + mount);
            }
            return added;
        }
        for (String nsId : nss) {
            if (existingEntry.addDestination(nsId, dest)) continue;
            System.err.println("Cannot add destination at " + nsId + " " + dest);
            return false;
        }
        if (readonly) {
            existingEntry.setReadOnly(true);
        }
        if (faultTolerant) {
            existingEntry.setFaultTolerant(true);
        }
        if (order != null) {
            existingEntry.setDestOrder(order);
        }
        if (aclInfo.getOwner() != null) {
            existingEntry.setOwnerName(aclInfo.getOwner());
        }
        if (aclInfo.getGroup() != null) {
            existingEntry.setGroupName(aclInfo.getGroup());
        }
        if (aclInfo.getMode() != null) {
            existingEntry.setMode(aclInfo.getMode());
        }
        existingEntry.validate();
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry);
        UpdateMountTableEntryResponse updateResponse = mountTable.updateMountTableEntry(updateRequest);
        boolean updated = updateResponse.getStatus();
        if (!updated) {
            System.err.println("Cannot update mount point " + mount);
        }
        return updated;
    }

    public boolean updateMount(String[] parameters, int i) throws IOException {
        MountTableManager mountTable;
        String mount = parameters[i++];
        MountTable existingEntry = this.getMountEntry(mount = RouterAdmin.normalizeFileSystemPath(mount), mountTable = this.client.getMountTableManager());
        if (existingEntry == null) {
            throw new IOException(mount + " doesn't exist.");
        }
        if (!parameters[i].startsWith("-")) {
            Object nss = parameters[i++].split(",");
            String dest = parameters[i++];
            LinkedHashMap<Object, String> destMap = new LinkedHashMap<Object, String>();
            for (Object ns : nss) {
                destMap.put(ns, dest);
            }
            LinkedList<RemoteLocation> locations = new LinkedList<RemoteLocation>();
            for (Map.Entry entry : destMap.entrySet()) {
                String nsId = (String)entry.getKey();
                String path = RouterAdmin.normalizeFileSystemPath((String)entry.getValue());
                RemoteLocation location = new RemoteLocation(nsId, path, mount);
                locations.add(location);
            }
            existingEntry.setDestinations(locations);
        }
        try {
            while (i < parameters.length) {
                switch (parameters[i]) {
                    case "-readonly": {
                        existingEntry.setReadOnly(this.getBooleanValue(parameters[++i]));
                        break;
                    }
                    case "-faulttolerant": {
                        existingEntry.setFaultTolerant(this.getBooleanValue(parameters[++i]));
                        break;
                    }
                    case "-order": {
                        ++i;
                        try {
                            existingEntry.setDestOrder(DestinationOrder.valueOf(parameters[i]));
                            break;
                        }
                        catch (Exception e) {
                            throw new Exception("Cannot parse order: " + parameters[i]);
                        }
                    }
                    case "-owner": {
                        existingEntry.setOwnerName(parameters[++i]);
                        break;
                    }
                    case "-group": {
                        existingEntry.setGroupName(parameters[++i]);
                        break;
                    }
                    case "-mode": {
                        short modeValue = Short.parseShort(parameters[++i], 8);
                        existingEntry.setMode(new FsPermission(modeValue));
                        break;
                    }
                    default: {
                        this.printUsage("-update");
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            String msg = "Unable to parse arguments: " + e.getMessage();
            if (e instanceof ArrayIndexOutOfBoundsException) {
                msg = "Unable to parse arguments: no value provided for " + parameters[i - 1];
            }
            throw new IOException(msg);
        }
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry);
        UpdateMountTableEntryResponse updateResponse = mountTable.updateMountTableEntry(updateRequest);
        boolean updated = updateResponse.getStatus();
        if (!updated) {
            System.err.println("Cannot update mount point " + mount);
        }
        return updated;
    }

    private boolean getBooleanValue(String value) throws Exception {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid argument: " + value + ". Please specify either true or false.");
    }

    private MountTable getMountEntry(String mount, MountTableManager mountTable) throws IOException {
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable result : results) {
            if (!mount.equals(result.getSourcePath())) continue;
            existingEntry = result;
        }
        return existingEntry;
    }

    public boolean removeMount(String path) throws IOException {
        RemoveMountTableEntryRequest request;
        path = RouterAdmin.normalizeFileSystemPath(path);
        MountTableManager mountTable = this.client.getMountTableManager();
        RemoveMountTableEntryResponse response = mountTable.removeMountTableEntry(request = RemoveMountTableEntryRequest.newInstance(path));
        boolean removed = response.getStatus();
        if (!removed) {
            System.out.println("Cannot remove mount point " + path);
        }
        return removed;
    }

    public void listMounts(String[] argv, int i) throws IOException {
        String path;
        boolean detail = false;
        if (argv.length == 1) {
            path = "/";
        } else if (argv[i].equals("-d")) {
            detail = true;
            path = argv.length == 2 ? "/" : argv[++i];
        } else {
            path = argv[i];
        }
        path = RouterAdmin.normalizeFileSystemPath(path);
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance(path);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        List<MountTable> entries = response.getEntries();
        RouterAdmin.printMounts(entries, detail);
    }

    private static void printMounts(List<MountTable> entries, boolean detail) {
        System.out.println("Mount Table Entries:");
        if (detail) {
            System.out.println(String.format("%-25s %-25s %-25s %-25s %-10s %-30s %-10s %-10s %-15s", "Source", "Destinations", "Owner", "Group", "Mode", "Quota/Usage", "Order", "ReadOnly", "FaultTolerant"));
        } else {
            System.out.println(String.format("%-25s %-25s %-25s %-25s %-10s %-30s", "Source", "Destinations", "Owner", "Group", "Mode", "Quota/Usage"));
        }
        for (MountTable entry : entries) {
            StringBuilder destBuilder = new StringBuilder();
            for (RemoteLocation location : entry.getDestinations()) {
                if (destBuilder.length() > 0) {
                    destBuilder.append(",");
                }
                destBuilder.append(String.format("%s->%s", location.getNameserviceId(), location.getDest()));
            }
            System.out.print(String.format("%-25s %-25s", entry.getSourcePath(), destBuilder.toString()));
            System.out.print(String.format(" %-25s %-25s %-10s", entry.getOwnerName(), entry.getGroupName(), entry.getMode()));
            System.out.print(String.format(" %-30s", new Object[]{entry.getQuota()}));
            if (detail) {
                System.out.print(String.format(" %-10s", new Object[]{entry.getDestOrder()}));
                System.out.print(String.format(" %-10s", entry.isReadOnly() ? "Read-Only" : ""));
                System.out.print(String.format(" %-15s", entry.isFaultTolerant() ? "Fault-Tolerant" : ""));
            }
            System.out.println();
        }
    }

    private void getDestination(String path) throws IOException {
        path = RouterAdmin.normalizeFileSystemPath(path);
        MountTableManager mountTable = this.client.getMountTableManager();
        GetDestinationRequest request = GetDestinationRequest.newInstance(path);
        GetDestinationResponse response = mountTable.getDestination(request);
        System.out.println("Destination: " + StringUtils.join((CharSequence)",", response.getDestinations()));
    }

    private boolean setQuota(String[] parameters, int i) throws IOException {
        long nsQuota = Long.MAX_VALUE;
        long ssQuota = Long.MAX_VALUE;
        String mount = parameters[i++];
        while (i < parameters.length) {
            if (parameters[i].equals("-nsQuota")) {
                ++i;
                try {
                    nsQuota = Long.parseLong(parameters[i]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse nsQuota: " + parameters[i]);
                }
            } else if (parameters[i].equals("-ssQuota")) {
                ++i;
                try {
                    ssQuota = StringUtils.TraditionalBinaryPrefix.string2long((String)parameters[i]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse ssQuota: " + parameters[i]);
                }
            } else {
                throw new IllegalArgumentException("Invalid argument : " + parameters[i]);
            }
            ++i;
        }
        if (nsQuota <= 0L || ssQuota <= 0L) {
            throw new IllegalArgumentException("Input quota value should be a positive number.");
        }
        if (nsQuota == Long.MAX_VALUE && ssQuota == Long.MAX_VALUE) {
            throw new IllegalArgumentException("Must specify at least one of -nsQuota and -ssQuota.");
        }
        return this.updateQuota(mount, nsQuota, ssQuota);
    }

    private boolean setStorageTypeQuota(String[] parameters, int i) throws IOException {
        long[] typeQuota = new long[StorageType.values().length];
        Quota.eachByStorageType(t -> {
            typeQuota[t.ordinal()] = Long.MAX_VALUE;
        });
        String mount = parameters[i++];
        if (!parameters[i].equals("-storageType")) {
            throw new IllegalArgumentException("Invalid argument : " + parameters[i]);
        }
        int n = ++i;
        StorageType type = StorageType.parseStorageType((String)parameters[n]);
        typeQuota[type.ordinal()] = Long.parseLong(parameters[++i]);
        if (Quota.orByStorageType(t -> typeQuota[t.ordinal()] <= 0L)) {
            throw new IllegalArgumentException("Input quota value should be a positive number.");
        }
        if (Quota.andByStorageType(t -> typeQuota[t.ordinal()] == Long.MAX_VALUE)) {
            throw new IllegalArgumentException("Must specify at least one of -nsQuota and -ssQuota.");
        }
        return this.updateStorageTypeQuota(mount, typeQuota);
    }

    private boolean clrQuota(String mount) throws IOException {
        return this.updateQuota(mount, -1L, -1L);
    }

    private boolean clrStorageTypeQuota(String mount) throws IOException {
        long[] typeQuota = new long[StorageType.values().length];
        Quota.eachByStorageType(t -> {
            typeQuota[t.ordinal()] = -1L;
        });
        return this.updateStorageTypeQuota(mount, typeQuota);
    }

    private boolean updateQuota(String mount, long nsQuota, long ssQuota) throws IOException {
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable result : results) {
            if (!mount.equals(result.getSourcePath())) continue;
            existingEntry = result;
            break;
        }
        if (existingEntry == null) {
            throw new IOException(mount + " doesn't exist in mount table.");
        }
        long nsCount = existingEntry.getQuota().getFileAndDirectoryCount();
        long ssCount = existingEntry.getQuota().getSpaceConsumed();
        if (nsQuota == -1L && ssQuota == -1L) {
            nsCount = 0L;
            ssCount = 0L;
        } else {
            if (nsQuota == Long.MAX_VALUE) {
                nsQuota = existingEntry.getQuota().getQuota();
            }
            if (ssQuota == Long.MAX_VALUE) {
                ssQuota = existingEntry.getQuota().getSpaceQuota();
            }
        }
        RouterQuotaUsage updatedQuota = new RouterQuotaUsage.Builder().fileAndDirectoryCount(nsCount).quota(nsQuota).spaceConsumed(ssCount).spaceQuota(ssQuota).build();
        existingEntry.setQuota(updatedQuota);
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry);
        UpdateMountTableEntryResponse updateResponse = mountTable.updateMountTableEntry(updateRequest);
        return updateResponse.getStatus();
    }

    private boolean updateStorageTypeQuota(String mount, long[] typeQuota) throws IOException {
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable result : results) {
            if (!mount.equals(result.getSourcePath())) continue;
            existingEntry = result;
            break;
        }
        if (existingEntry == null) {
            throw new IOException(mount + " doesn't exist in mount table.");
        }
        RouterQuotaUsage quotaUsage = existingEntry.getQuota();
        long[] typeCount = new long[StorageType.values().length];
        Quota.eachByStorageType(t -> {
            typeCount[t.ordinal()] = quotaUsage.getTypeQuota((StorageType)t);
        });
        if (Quota.andByStorageType(t -> typeQuota[t.ordinal()] == -1L)) {
            Quota.eachByStorageType(t -> {
                typeCount[t.ordinal()] = 0L;
            });
        } else {
            Quota.eachByStorageType(t -> {
                if (typeQuota[t.ordinal()] == Long.MAX_VALUE) {
                    typeQuota[t.ordinal()] = quotaUsage.getTypeQuota((StorageType)t);
                }
            });
        }
        RouterQuotaUsage updatedQuota = new RouterQuotaUsage.Builder().typeQuota(typeQuota).typeConsumed(typeCount).build();
        existingEntry.setQuota(updatedQuota);
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry);
        UpdateMountTableEntryResponse updateResponse = mountTable.updateMountTableEntry(updateRequest);
        return updateResponse.getStatus();
    }

    private void manageSafeMode(String cmd) throws IOException {
        if (cmd.equals("enter")) {
            if (this.enterSafeMode()) {
                System.out.println("Successfully enter safe mode.");
            }
        } else if (cmd.equals("leave")) {
            if (this.leaveSafeMode()) {
                System.out.println("Successfully leave safe mode.");
            }
        } else if (cmd.equals("get")) {
            boolean result = this.getSafeMode();
            System.out.println("Safe Mode: " + result);
        } else {
            throw new IllegalArgumentException("Invalid argument: " + cmd);
        }
    }

    private boolean enterSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        EnterSafeModeResponse response = stateManager.enterSafeMode(EnterSafeModeRequest.newInstance());
        return response.getStatus();
    }

    private boolean leaveSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        LeaveSafeModeResponse response = stateManager.leaveSafeMode(LeaveSafeModeRequest.newInstance());
        return response.getStatus();
    }

    private boolean getSafeMode() throws IOException {
        RouterStateManager stateManager = this.client.getRouterStateManager();
        GetSafeModeResponse response = stateManager.getSafeMode(GetSafeModeRequest.newInstance());
        return response.isInSafeMode();
    }

    private void manageNameservice(String cmd, String nsId) throws IOException {
        if (cmd.equals("enable")) {
            if (this.enableNameservice(nsId)) {
                System.out.println("Successfully enabled nameservice " + nsId);
            } else {
                System.err.println("Cannot enable " + nsId);
            }
        } else if (cmd.equals("disable")) {
            if (this.disableNameservice(nsId)) {
                System.out.println("Successfully disabled nameservice " + nsId);
            } else {
                System.err.println("Cannot disable " + nsId);
            }
        } else {
            throw new IllegalArgumentException("Unknown command: " + cmd);
        }
    }

    private boolean disableNameservice(String nsId) throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        DisableNameserviceResponse response = nameserviceManager.disableNameservice(DisableNameserviceRequest.newInstance(nsId));
        return response.getStatus();
    }

    private boolean enableNameservice(String nsId) throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        EnableNameserviceResponse response = nameserviceManager.enableNameservice(EnableNameserviceRequest.newInstance(nsId));
        return response.getStatus();
    }

    private void getDisabledNameservices() throws IOException {
        NameserviceManager nameserviceManager = this.client.getNameserviceManager();
        GetDisabledNameservicesRequest request = GetDisabledNameservicesRequest.newInstance();
        GetDisabledNameservicesResponse response = nameserviceManager.getDisabledNameservices(request);
        System.out.println("List of disabled nameservices:");
        for (String nsId : response.getNameservices()) {
            System.out.println(nsId);
        }
    }

    public int genericRefresh(String[] argv, int i) throws IOException {
        String hostport = argv[i++];
        String identifier = argv[i++];
        String[] args = Arrays.copyOfRange(argv, i, argv.length);
        Configuration conf = this.getConf();
        conf.set("hadoop.security.service.user.name.key", conf.get("dfs.namenode.kerberos.principal", ""));
        Class<GenericRefreshProtocolPB> xface = GenericRefreshProtocolPB.class;
        InetSocketAddress address = NetUtils.createSocketAddr((String)hostport);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, xface, ProtobufRpcEngine2.class);
        GenericRefreshProtocolPB proxy = (GenericRefreshProtocolPB)RPC.getProxy(xface, (long)RPC.getProtocolVersion(xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)0);
        Collection responses = null;
        try {
            int n;
            try (GenericRefreshProtocolClientSideTranslatorPB xlator = new GenericRefreshProtocolClientSideTranslatorPB(proxy);){
                responses = xlator.refresh(identifier, args);
                int returnCode = 0;
                System.out.println("Refresh Responses:\n");
                for (RefreshResponse response : responses) {
                    System.out.println(response.toString());
                    if (returnCode == 0 && response.getReturnCode() != 0) {
                        returnCode = response.getReturnCode();
                        continue;
                    }
                    if (returnCode == 0 || response.getReturnCode() == 0) continue;
                    returnCode = -1;
                }
                n = returnCode;
            }
            return n;
        }
        finally {
            if (responses == null) {
                System.out.println("Failed to get response.\n");
                return -1;
            }
        }
    }

    private int refreshCallQueue() throws IOException {
        Configuration conf = this.getConf();
        String hostport = this.getConf().getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
        Class<RefreshCallQueueProtocolPB> xface = RefreshCallQueueProtocolPB.class;
        InetSocketAddress address = NetUtils.createSocketAddr((String)hostport);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, xface, ProtobufRpcEngine2.class);
        RefreshCallQueueProtocolPB proxy = (RefreshCallQueueProtocolPB)RPC.getProxy(xface, (long)RPC.getProtocolVersion(xface), (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)0);
        int returnCode = -1;
        try (RefreshCallQueueProtocolClientSideTranslatorPB xlator = new RefreshCallQueueProtocolClientSideTranslatorPB(proxy);){
            xlator.refreshCallQueue();
            System.out.println("Refresh call queue successfully for " + hostport);
            returnCode = 0;
        }
        catch (IOException ioe) {
            System.out.println("Refresh call queue unsuccessfully for " + hostport);
        }
        return returnCode;
    }

    public static String normalizeFileSystemPath(String str) {
        String path = SLASHES.matcher(str).replaceAll("/");
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static class ACLEntity {
        private final String owner;
        private final String group;
        private final FsPermission mode;

        ACLEntity(String owner, String group, FsPermission mode) {
            this.owner = owner;
            this.group = group;
            this.mode = mode;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }

        public FsPermission getMode() {
            return this.mode;
        }
    }
}

