/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.sink.GraphiteSink;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestGraphiteMetrics {
    private AbstractMetric makeMetric(String name, Number value) {
        AbstractMetric metric = (AbstractMetric)Mockito.mock(AbstractMetric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        return metric;
    }

    private GraphiteSink.Graphite makeGraphite() {
        GraphiteSink.Graphite mockGraphite = (GraphiteSink.Graphite)Mockito.mock(GraphiteSink.Graphite.class);
        Mockito.when((Object)mockGraphite.isConnected()).thenReturn((Object)true);
        return mockGraphite;
    }

    @Test
    public void testPutMetrics() {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1.25));
        metrics.add(this.makeMetric("foo2", 2.25));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        GraphiteSink.Graphite mockGraphite = this.makeGraphite();
        sink.setGraphite(mockGraphite);
        sink.putMetrics((MetricsRecord)record);
        try {
            ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write((String)argument.capture());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = (String)argument.getValue();
        Assert.assertEquals((Object)true, (Object)(result.equals("null.all.Context.Context=all.Hostname=host.foo1 1.25 10\nnull.all.Context.Context=all.Hostname=host.foo2 2.25 10\n") || result.equals("null.all.Context.Context=all.Hostname=host.foo2 2.25 10\nnull.all.Context.Context=all.Hostname=host.foo1 1.25 10\n") ? 1 : 0));
    }

    @Test
    public void testPutMetrics2() throws IllegalAccessException {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, null));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1));
        metrics.add(this.makeMetric("foo2", 2));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        GraphiteSink.Graphite mockGraphite = this.makeGraphite();
        sink.setGraphite(mockGraphite);
        sink.putMetrics((MetricsRecord)record);
        try {
            ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write((String)argument.capture());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = (String)argument.getValue();
        Assert.assertEquals((Object)true, (Object)(result.equals("null.all.Context.Context=all.foo1 1 10\nnull.all.Context.Context=all.foo2 2 10\n") || result.equals("null.all.Context.Context=all.foo2 2 10\nnull.all.Context.Context=all.foo1 1 10\n") ? 1 : 0));
    }

    @Test
    public void testPutMetrics3() throws IllegalAccessException {
        GraphiteSink sink = new GraphiteSink();
        GraphiteSink.Graphite mockGraphite = this.makeGraphite();
        sink.setGraphite(mockGraphite);
        List tags = Collections.emptyList();
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1));
        MetricsRecordImpl record1 = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 1000000000000L, tags, metrics);
        MetricsRecordImpl record2 = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 1000000001000L, tags, metrics);
        sink.putMetrics((MetricsRecord)record1);
        sink.putMetrics((MetricsRecord)record2);
        sink.flush();
        try {
            sink.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write((String)ArgumentMatchers.eq((Object)"null.default.Context.foo1 1 1000000000\n"));
            ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write((String)ArgumentMatchers.eq((Object)"null.default.Context.foo1 1 1000000001\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFailureAndPutMetrics() throws IOException, IllegalAccessException {
        GraphiteSink sink = new GraphiteSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1.25));
        metrics.add(this.makeMetric("foo2", 2.25));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        GraphiteSink.Graphite mockGraphite = this.makeGraphite();
        sink.setGraphite(mockGraphite);
        ((GraphiteSink.Graphite)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("IO exception")}).when((Object)mockGraphite)).write(ArgumentMatchers.anyString());
        sink.putMetrics((MetricsRecord)record);
        ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write(ArgumentMatchers.anyString());
        ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).close();
        Mockito.reset((Object[])new GraphiteSink.Graphite[]{mockGraphite});
        Mockito.when((Object)mockGraphite.isConnected()).thenReturn((Object)false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        sink.putMetrics((MetricsRecord)record);
        ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).write((String)argument.capture());
        String result = (String)argument.getValue();
        Assert.assertEquals((Object)true, (Object)(result.equals("null.all.Context.Context=all.Hostname=host.foo1 1.25 10\nnull.all.Context.Context=all.Hostname=host.foo2 2.25 10\n") || result.equals("null.all.Context.Context=all.Hostname=host.foo2 2.25 10\nnull.all.Context.Context=all.Hostname=host.foo1 1.25 10\n") ? 1 : 0));
    }

    @Test
    public void testClose() throws IllegalAccessException {
        GraphiteSink sink = new GraphiteSink();
        GraphiteSink.Graphite mockGraphite = this.makeGraphite();
        sink.setGraphite(mockGraphite);
        try {
            sink.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            ((GraphiteSink.Graphite)Mockito.verify((Object)mockGraphite)).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

