/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Action0;

public final class OnSubscribeDoOnEmpty<T>
implements Observable.OnSubscribe<T> {
    private final Action0 onEmpty;
    private Observable<T> observable;

    public OnSubscribeDoOnEmpty(Observable<T> observable, Action0 onEmpty) {
        this.observable = observable;
        this.onEmpty = onEmpty;
    }

    public void call(Subscriber<? super T> child) {
        Subscriber<? super T> parent = OnSubscribeDoOnEmpty.createSubscriber(child, this.onEmpty);
        this.observable.unsafeSubscribe(parent);
    }

    private static <T> Subscriber<T> createSubscriber(final Subscriber<? super T> child, final Action0 onEmpty) {
        return new Subscriber<T>(child){
            private boolean isEmpty;
            {
                super(x0);
                this.isEmpty = true;
            }

            public void onCompleted() {
                if (this.isEmpty) {
                    try {
                        onEmpty.call();
                    }
                    catch (Throwable e) {
                        Exceptions.throwOrReport((Throwable)e, (Observer)this);
                        return;
                    }
                    if (!this.isUnsubscribed()) {
                        child.onCompleted();
                    }
                } else {
                    child.onCompleted();
                }
            }

            public void onError(Throwable e) {
                child.onError(e);
            }

            public void onNext(T t) {
                this.isEmpty = false;
                child.onNext(t);
            }
        };
    }
}

