/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms;

import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.KMSDelegationToken;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLoadBalancingKMSClientProvider {
    @Rule
    public Timeout testTimeout = new Timeout(30000);

    @BeforeClass
    public static void setup() throws IOException {
        SecurityUtil.setTokenServiceUseIp((boolean)false);
    }

    @Test
    public void testCreation() throws Exception {
        Configuration conf = new Configuration();
        KeyProvider kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1:9600/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        KMSClientProvider[] providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)1L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1:9600/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl()}));
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3:9600/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1:9600/kms/foo/v1/", "http://host2:9600/kms/foo/v1/", "http://host3:9600/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
        kp = new KMSClientProvider.Factory().createProvider(new URI("kms://http@host1;host2;host3:9600/kms/foo"), conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        providers = ((LoadBalancingKMSClientProvider)kp).getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"http://host1:9600/kms/foo/v1/", "http://host2:9600/kms/foo/v1/", "http://host3:9600/kms/foo/v1/"}), (Object)Sets.newHashSet((Object[])new String[]{providers[0].getKMSUrl(), providers[1].getKMSUrl(), providers[2].getKMSUrl()}));
    }

    @Test
    public void testLoadBalancing() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p2", "v2", new byte[0]));
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test1", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p2", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithFailure() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p1", "v1", new byte[0]));
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new NoSuchAlgorithmException("p2")});
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("p3", "v3", new byte[0]));
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test4", new KeyProvider.Options(conf)).getName());
        try {
            kp.createKey("test1", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since its not an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoSuchAlgorithmException));
        }
        Assert.assertEquals((Object)"p3", (Object)kp.createKey("test2", new KeyProvider.Options(conf)).getName());
        Assert.assertEquals((Object)"p1", (Object)kp.createKey("test3", new KeyProvider.Options(conf)).getName());
    }

    @Test
    public void testLoadBalancingWithAllBadNodes() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p4")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf)).getName();
            Assert.fail((String)"Should fail since all providers threw an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
    }

    private static void throwEx(Throwable ex) {
        TestLoadBalancingKMSClientProvider.throwException(ex);
    }

    private static <E extends Throwable> void throwException(Throwable ex) throws E {
        throw ex;
    }

    @Test
    public void testClassCastException() throws Exception {
        Configuration conf = new Configuration();
        MyKMSClientProvider p1 = new MyKMSClientProvider(new URI("kms://http@host1:9600/kms/foo"), conf);
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1}, 0L, conf);
        try {
            kp.generateEncryptedKey("foo");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion = (KeyProviderCryptoExtension.EncryptedKeyVersion)Mockito.mock(KeyProviderCryptoExtension.EncryptedKeyVersion.class);
            kp.decryptEncryptedKey(encryptedKeyVersion);
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            KeyProvider.Options options = KeyProvider.options((Configuration)conf);
            kp.createKey("foo", options);
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
        try {
            kp.rollNewVersion("foo");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getCause().getClass().getName().contains("AuthenticationException"));
        }
    }

    @Test
    public void testWarmUpEncryptedKeysWhenAllProvidersFail() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        String keyName = "key1";
        ((KMSClientProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IOException((Throwable)new AuthorizationException("p1"))}).when((Object)p1)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        ((KMSClientProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IOException((Throwable)new AuthorizationException("p2"))}).when((Object)p2)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.warmUpEncryptedKeys(new String[]{keyName});
            Assert.fail((String)"Should fail since both providers threw IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
    }

    @Test
    public void testWarmUpEncryptedKeysWhenOneProviderSucceeds() throws Exception {
        Configuration conf = new Configuration();
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        String keyName = "key1";
        ((KMSClientProvider)Mockito.doThrow((Throwable[])new Throwable[]{new IOException((Throwable)new AuthorizationException("p1"))}).when((Object)p1)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        ((KMSClientProvider)Mockito.doNothing().when((Object)p2)).warmUpEncryptedKeys(new String[]{Mockito.anyString()});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.warmUpEncryptedKeys(new String[]{keyName});
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw Exception since p2 doesn't throw Exception");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).warmUpEncryptedKeys(new String[]{keyName});
    }

    @Test
    public void testClientRetriesNonIdempotentOpWithIOExceptionFailsImmediately() throws Exception {
        Configuration conf = new Configuration();
        String keyName = "test";
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        try {
            kp.createKey("test", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since all providers threw an IOException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[0], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[1], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[2], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesIdempotentOpWithIOExceptionSucceedsSecondTime() throws Exception {
        Configuration conf = new Configuration();
        String keyName = "test";
        KMSClientProvider.KMSKeyVersion keyVersion = new KMSClientProvider.KMSKeyVersion("test", "v1", new byte[0]);
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.getCurrentKey(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p1")}).thenReturn((Object)keyVersion);
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.getCurrentKey(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.getCurrentKey(Mockito.anyString())).thenThrow(new Throwable[]{new IOException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        KeyProvider.KeyVersion result = kp.getCurrentKey("test");
        Assert.assertEquals((Object)keyVersion, (Object)result);
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[0], (VerificationMode)Mockito.times((int)2))).getCurrentKey((String)Mockito.eq((Object)"test"));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[1], (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"test"));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[2], (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"test"));
    }

    @Test
    public void testClientRetriesWithAccessControlException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new AccessControlException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail because provider p1 threw an AccessControlException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof AccessControlException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p3, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithRuntimeException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new RuntimeException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since provider p1 threw RuntimeException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.never())).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithTimeoutsException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 4);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new UnknownHostException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new NoRouteToHostException("p3")});
        KMSClientProvider p4 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p4.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("test3", "v1", new byte[0]));
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        Mockito.when((Object)p4.getKMSUrl()).thenReturn((Object)"p4");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3, p4}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
        }
        catch (Exception e) {
            Assert.fail((String)"Provider p4 should have answered the request.");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p3, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p4, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesSucceedsSecondTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")}).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("test3", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
        }
        catch (Exception e) {
            Assert.fail((String)"Provider p1 should have answered the request second time.");
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesSpecifiedNumberOfTimes() throws Exception {
        KMSClientProvider p2;
        KMSClientProvider p1;
        block2: {
            Configuration conf = new Configuration();
            conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
            p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
            p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
            Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
            Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
            LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
            try {
                kp.createKey("test3", new KeyProvider.Options(conf));
                Assert.fail((String)"Should fail");
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof ConnectTimeoutException) break block2;
                throw new AssertionError();
            }
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)6))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)5))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesIfMaxAttemptsNotSet() throws Exception {
        KMSClientProvider p2;
        KMSClientProvider p1;
        block2: {
            Configuration conf = new Configuration();
            p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p1")});
            p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
            Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectTimeoutException("p2")});
            Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
            Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
            LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
            try {
                kp.createKey("test3", new KeyProvider.Options(conf));
                Assert.fail((String)"Should fail");
            }
            catch (Exception e) {
                if ($assertionsDisabled || e instanceof ConnectTimeoutException) break block2;
                throw new AssertionError();
            }
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithAuthenticationExceptionWrappedinIOException() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException((Throwable)new AuthenticationException("p1"))});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new IOException((Throwable)new AuthenticationException("p1"))});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        try {
            kp.createKey("test3", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since provider p1 threw AuthenticationException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof AuthenticationException));
        }
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test3"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithSSLHandshakeExceptionSucceedsSecondTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        String keyName = "test";
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new SSLHandshakeException("p1")}).thenReturn((Object)new KMSClientProvider.KMSKeyVersion("test", "v1", new byte[0]));
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        kp.createKey("test", new KeyProvider.Options(conf));
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesWithSSLHandshakeExceptionFailsAtEveryAttempt() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 2);
        String keyName = "test";
        String exceptionMessage = "p1 exception message";
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        SSLHandshakeException originalSslEx = new SSLHandshakeException("p1 exception message");
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{originalSslEx});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new ConnectException("p2 exception message")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        Exception interceptedEx = LambdaTestUtils.intercept(ConnectException.class, "SSLHandshakeException: p1 exception message", () -> kp.createKey("test", new KeyProvider.Options(conf)));
        Assert.assertEquals((Object)originalSslEx, (Object)interceptedEx.getCause());
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testClientRetriesIdempotentOpWithSocketTimeoutExceptionSucceeds() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 3);
        List<String> keys = Arrays.asList("testKey");
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.getKeys()).thenThrow(new Throwable[]{new SocketTimeoutException("p1")}).thenReturn(keys);
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.getKeys()).thenThrow(new Throwable[]{new SocketTimeoutException("p2")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        List result = kp.getKeys();
        Assert.assertEquals(keys, (Object)result);
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).getKeys();
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).getKeys();
    }

    @Test
    public void testClientRetriesIdempotentOpWithSocketTimeoutExceptionFails() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 2);
        String keyName = "test";
        String exceptionMessage = "p1 exception message";
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        SocketTimeoutException originalEx = new SocketTimeoutException("p1 exception message");
        Mockito.when((Object)p1.getKeyVersions(Mockito.anyString())).thenThrow(new Throwable[]{originalEx});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.getKeyVersions(Mockito.anyString())).thenThrow(new Throwable[]{new SocketTimeoutException("p2 exception message")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2}, 0L, conf);
        Exception interceptedEx = LambdaTestUtils.intercept(SocketTimeoutException.class, "SocketTimeoutException: p1 exception message", () -> kp.getKeyVersions("test"));
        Assert.assertEquals((Object)originalEx, (Object)interceptedEx);
        ((KMSClientProvider)Mockito.verify((Object)p1, (VerificationMode)Mockito.times((int)2))).getKeyVersions((String)Mockito.eq((Object)"test"));
        ((KMSClientProvider)Mockito.verify((Object)p2, (VerificationMode)Mockito.times((int)1))).getKeyVersions((String)Mockito.eq((Object)"test"));
    }

    @Test
    public void testClientRetriesNonIdempotentOpWithSocketTimeoutExceptionFails() throws Exception {
        Configuration conf = new Configuration();
        String keyName = "test";
        conf.setInt("hadoop.security.kms.client.failover.max.retries", 10);
        KMSClientProvider p1 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p1.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new SocketTimeoutException("p1")});
        KMSClientProvider p2 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p2.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new SocketTimeoutException("p2")});
        KMSClientProvider p3 = (KMSClientProvider)Mockito.mock(KMSClientProvider.class);
        Mockito.when((Object)p3.createKey(Mockito.anyString(), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class))).thenThrow(new Throwable[]{new SocketTimeoutException("p3")});
        Mockito.when((Object)p1.getKMSUrl()).thenReturn((Object)"p1");
        Mockito.when((Object)p2.getKMSUrl()).thenReturn((Object)"p2");
        Mockito.when((Object)p3.getKMSUrl()).thenReturn((Object)"p3");
        LoadBalancingKMSClientProvider kp = new LoadBalancingKMSClientProvider(new KMSClientProvider[]{p1, p2, p3}, 0L, conf);
        try {
            kp.createKey("test", new KeyProvider.Options(conf));
            Assert.fail((String)"Should fail since all providers threw a SocketTimeoutException");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SocketTimeoutException));
        }
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[0], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[1], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
        ((KMSClientProvider)Mockito.verify((Object)kp.getProviders()[2], (VerificationMode)Mockito.times((int)1))).createKey((String)Mockito.eq((Object)"test"), (KeyProvider.Options)Mockito.any(KeyProvider.Options.class));
    }

    @Test
    public void testTokenServiceCreationWithLegacyFormat() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", "kms:/something");
        String authority = "host1:9600";
        URI kmsUri = URI.create("kms://http@" + authority + "/kms/foo");
        KeyProvider kp = new KMSClientProvider.Factory().createProvider(kmsUri, conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        LoadBalancingKMSClientProvider lbkp = (LoadBalancingKMSClientProvider)kp;
        Assert.assertEquals((long)1L, (long)lbkp.getProviders().length);
        Assert.assertEquals((Object)authority, (Object)lbkp.getCanonicalServiceName());
        for (KMSClientProvider provider : lbkp.getProviders()) {
            Assert.assertEquals((Object)authority, (Object)provider.getCanonicalServiceName());
        }
    }

    @Test
    public void testTokenServiceCreationWithUriFormat() throws Exception {
        Configuration conf = new Configuration();
        URI kmsUri = URI.create("kms://http@host1;host2;host3:9600/kms/foo");
        KeyProvider kp = new KMSClientProvider.Factory().createProvider(kmsUri, conf);
        Assert.assertTrue((boolean)(kp instanceof LoadBalancingKMSClientProvider));
        LoadBalancingKMSClientProvider lbkp = (LoadBalancingKMSClientProvider)kp;
        Assert.assertEquals((Object)kmsUri.toString(), (Object)lbkp.getCanonicalServiceName());
        KMSClientProvider[] providers = lbkp.getProviders();
        Assert.assertEquals((long)3L, (long)providers.length);
        for (int i = 0; i < providers.length; ++i) {
            Assert.assertEquals((Object)URI.create(providers[i].getKMSUrl()).getAuthority(), (Object)providers[i].getCanonicalServiceName());
            Assert.assertNotEquals((Object)kmsUri, (Object)providers[i].getCanonicalServiceName());
        }
    }

    private void testTokenSelectionWithConf(final Configuration conf) throws Exception {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"hadoop"});
        String providerUriString = "kms://http@host1;host2;host3:9600/kms/foo";
        conf.set("hadoop.security.key.provider.path", providerUriString);
        final URI kmsUri = URI.create(providerUriString);
        final Token token = new Token();
        token.setKind(KMSDelegationToken.TOKEN_KIND);
        token.setService(new Text(providerUriString));
        UserGroupInformation actualUgi = (UserGroupInformation)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws Exception {
                KeyProvider kp = new KMSClientProvider.Factory().createProvider(kmsUri, conf);
                LoadBalancingKMSClientProvider lbkp = (LoadBalancingKMSClientProvider)kp;
                Credentials creds = new Credentials();
                creds.addToken(token.getService(), token);
                UserGroupInformation.getCurrentUser().addCredentials(creds);
                KMSClientProvider[] providers = lbkp.getProviders();
                return providers[0].getActualUgi();
            }
        });
        Assert.assertEquals((String)"testTokenSelectionWithConf() should return the current user, not login user", (Object)ugi, (Object)actualUgi);
    }

    @Test
    public void testTokenSelectionWithKMSUriInConf() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        conf.set("hadoop.security.authentication", "kerberos");
        String providerUriString = "kms://http@host1;host2;host3:9600/kms/foo";
        conf.set("hadoop.security.key.provider.path", providerUriString);
        this.testTokenSelectionWithConf(conf);
    }

    @Test
    public void testGetActualUGI() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testTokenSelectionWithConf(conf);
    }

    private class MyKMSClientProvider
    extends KMSClientProvider {
        public MyKMSClientProvider(URI uri, Configuration conf) throws IOException {
            super(uri, conf);
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            TestLoadBalancingKMSClientProvider.throwEx((Throwable)new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            TestLoadBalancingKMSClientProvider.throwEx((Throwable)new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
            TestLoadBalancingKMSClientProvider.throwEx((Throwable)new AuthenticationException("bar"));
            return null;
        }

        public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
            TestLoadBalancingKMSClientProvider.throwEx((Throwable)new AuthenticationException("bar"));
            return null;
        }
    }
}

