/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Shell {
    private static final Map<Shell, Object> CHILD_SHELLS;
    public static final Logger LOG;
    private static final String WINDOWS_PROBLEMS = "https://wiki.apache.org/hadoop/WindowsProblems";
    static final String WINUTILS_EXE = "winutils.exe";
    public static final String SYSPROP_HADOOP_HOME_DIR = "hadoop.home.dir";
    public static final String ENV_HADOOP_HOME = "HADOOP_HOME";
    public static final String ENV_HADOOP_OPTS = "HADOOP_OPTS";
    public static final String ENV_MAPR_JMX_OPTS = "MAPR_JMX_OPTS";
    public static final String ENV_DEBUG_OPTS = "DEBUG_OPTS";
    private static final int JAVA_SPEC_VER;
    public static final int WINDOWS_MAX_SHELL_LENGTH = 8191;
    @Deprecated
    public static final int WINDOWS_MAX_SHELL_LENGHT = 8191;
    public static final String USER_NAME_COMMAND = "whoami";
    public static final Object WindowsProcessLaunchLock;
    public static final OSType osType;
    public static final boolean WINDOWS;
    public static final boolean SOLARIS;
    public static final boolean MAC;
    public static final boolean FREEBSD;
    public static final boolean LINUX;
    public static final boolean OTHER;
    public static final boolean PPC_64;
    public static final String ENV_NAME_REGEX = "[A-Za-z_][A-Za-z0-9_]*";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String SET_OWNER_COMMAND = "chown";
    public static final String SET_GROUP_COMMAND = "chgrp";
    public static final String LINK_COMMAND = "ln";
    public static final String READ_LINK_COMMAND = "readlink";
    protected long timeOutInterval = 0L;
    private final AtomicBoolean timedOut = new AtomicBoolean(false);
    protected boolean inheritParentEnv = true;
    static final String E_DOES_NOT_EXIST = "does not exist";
    static final String E_IS_RELATIVE = "is not an absolute path.";
    static final String E_NOT_DIRECTORY = "is not a directory.";
    static final String E_NO_EXECUTABLE = "Could not locate Hadoop executable";
    static final String E_NOT_EXECUTABLE_FILE = "Not an executable file";
    static final String E_HADOOP_PROPS_UNSET = "HADOOP_HOME and hadoop.home.dir are unset.";
    static final String E_HADOOP_PROPS_EMPTY = "HADOOP_HOME or hadoop.home.dir set to an empty string";
    static final String E_NOT_A_WINDOWS_SYSTEM = "Not a Windows system";
    private static final File HADOOP_HOME_FILE;
    private static final IOException HADOOP_HOME_DIR_FAILURE_CAUSE;
    @Deprecated
    public static final String WINUTILS;
    private static final String WINUTILS_PATH;
    private static final File WINUTILS_FILE;
    private static final IOException WINUTILS_FAILURE;
    public static final boolean isSetsidAvailable;
    public static final String TOKEN_SEPARATOR_REGEX;
    private long interval;
    private long lastTime;
    private final boolean redirectErrorStream;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;
    private Thread waitingThread;
    private final AtomicBoolean completed = new AtomicBoolean(false);

    @Deprecated
    public static boolean isJava7OrAbove() {
        return true;
    }

    public static boolean isJavaVersionAtLeast(int version) {
        return JAVA_SPEC_VER >= version;
    }

    public static void checkWindowsCommandLineLength(String ... commands) throws IOException {
        int len = 0;
        for (String s : commands) {
            len += s.length();
        }
        if (len > 8191) {
            throw new IOException(String.format("The command line has a length of %d exceeds maximum allowed length of %d. Command starts with: %s", len, 8191, StringUtils.join((CharSequence)"", commands).substring(0, 100)));
        }
    }

    @InterfaceAudience.Private
    public static String bashQuote(String arg) {
        StringBuilder buffer = new StringBuilder(arg.length() + 2);
        buffer.append('\'').append(arg.replace("'", "'\\''")).append('\'');
        return buffer.toString();
    }

    private static OSType getOSType() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return OSType.OS_TYPE_WIN;
        }
        if (osName.contains("SunOS") || osName.contains("Solaris")) {
            return OSType.OS_TYPE_SOLARIS;
        }
        if (osName.contains("Mac")) {
            return OSType.OS_TYPE_MAC;
        }
        if (osName.contains("FreeBSD")) {
            return OSType.OS_TYPE_FREEBSD;
        }
        if (osName.startsWith("Linux")) {
            return OSType.OS_TYPE_LINUX;
        }
        return OSType.OS_TYPE_OTHER;
    }

    public static String[] getGroupsCommand() {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = "groups";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "groups";
        }
        return stringArray;
    }

    public static String[] getGroupsForUserCommand(String user) {
        if (WINDOWS) {
            return new String[]{Shell.getWinUtilsPath(), "groups", "-F", "\"" + user + "\""};
        }
        String quotedUser = Shell.bashQuote(user);
        return new String[]{"bash", "-c", "id -gn " + quotedUser + "; id -Gn " + quotedUser};
    }

    public static String[] getGroupsIDForUserCommand(String user) {
        if (WINDOWS) {
            return new String[]{Shell.getWinUtilsPath(), "groups", "-F", "\"" + user + "\""};
        }
        String quotedUser = Shell.bashQuote(user);
        return new String[]{"bash", "-c", "id -g " + quotedUser + "; id -G " + quotedUser};
    }

    public static String[] getUsersForNetgroupCommand(String netgroup) {
        return new String[]{"getent", "netgroup", netgroup};
    }

    public static String[] getGetPermissionCommand() {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = Shell.getWinUtilsPath();
            stringArray2[1] = "ls";
            stringArray = stringArray2;
            stringArray2[2] = "-F";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "ls";
            stringArray = stringArray3;
            stringArray3[1] = "-ld";
        }
        return stringArray;
    }

    public static String[] getSetPermissionCommand(String perm, boolean recursive) {
        String[] stringArray;
        if (recursive) {
            String[] stringArray2;
            if (WINDOWS) {
                String[] stringArray3 = new String[4];
                stringArray3[0] = Shell.getWinUtilsPath();
                stringArray3[1] = SET_PERMISSION_COMMAND;
                stringArray3[2] = "-R";
                stringArray2 = stringArray3;
                stringArray3[3] = perm;
            } else {
                String[] stringArray4 = new String[3];
                stringArray4[0] = SET_PERMISSION_COMMAND;
                stringArray4[1] = "-R";
                stringArray2 = stringArray4;
                stringArray4[2] = perm;
            }
            return stringArray2;
        }
        if (WINDOWS) {
            String[] stringArray5 = new String[3];
            stringArray5[0] = Shell.getWinUtilsPath();
            stringArray5[1] = SET_PERMISSION_COMMAND;
            stringArray = stringArray5;
            stringArray5[2] = perm;
        } else {
            String[] stringArray6 = new String[2];
            stringArray6[0] = SET_PERMISSION_COMMAND;
            stringArray = stringArray6;
            stringArray6[1] = perm;
        }
        return stringArray;
    }

    public static String[] getSetPermissionCommand(String perm, boolean recursive, String file) {
        String[] baseCmd = Shell.getSetPermissionCommand(perm, recursive);
        String[] cmdWithFile = Arrays.copyOf(baseCmd, baseCmd.length + 1);
        cmdWithFile[cmdWithFile.length - 1] = file;
        return cmdWithFile;
    }

    public static String[] getSetOwnerCommand(String owner) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = Shell.getWinUtilsPath();
            stringArray2[1] = SET_OWNER_COMMAND;
            stringArray = stringArray2;
            stringArray2[2] = "\"" + owner + "\"";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = SET_OWNER_COMMAND;
            stringArray = stringArray3;
            stringArray3[1] = owner;
        }
        return stringArray;
    }

    public static String[] getSymlinkCommand(String target, String link) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = Shell.getWinUtilsPath();
            stringArray2[1] = "symlink";
            stringArray2[2] = link;
            stringArray = stringArray2;
            stringArray2[3] = target;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = LINK_COMMAND;
            stringArray3[1] = "-s";
            stringArray3[2] = target;
            stringArray = stringArray3;
            stringArray3[3] = link;
        }
        return stringArray;
    }

    public static String[] getReadlinkCommand(String link) {
        String[] stringArray;
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = Shell.getWinUtilsPath();
            stringArray2[1] = READ_LINK_COMMAND;
            stringArray = stringArray2;
            stringArray2[2] = link;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = READ_LINK_COMMAND;
            stringArray = stringArray3;
            stringArray3[1] = link;
        }
        return stringArray;
    }

    public static String[] getCheckProcessIsAliveCommand(String pid) {
        return Shell.getSignalKillCommand(0, pid);
    }

    public static String[] getSignalKillCommand(int code, String pid) {
        if (WINDOWS) {
            if (0 == code) {
                return new String[]{Shell.getWinUtilsPath(), "task", "isAlive", pid};
            }
            return new String[]{Shell.getWinUtilsPath(), "task", "kill", pid};
        }
        String quotedPid = Shell.bashQuote(pid);
        if (isSetsidAvailable) {
            return new String[]{"bash", "-c", "kill -" + code + " -- -" + quotedPid};
        }
        return new String[]{"bash", "-c", "kill -" + code + " " + quotedPid};
    }

    public static String getEnvironmentVariableRegex() {
        return WINDOWS ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }

    public static File appendScriptExtension(File parent, String basename) {
        return new File(parent, Shell.appendScriptExtension(basename));
    }

    public static String appendScriptExtension(String basename) {
        return basename + (WINDOWS ? ".cmd" : ".sh");
    }

    public static String[] getRunScriptCommand(File script) {
        String[] stringArray;
        String absolutePath = script.getAbsolutePath();
        if (WINDOWS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "cmd";
            stringArray2[1] = "/c";
            stringArray = stringArray2;
            stringArray2[2] = absolutePath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "bash";
            stringArray = stringArray3;
            stringArray3[1] = Shell.bashQuote(absolutePath);
        }
        return stringArray;
    }

    private static File checkHadoopHome() throws FileNotFoundException {
        String home = System.getProperty(SYSPROP_HADOOP_HOME_DIR);
        if (home == null) {
            home = System.getenv(ENV_HADOOP_HOME);
        }
        return Shell.checkHadoopHomeInner(home);
    }

    @VisibleForTesting
    static File checkHadoopHomeInner(String home) throws FileNotFoundException {
        if (home == null) {
            throw new FileNotFoundException(E_HADOOP_PROPS_UNSET);
        }
        while (home.startsWith("\"")) {
            home = home.substring(1);
        }
        while (home.endsWith("\"")) {
            home = home.substring(0, home.length() - 1);
        }
        if (home.isEmpty()) {
            throw new FileNotFoundException(E_HADOOP_PROPS_EMPTY);
        }
        File homedir = new File(home);
        if (!homedir.isAbsolute()) {
            throw new FileNotFoundException("Hadoop home directory " + homedir + " " + E_IS_RELATIVE);
        }
        if (!homedir.exists()) {
            throw new FileNotFoundException("Hadoop home directory " + homedir + " " + E_DOES_NOT_EXIST);
        }
        if (!homedir.isDirectory()) {
            throw new FileNotFoundException("Hadoop home directory " + homedir + " " + E_NOT_DIRECTORY);
        }
        return homedir;
    }

    private static String addOsText(String message) {
        return WINDOWS ? message + " -see " + WINDOWS_PROBLEMS : message;
    }

    private static FileNotFoundException fileNotFoundException(String text, Exception ex) {
        return (FileNotFoundException)new FileNotFoundException(text).initCause(ex);
    }

    public static String getHadoopHome() throws IOException {
        return Shell.getHadoopHomeDir().getCanonicalPath();
    }

    private static File getHadoopHomeDir() throws FileNotFoundException {
        if (HADOOP_HOME_DIR_FAILURE_CAUSE != null) {
            throw Shell.fileNotFoundException(Shell.addOsText(HADOOP_HOME_DIR_FAILURE_CAUSE.toString()), HADOOP_HOME_DIR_FAILURE_CAUSE);
        }
        return HADOOP_HOME_FILE;
    }

    public static File getQualifiedBin(String executable) throws FileNotFoundException {
        return Shell.getQualifiedBinInner(Shell.getHadoopHomeDir(), executable);
    }

    static File getQualifiedBinInner(File hadoopHomeDir, String executable) throws FileNotFoundException {
        String binDirText = "Hadoop bin directory ";
        File bin = new File(hadoopHomeDir, "bin");
        if (!bin.exists()) {
            throw new FileNotFoundException(Shell.addOsText(binDirText + E_DOES_NOT_EXIST + ": " + bin));
        }
        if (!bin.isDirectory()) {
            throw new FileNotFoundException(Shell.addOsText(binDirText + E_NOT_DIRECTORY + ": " + bin));
        }
        File exeFile = new File(bin, executable);
        if (!exeFile.exists()) {
            throw new FileNotFoundException(Shell.addOsText("Could not locate Hadoop executable: " + exeFile));
        }
        if (!exeFile.isFile()) {
            throw new FileNotFoundException(Shell.addOsText("Not an executable file: " + exeFile));
        }
        try {
            return exeFile.getCanonicalFile();
        }
        catch (IOException e) {
            throw Shell.fileNotFoundException(e.toString(), e);
        }
    }

    public static String getQualifiedBinPath(String executable) throws IOException {
        return Shell.getQualifiedBin(executable).getCanonicalPath();
    }

    public static boolean hasWinutilsPath() {
        return WINUTILS_PATH != null;
    }

    public static String getWinUtilsPath() {
        if (WINUTILS_FAILURE == null) {
            return WINUTILS_PATH;
        }
        throw new RuntimeException(WINUTILS_FAILURE.toString(), WINUTILS_FAILURE);
    }

    public static File getWinUtilsFile() throws FileNotFoundException {
        if (WINUTILS_FAILURE == null) {
            return WINUTILS_FILE;
        }
        throw Shell.fileNotFoundException(WINUTILS_FAILURE.toString(), WINUTILS_FAILURE);
    }

    public static boolean checkIsBashSupported() throws InterruptedIOException {
        if (WINDOWS) {
            return false;
        }
        boolean supported = true;
        try {
            String[] args = new String[]{"bash", "-c", "echo 1000"};
            ShellCommandExecutor shexec = new ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (InterruptedIOException iioe) {
            LOG.warn("Interrupted, unable to determine if bash is supported", (Throwable)iioe);
            throw iioe;
        }
        catch (IOException ioe) {
            LOG.warn("Bash is not supported by the OS", (Throwable)ioe);
            supported = false;
        }
        catch (SecurityException se) {
            LOG.info("Bash execution is not allowed by the JVM security manager.Considering it not supported.");
            supported = false;
        }
        return supported;
    }

    /*
     * Exception decompiling
     */
    private static boolean isSetsidSupported() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Shell() {
        this(0L);
    }

    protected Shell(long interval) {
        this(interval, false);
    }

    protected Shell(long interval, boolean redirectErrorStream) {
        this.interval = interval;
        this.lastTime = interval < 0L ? 0L : -interval;
        this.redirectErrorStream = redirectErrorStream;
    }

    protected void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    protected void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > Time.monotonicNow()) {
            return;
        }
        this.exitCode = 0;
        if (MAC) {
            System.setProperty("jdk.lang.Process.launchMechanism", "POSIX_SPAWN");
        }
        this.runCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommand() throws IOException {
        Object hadoop_opts;
        String debug_opts;
        String jmx_opts;
        ProcessBuilder builder = new ProcessBuilder(this.getExecString());
        Timer timeOutTimer = null;
        ShellTimeoutTimerTask timeoutTimerTask = null;
        this.timedOut.set(false);
        this.completed.set(false);
        if (!this.inheritParentEnv) {
            builder.environment().clear();
        }
        if (this.environment != null) {
            builder.environment().putAll(this.environment);
        }
        if (!this.inheritParentEnv) {
            builder.environment().remove("HADOOP_CREDSTORE_PASSWORD");
        }
        if ((jmx_opts = builder.environment().get(ENV_MAPR_JMX_OPTS)) != null) {
            String hadoop_opts2 = builder.environment().get(ENV_HADOOP_OPTS);
            hadoop_opts2 = hadoop_opts2.replaceAll(jmx_opts, "");
            builder.environment().put(ENV_HADOOP_OPTS, hadoop_opts2);
        }
        if ((debug_opts = builder.environment().get(ENV_DEBUG_OPTS)) != null) {
            hadoop_opts = builder.environment().get(ENV_HADOOP_OPTS);
            hadoop_opts = ((String)hadoop_opts).replaceAll(debug_opts, "");
            builder.environment().put(ENV_HADOOP_OPTS, (String)hadoop_opts);
        }
        if (this.dir != null) {
            builder.directory(this.dir);
        }
        builder.redirectErrorStream(this.redirectErrorStream);
        if (WINDOWS) {
            hadoop_opts = WindowsProcessLaunchLock;
            synchronized (hadoop_opts) {
                this.process = builder.start();
            }
        } else {
            this.process = builder.start();
        }
        this.waitingThread = Thread.currentThread();
        CHILD_SHELLS.put(this, null);
        if (this.timeOutInterval > 0L) {
            timeOutTimer = new Timer("Shell command timeout");
            timeoutTimerTask = new ShellTimeoutTimerTask(this);
            timeOutTimer.schedule((TimerTask)timeoutTimerTask, this.timeOutInterval);
        }
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
        final StringBuffer errMsg = new StringBuffer();
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        errMsg.append(line).append(System.getProperty("line.separator"));
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    if (!Shell.this.isTimedOut()) {
                        LOG.warn("Error reading the error stream", (Throwable)ioe);
                    }
                    LOG.debug("Error reading the error stream due to shell command timeout", (Throwable)ioe);
                }
            }
        };
        try {
            errThread.start();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (OutOfMemoryError oe) {
            LOG.error("Caught " + oe + ". One possible reason is that ulimit setting of 'max user processes' is too low. If so, do 'ulimit -u <largerNum>' and try again.");
            throw oe;
        }
        try {
            this.parseExecResult(inReader);
            String line = inReader.readLine();
            while (line != null) {
                line = inReader.readLine();
            }
            this.exitCode = this.process.waitFor();
            Shell.joinThread(errThread);
            this.completed.set(true);
            if (this.exitCode != 0) {
                throw new ExitCodeException(this.exitCode, errMsg.toString());
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException iie = new InterruptedIOException(ie.toString());
            iie.initCause(ie);
            throw iie;
        }
        finally {
            if (timeOutTimer != null) {
                timeOutTimer.cancel();
            }
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error while closing the input stream", (Throwable)ioe);
            }
            if (!this.completed.get()) {
                errThread.interrupt();
                Shell.joinThread(errThread);
            }
            try {
                errReader.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error while closing the error stream", (Throwable)ioe);
            }
            this.process.destroy();
            this.waitingThread = null;
            CHILD_SHELLS.remove(this);
            this.lastTime = Time.monotonicNow();
        }
    }

    private static void joinThread(Thread t) {
        while (t.isAlive()) {
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Interrupted while joining on: " + t, (Throwable)ie);
                }
                t.interrupt();
            }
        }
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public String getEnvironment(String env) {
        return this.environment.get(env);
    }

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Thread getWaitingThread() {
        return this.waitingThread;
    }

    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    private void setTimedOut() {
        this.timedOut.set(true);
    }

    public static String execCommand(String ... cmd) throws IOException {
        return Shell.execCommand(null, cmd, 0L);
    }

    public static String execCommand(Map<String, String> env, String[] cmd, long timeout) throws IOException {
        ShellCommandExecutor exec = new ShellCommandExecutor(cmd, null, env, timeout);
        exec.execute();
        return exec.getOutput();
    }

    public static String execCommand(Map<String, String> env, String ... cmd) throws IOException {
        return Shell.execCommand(env, cmd, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAllShellProcesses() {
        Map<Shell, Object> map = CHILD_SHELLS;
        synchronized (map) {
            for (Shell shell : CHILD_SHELLS.keySet()) {
                if (shell.getProcess() == null) continue;
                shell.getProcess().destroy();
            }
            CHILD_SHELLS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Shell> getAllShells() {
        Map<Shell, Object> map = CHILD_SHELLS;
        synchronized (map) {
            return new HashSet<Shell>(CHILD_SHELLS.keySet());
        }
    }

    public static Long getMemlockLimit(Long ulimit) {
        if (WINDOWS) {
            return Math.min(Integer.MAX_VALUE, ulimit);
        }
        return ulimit;
    }

    static {
        IOException ex;
        File home;
        CHILD_SHELLS = Collections.synchronizedMap(new WeakHashMap());
        LOG = LoggerFactory.getLogger(Shell.class);
        JAVA_SPEC_VER = Math.max(8, Integer.parseInt(System.getProperty("java.specification.version").split("\\.")[0]));
        WindowsProcessLaunchLock = new Object();
        osType = Shell.getOSType();
        WINDOWS = osType == OSType.OS_TYPE_WIN;
        SOLARIS = osType == OSType.OS_TYPE_SOLARIS;
        MAC = osType == OSType.OS_TYPE_MAC;
        FREEBSD = osType == OSType.OS_TYPE_FREEBSD;
        LINUX = osType == OSType.OS_TYPE_LINUX;
        OTHER = osType == OSType.OS_TYPE_OTHER;
        PPC_64 = System.getProperties().getProperty("os.arch").contains("ppc64");
        try {
            home = Shell.checkHadoopHome();
            ex = null;
        }
        catch (IOException ioe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to detect a valid hadoop home directory", (Throwable)ioe);
            }
            ex = ioe;
            home = null;
        }
        HADOOP_HOME_FILE = home;
        HADOOP_HOME_DIR_FAILURE_CAUSE = ex;
        IOException ioe = null;
        String path = null;
        File file = null;
        if (WINDOWS) {
            try {
                file = Shell.getQualifiedBin(WINUTILS_EXE);
                path = file.getCanonicalPath();
                ioe = null;
            }
            catch (IOException e) {
                LOG.warn("Did not find {}: {}", (Object)WINUTILS_EXE, (Object)e);
                LOG.debug("Failed to find winutils.exe", (Throwable)e);
                file = null;
                path = null;
                ioe = e;
            }
        } else {
            ioe = new FileNotFoundException(E_NOT_A_WINDOWS_SYSTEM);
        }
        WINUTILS_PATH = path;
        WINUTILS_FILE = file;
        WINUTILS = path;
        WINUTILS_FAILURE = ioe;
        isSetsidAvailable = Shell.isSetsidSupported();
        TOKEN_SEPARATOR_REGEX = WINDOWS ? "[|\n\r]" : "[ \t\n\r\f]";
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private final Shell shell;

        public ShellTimeoutTimerTask(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            block2: {
                Process p = this.shell.getProcess();
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    if (p == null || this.shell.completed.get()) break block2;
                    this.shell.setTimedOut();
                    p.destroy();
                }
            }
        }
    }

    public static class ShellCommandExecutor
    extends Shell
    implements CommandExecutor {
        private String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] execString) {
            this(execString, null);
        }

        public ShellCommandExecutor(String[] execString, File dir) {
            this(execString, dir, null);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env) {
            this(execString, dir, env, 0L);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env, long timeout) {
            this(execString, dir, env, timeout, true);
        }

        public ShellCommandExecutor(String[] execString, File dir, Map<String, String> env, long timeout, boolean inheritParentEnv) {
            this.command = (String[])execString.clone();
            if (dir != null) {
                this.setWorkingDirectory(dir);
            }
            if (env != null) {
                this.setEnvironment(env);
            }
            this.timeOutInterval = timeout;
            this.inheritParentEnv = inheritParentEnv;
        }

        @VisibleForTesting
        public long getTimeoutInterval() {
            return this.timeOutInterval;
        }

        @Override
        public void execute() throws IOException {
            for (String s : this.command) {
                if (s != null) continue;
                throw new IOException("(null) entry in command string: " + StringUtils.join((CharSequence)" ", this.command));
            }
            this.run();
        }

        @Override
        public String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            int nRead;
            this.output = new StringBuffer();
            char[] buf = new char[512];
            while ((nRead = lines.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, nRead);
            }
        }

        @Override
        public String getOutput() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] args;
            StringBuilder builder = new StringBuilder();
            for (String s : args = this.getExecString()) {
                if (s.indexOf(32) >= 0) {
                    builder.append('\"').append(s).append('\"');
                } else {
                    builder.append(s);
                }
                builder.append(' ');
            }
            return builder.toString();
        }

        @Override
        public void close() {
        }
    }

    public static interface CommandExecutor {
        public void execute() throws IOException;

        public int getExitCode() throws IOException;

        public String getOutput() throws IOException;

        public void close();
    }

    public static class ExitCodeException
    extends IOException {
        private final int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ExitCodeException ");
            sb.append("exitCode=").append(this.exitCode).append(": ").append(super.getMessage());
            return sb.toString();
        }
    }

    public static enum OSType {
        OS_TYPE_LINUX,
        OS_TYPE_WIN,
        OS_TYPE_SOLARIS,
        OS_TYPE_MAC,
        OS_TYPE_FREEBSD,
        OS_TYPE_OTHER;

    }
}

