/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.cedarsoftware.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.shaded.com.cedarsoftware.util.ByteUtilities;
import org.apache.hadoop.shaded.com.cedarsoftware.util.IOUtilities;

public class EncryptionUtilities {
    private EncryptionUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fastMD5(File file) {
        String string;
        FileInputStream in = null;
        try {
            int nRead;
            in = new FileInputStream(file);
            FileChannel ch = in.getChannel();
            MessageDigest d = EncryptionUtilities.getMD5Digest();
            ByteBuffer bb = ByteBuffer.allocateDirect(65536);
            while ((nRead = ch.read(bb)) != -1) {
                if (nRead == 0) continue;
                bb.position(0);
                bb.limit(nRead);
                d.update(bb);
                bb.clear();
            }
            string = ByteUtilities.encode(d.digest());
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
            IOUtilities.close(in);
            return string2;
        }
        IOUtilities.close(in);
        return string;
    }

    public static String calculateMD5Hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }

    public static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The requested MessageDigest (MD5) does not exist", e);
        }
    }

    public static String calculateSHA1Hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest d = EncryptionUtilities.getSHA1Digest();
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }

    public static MessageDigest getSHA1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The requested MessageDigest (SHA-1) does not exist", e);
        }
    }

    public static String calculateSHA256Hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest d = EncryptionUtilities.getSHA256Digest();
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }

    public static MessageDigest getSHA256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The requested MessageDigest (SHA-256) does not exist", e);
        }
    }

    public static String calculateSHA512Hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest d = EncryptionUtilities.getSHA512Digest();
        d.update(bytes);
        return ByteUtilities.encode(d.digest());
    }

    public static MessageDigest getSHA512Digest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The requested MessageDigest (SHA-512) does not exist", e);
        }
    }

    public static byte[] createCipherBytes(String key, int bitsNeeded) {
        String word = EncryptionUtilities.calculateMD5Hash(key.getBytes());
        return word.substring(0, bitsNeeded / 8).getBytes();
    }

    public static Cipher createAesEncryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 1);
    }

    public static Cipher createAesDecryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 2);
    }

    public static Cipher createAesCipher(String key, int mode) throws Exception {
        SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.createCipherBytes(key, 128), "AES");
        return EncryptionUtilities.createAesCipher(sKey, mode);
    }

    public static Cipher createAesCipher(Key key, int mode) throws Exception {
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(key.getEncoded());
        byte[] iv = d.digest();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    public static String encrypt(String key, String content) {
        try {
            return ByteUtilities.encode(EncryptionUtilities.createAesEncryptionCipher(key).doFinal(content.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred encrypting data", e);
        }
    }

    public static String decrypt(String key, String hexStr) {
        try {
            return new String(EncryptionUtilities.createAesDecryptionCipher(key).doFinal(ByteUtilities.decode(hexStr)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occurred decrypting data", e);
        }
    }
}

