/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateOp
extends Operation {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOp.class);
    private static int DEF_IO_BUFFER_SIZE = 4096;
    private static final String IO_BUF_CONFIG = "io.file.buffer.size";

    CreateOp(ConfigExtractor cfg, Random rnd) {
        super(CreateOp.class.getSimpleName(), cfg, rnd);
    }

    private long determineBlockSize() {
        Range<Long> blockSizeRange = this.getConfig().getBlockSize();
        long blockSize = Range.betweenPositive(this.getRandom(), blockSizeRange);
        Long byteChecksum = this.getConfig().getByteCheckSum();
        if (byteChecksum == null) {
            return blockSize;
        }
        long full = blockSize / byteChecksum * byteChecksum;
        long toFull = blockSize - full;
        if (toFull >= byteChecksum / 2L) {
            full += byteChecksum.longValue();
        }
        if (full > blockSizeRange.getUpper()) {
            full = blockSizeRange.getUpper();
        }
        if (full < blockSizeRange.getLower()) {
            full = blockSizeRange.getLower();
        }
        return full;
    }

    private short determineReplication() {
        Range<Short> replicationAmountRange = this.getConfig().getReplication();
        Range<Long> repRange = new Range<Long>(replicationAmountRange.getLower().longValue(), replicationAmountRange.getUpper().longValue());
        short replicationAmount = (short)Range.betweenPositive(this.getRandom(), repRange);
        return replicationAmount;
    }

    private int getBufferSize() {
        return this.getConfig().getConfig().getInt(IO_BUF_CONFIG, DEF_IO_BUFFER_SIZE);
    }

    protected Path getCreateFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        FSDataOutputStream os = null;
        try {
            Path fn = this.getCreateFile();
            Range<Long> writeSizeRange = this.getConfig().getWriteSize();
            long writeSize = 0L;
            long blockSize = this.determineBlockSize();
            short replicationAmount = this.determineReplication();
            if (this.getConfig().shouldWriteUseBlockSize()) {
                writeSizeRange = this.getConfig().getBlockSize();
            }
            writeSize = Range.betweenPositive(this.getRandom(), writeSizeRange);
            long bytesWritten = 0L;
            long timeTaken = 0L;
            int bufSize = this.getBufferSize();
            boolean overWrite = false;
            DataWriter writer = new DataWriter(this.getRandom());
            LOG.info("Attempting to create file at " + fn + " of size " + Helper.toByteInfo(writeSize) + " using blocksize " + Helper.toByteInfo(blockSize) + " and replication amount " + replicationAmount);
            long startTime = Timer.now();
            os = fs.create(fn, overWrite, bufSize, replicationAmount, blockSize);
            timeTaken += Timer.elapsed(startTime);
            DataWriter.GenerateOutput stats = writer.writeSegment(writeSize, (OutputStream)os);
            timeTaken += stats.getTimeTaken();
            startTime = Timer.now();
            os.close();
            os = null;
            LOG.info("Created file at " + fn + " of size " + Helper.toByteInfo(bytesWritten += stats.getBytesWritten()) + " bytes using blocksize " + Helper.toByteInfo(blockSize) + " and replication amount " + replicationAmount + " in " + (timeTaken += Timer.elapsed(startTime)) + " milliseconds");
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", bytesWritten));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn("Error with creating", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing create stream", (Throwable)e);
                }
            }
        }
        return out;
    }
}

