/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFileSystemLocalFileSystem
extends ViewFileSystemBaseTest {
    private static final Log LOG = LogFactory.getLog(TestViewFileSystemLocalFileSystem.class);

    @Override
    @Before
    public void setUp() throws Exception {
        this.fsTarget = FileSystem.getLocal((Configuration)new Configuration());
        super.setUp();
    }

    @Override
    Path getTrashRootInFallBackFS() throws IOException {
        return new Path("/.Trash/" + UserGroupInformation.getCurrentUser().getShortUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNflyWriteSimple() throws IOException {
        LOG.info((Object)"Starting testNflyWriteSimple");
        URI[] testUris = new URI[]{URI.create(this.targetTestRoot + "/nfwd1"), URI.create(this.targetTestRoot + "/nfwd2")};
        String testFileName = "test.txt";
        Configuration testConf = new Configuration(this.conf);
        String testString = "Hello Nfly!";
        Path nflyRoot = new Path("/nflyroot");
        ConfigUtil.addLinkNfly((Configuration)testConf, (String)nflyRoot.toString(), (URI[])testUris);
        FileSystem nfly = FileSystem.get((URI)URI.create("viewfs:///"), (Configuration)testConf);
        try (FSDataOutputStream fsDos = nfly.create(new Path(nflyRoot, "test.txt"));){
            fsDos.writeUTF("Hello Nfly!");
        }
        FileStatus[] statuses = nfly.listStatus(nflyRoot);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)testConf);
        for (URI testUri : testUris) {
            Path testFile = new Path(new Path(testUri), "test.txt");
            Assert.assertTrue((String)(testFile + " should exist!"), (boolean)lfs.exists(testFile));
            try (FSDataInputStream fsdis = lfs.open(testFile);){
                Assert.assertEquals((String)"Wrong file content", (Object)"Hello Nfly!", (Object)fsdis.readUTF());
            }
        }
    }

    @Test
    public void testNflyInvalidMinReplication() throws Exception {
        LOG.info((Object)"Starting testNflyInvalidMinReplication");
        URI[] testUris = new URI[]{URI.create(this.targetTestRoot + "/nfwd1"), URI.create(this.targetTestRoot + "/nfwd2")};
        Configuration conf = new Configuration();
        ConfigUtil.addLinkNfly((Configuration)conf, (String)"mt", (String)"/nflyroot", (String)"minReplication=4", (URI[])testUris);
        try {
            FileSystem.get((URI)URI.create("viewfs://mt/"), (Configuration)conf);
            Assert.fail((String)"Expected bad minReplication exception.");
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"No minReplication message", (boolean)ioe.getMessage().contains("Minimum replication"));
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        super.tearDown();
    }
}

