/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.GCMParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GcmSpecUtil {
    static final Class gcmSpecClass = GcmSpecUtil.lookup("javax.crypto.spec.GCMParameterSpec");

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static AlgorithmParameterSpec createGcmSpec(byte[] byArray, int n) throws InvalidParameterSpecException {
        return new GCMParameterSpec(n * 8, byArray);
    }

    static Class lookup(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                try {
                    ClassLoader classLoader = GcmSpecUtil.class.getClassLoader();
                    return classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }
}

