/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SubClusterState {
    SC_NEW,
    SC_RUNNING,
    SC_UNHEALTHY,
    SC_DECOMMISSIONING,
    SC_DECOMMISSIONED,
    SC_LOST,
    SC_UNREGISTERED;

    public static final Logger LOG;

    public boolean isUnusable() {
        return this != SC_RUNNING && this != SC_NEW;
    }

    public boolean isActive() {
        return this == SC_RUNNING;
    }

    public boolean isFinal() {
        return this == SC_UNREGISTERED || this == SC_DECOMMISSIONED || this == SC_LOST;
    }

    public static SubClusterState fromString(String x) {
        try {
            return SubClusterState.valueOf(x);
        }
        catch (Exception e) {
            LOG.error("Invalid SubCluster State value in the StateStore does not match with the YARN Federation standard.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(SubClusterState.class);
    }
}

