/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleEventFetcher;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleFetcher;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleMergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffleSchedulerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.Shuffle;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.util.Progress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectShuffle<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final int PROGRESS_FREQUENCY = 2000;
    private static final int MAX_EVENTS_TO_FETCH = 10000;
    private static final int MIN_EVENTS_TO_FETCH = 100;
    private static final int MAX_RPC_OUTSTANDING_EVENTS = 3000000;
    private static final Logger LOG = LoggerFactory.getLogger(DirectShuffle.class);
    private ShuffleConsumerPlugin.Context<K, V> context;
    private TaskAttemptID reduceId;
    private JobConf jobConf;
    private TaskUmbilicalProtocol umbilical;
    private Reporter reporter;
    private ShuffleClientMetrics metrics;
    private Progress copyPhase;
    private TaskStatus taskStatus;
    private Task reduceTask;
    private DirectShuffleSchedulerImpl<K, V> scheduler;
    private MergeManager<K, V> merger;
    private Throwable throwable = null;
    private String throwingThreadName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportException(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
            this.throwingThreadName = Thread.currentThread().getName();
            DirectShuffleSchedulerImpl<K, V> directShuffleSchedulerImpl = this.scheduler;
            synchronized (directShuffleSchedulerImpl) {
                this.scheduler.notifyAll();
            }
        }
    }

    public void init(ShuffleConsumerPlugin.Context<K, V> context) {
        this.context = context;
        this.reduceId = context.getReduceId();
        this.jobConf = context.getJobConf();
        this.umbilical = context.getUmbilical();
        this.reporter = context.getReporter();
        this.metrics = new ShuffleClientMetrics(this.reduceId, this.jobConf);
        this.copyPhase = context.getCopyPhase();
        this.taskStatus = context.getStatus();
        this.reduceTask = context.getReduceTask();
        this.scheduler = new DirectShuffleSchedulerImpl(this.jobConf, this.taskStatus, this.reduceId, this, this.copyPhase, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        try {
            this.merger = this.createMergeManager(this.context);
        }
        catch (IOException e) {
            LOG.error("Unable to create MergeManager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawKeyValueIterator run() throws IOException, InterruptedException {
        int eventsPerReducer = Math.max(100, 3000000 / this.jobConf.getNumReduceTasks());
        int maxEventsToFetch = Math.min(10000, eventsPerReducer);
        DirectShuffleEventFetcher<K, V> eventFetcher = new DirectShuffleEventFetcher<K, V>(this.reduceId, this.umbilical, this.scheduler, this, maxEventsToFetch);
        eventFetcher.start();
        int numFetchers = this.jobConf.getInt("mapreduce.reduce.shuffle.parallelcopies", 5);
        DirectShuffleFetcher[] fetchers = new DirectShuffleFetcher[numFetchers];
        for (int i = 0; i < numFetchers; ++i) {
            fetchers[i] = new DirectShuffleFetcher<K, V>(i, this.jobConf, this.reduceId, this.scheduler, this.merger, this.reporter, this.metrics, this, this.context.getMapOutputFile());
            fetchers[i].start();
        }
        while (!this.scheduler.waitUntilDone(2000)) {
            this.reporter.progress();
            DirectShuffle i = this;
            synchronized (i) {
                if (this.throwable != null) {
                    throw new Shuffle.ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
                }
            }
        }
        eventFetcher.shutDown();
        for (DirectShuffleFetcher fetcher : fetchers) {
            fetcher.shutDown();
        }
        this.scheduler.close();
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        RawKeyValueIterator kvIter = null;
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new Shuffle.ShuffleError("Error while doing final merge ", e);
        }
        DirectShuffle directShuffle = this;
        synchronized (directShuffle) {
            if (this.throwable != null) {
                throw new Shuffle.ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
            }
        }
        return kvIter;
    }

    public void close() {
    }

    protected MergeManager<K, V> createMergeManager(ShuffleConsumerPlugin.Context<K, V> context) throws IOException {
        return new DirectShuffleMergeManagerImpl(this.reduceId, this.jobConf, context.getLocalFS(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), this, context.getMergePhase(), context.getMapOutputFile());
    }
}

