/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUmbilicalProtocolWithJobToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Logger LOG = LoggerFactory.getLogger(TestUmbilicalProtocolWithJobToken.class);
    private static Configuration conf = new Configuration();

    @Test
    public void testJobTokenRpc() throws Exception {
        TaskUmbilicalProtocol mockTT = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)19L).when((Object)mockTT)).getProtocolVersion(Matchers.anyString(), Matchers.anyLong());
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)ProtocolSignature.getProtocolSignature((VersionedProtocol)mockTT, (String)TaskUmbilicalProtocol.class.getName(), (long)19L, (int)0)).when((Object)mockTT)).getProtocolSignature(Matchers.anyString(), Matchers.anyLong(), Matchers.anyInt());
        JobTokenSecretManager sm = new JobTokenSecretManager();
        RPC.Server server = new RPC.Builder(conf).setProtocol(TaskUmbilicalProtocol.class).setInstance((Object)mockTT).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager((SecretManager)sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        String jobId = current.getUserName();
        JobTokenIdentifier tokenId = new JobTokenIdentifier(new Text(jobId));
        Token token = new Token((TokenIdentifier)tokenId, (SecretManager)sm);
        sm.addTokenForJob(jobId, token);
        SecurityUtil.setTokenService((Token)token, (InetSocketAddress)addr);
        LOG.info("Service address for token is " + token.getService());
        current.addToken(token);
        current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Server)server){
            final /* synthetic */ Server val$server;
            {
                this.val$server = server;
            }

            @Override
            public Object run() throws Exception {
                TaskUmbilicalProtocol proxy = null;
                try {
                    proxy = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, (long)19L, (InetSocketAddress)addr, (Configuration)conf);
                    proxy.ping(null);
                }
                finally {
                    this.val$server.stop();
                    if (proxy != null) {
                        RPC.stopProxy((Object)proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)conf);
        GenericTestUtils.setLogLevel((Logger)Client.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)Server.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslRpcClient.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslRpcServer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)SaslInputStream.LOG, (Level)Level.TRACE);
    }
}

