/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFilter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestSequenceFileInputFilter {
    private static final Logger LOG = FileInputFormat.LOG;
    private static final int MAX_LENGTH = 15000;
    private static final Configuration conf = new Configuration();
    private static final JobConf job = new JobConf(conf);
    private static final FileSystem fs;
    private static final Path inDir;
    private static final Path inFile;
    private static final Random random;
    private static final Reporter reporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSequenceFile(int numRecords) throws Exception {
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inFile, Text.class, BytesWritable.class);){
            for (int i = 1; i <= numRecords; ++i) {
                Text key = new Text(Integer.toString(i));
                byte[] data = new byte[random.nextInt(10)];
                random.nextBytes(data);
                BytesWritable value = new BytesWritable(data);
                writer.append((Writable)key, (Writable)value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countRecords(int numSplits) throws IOException {
        SequenceFileInputFilter format = new SequenceFileInputFilter();
        Text key = new Text();
        BytesWritable value = new BytesWritable();
        if (numSplits == 0) {
            numSplits = random.nextInt(150) + 1;
        }
        InputSplit[] splits = format.getSplits(job, numSplits);
        int count = 0;
        LOG.info("Generated " + splits.length + " splits.");
        for (int j = 0; j < splits.length; ++j) {
            try (RecordReader reader = format.getRecordReader(splits[j], job, reporter);){
                while (reader.next((Object)key, (Object)value)) {
                    LOG.info("Accept record " + key.toString());
                    ++count;
                }
                continue;
            }
        }
        return count;
    }

    @Test
    public void testRegexFilter() throws Exception {
        LOG.info("Testing Regex Filter with patter: \\A10*");
        SequenceFileInputFilter.setFilterClass((Configuration)job, SequenceFileInputFilter.RegexFilter.class);
        SequenceFileInputFilter.RegexFilter.setPattern((Configuration)job, (String)"\\A10*");
        fs.delete(inDir, true);
        for (int length = 1; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info("******Number of records: " + length);
            TestSequenceFileInputFilter.createSequenceFile(length);
            int count = this.countRecords(0);
            Assert.assertEquals((long)count, (long)(length == 0 ? 0L : (long)((int)Math.log10(length) + 1)));
        }
        fs.delete(inDir, true);
    }

    @Test
    public void testPercentFilter() throws Exception {
        LOG.info("Testing Percent Filter with frequency: 1000");
        SequenceFileInputFilter.setFilterClass((Configuration)job, SequenceFileInputFilter.PercentFilter.class);
        SequenceFileInputFilter.PercentFilter.setFrequency((Configuration)job, (int)1000);
        fs.delete(inDir, true);
        for (int length = 0; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info("******Number of records: " + length);
            TestSequenceFileInputFilter.createSequenceFile(length);
            int count = this.countRecords(1);
            LOG.info("Accepted " + count + " records");
            int expectedCount = length / 1000;
            if (expectedCount * 1000 != length) {
                ++expectedCount;
            }
            Assert.assertEquals((long)count, (long)expectedCount);
        }
        fs.delete(inDir, true);
    }

    @Test
    public void testMD5Filter() throws Exception {
        LOG.info("Testing MD5 Filter with frequency: 1000");
        SequenceFileInputFilter.setFilterClass((Configuration)job, SequenceFileInputFilter.MD5Filter.class);
        SequenceFileInputFilter.MD5Filter.setFrequency((Configuration)job, (int)1000);
        fs.delete(inDir, true);
        for (int length = 0; length < 15000; length += random.nextInt(1500) + 1) {
            LOG.info("******Number of records: " + length);
            TestSequenceFileInputFilter.createSequenceFile(length);
            LOG.info("Accepted " + this.countRecords(0) + " records");
        }
        fs.delete(inDir, true);
    }

    static {
        inDir = new Path(System.getProperty("test.build.data", ".") + "/mapred");
        inFile = new Path(inDir, "test.seq");
        random = new Random(1L);
        reporter = Reporter.NULL;
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inDir});
        try {
            fs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

