/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestConcatenatedCompressedInput {
    private static final Logger LOG = LoggerFactory.getLogger(TestConcatenatedCompressedInput.class);
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    static final String COLOR_RED = "\u001b[0;31m";
    static final String COLOR_GREEN = "\u001b[0;32m";
    static final String COLOR_YELLOW = "\u001b[0;33;40m";
    static final String COLOR_BLUE = "\u001b[0;34m";
    static final String COLOR_MAGENTA = "\u001b[0;35m";
    static final String COLOR_CYAN = "\u001b[0;36m";
    static final String COLOR_WHITE = "\u001b[0;37;40m";
    static final String COLOR_BR_RED = "\u001b[1;31m";
    static final String COLOR_BR_GREEN = "\u001b[1;32m";
    static final String COLOR_BR_YELLOW = "\u001b[1;33;40m";
    static final String COLOR_BR_BLUE = "\u001b[1;34m";
    static final String COLOR_BR_MAGENTA = "\u001b[1;35m";
    static final String COLOR_BR_CYAN = "\u001b[1;36m";
    static final String COLOR_BR_WHITE = "\u001b[1;37;40m";
    static final String COLOR_NORMAL = "\u001b[0m";
    private static Path workDir;
    private static final Reporter voidReporter;

    private static LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), (Configuration)defaultConf);
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(TextInputFormat format, InputSplit split, JobConf jobConf) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, jobConf, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        reader.close();
        return result;
    }

    @Test
    public void testGzip() throws IOException {
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)jobConf);
        localFs.delete(workDir, true);
        if (BuiltInGzipDecompressor.class != gzip.getDecompressorType()) {
            LOG.warn("testGzip() skipped:  native (C/C++) libs not loaded");
            return;
        }
        System.out.println("\u001b[1;31mtestGzip() using native-zlib Decompressor (" + gzip.getDecompressorType() + ")\u001b[0m");
        String fn = "concat" + gzip.getDefaultExtension();
        Path fnLocal = new Path(System.getProperty("test.concat.data", "/tmp"), fn);
        Path fnHDFS = new Path(workDir, fn);
        localFs.copyFromLocalFile(fnLocal, fnHDFS);
        TestConcatenatedCompressedInput.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "this is a test\nof gzip\n");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(jobConf);
        InputSplit[] splits = format.getSplits(jobConf, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestConcatenatedCompressedInput.readSplit(format, splits[0], jobConf);
        Assert.assertEquals((String)"splits[0] num lines", (long)6L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)"member #3", (Object)results.get(5).toString());
        results = TestConcatenatedCompressedInput.readSplit(format, splits[1], jobConf);
        Assert.assertEquals((String)"splits[1] num lines", (long)2L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"this is a test", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[1][1]", (Object)"of gzip", (Object)results.get(1).toString());
    }

    @Test
    public void testPrototypeInflaterGzip() throws IOException {
        int xlen;
        GzipCodec gzip = new GzipCodec();
        localFs.delete(workDir, true);
        System.out.println("\u001b[1;34mtestPrototypeInflaterGzip() using non-native/Java Inflater and manual gzip header/trailer parsing\u001b[0m");
        String fn = "concat" + gzip.getDefaultExtension();
        Path fnLocal = new Path(System.getProperty("test.concat.data", "/tmp"), fn);
        Path fnHDFS = new Path(workDir, fn);
        localFs.copyFromLocalFile(fnLocal, fnHDFS);
        FileInputStream in = new FileInputStream(fnLocal.toString());
        Assert.assertEquals((String)"concat bytes available", (long)148L, (long)in.available());
        byte[] compressedBuf = new byte[256];
        int numBytesRead = in.read(compressedBuf, 0, 10);
        Assert.assertEquals((String)"header bytes read", (long)10L, (long)numBytesRead);
        Assert.assertEquals((String)"1st byte", (long)31L, (long)(compressedBuf[0] & 0xFF));
        Assert.assertEquals((String)"2nd byte", (long)139L, (long)(compressedBuf[1] & 0xFF));
        Assert.assertEquals((String)"3rd byte (compression method)", (long)8L, (long)(compressedBuf[2] & 0xFF));
        byte flags = (byte)(compressedBuf[3] & 0xFF);
        if ((flags & 4) != 0) {
            numBytesRead = in.read(compressedBuf, 0, 2);
            Assert.assertEquals((String)"XLEN bytes read", (long)2L, (long)numBytesRead);
            xlen = (compressedBuf[1] << 8 | compressedBuf[0]) & 0xFFFF;
            in.skip(xlen);
        }
        if ((flags & 8) != 0) {
            while ((numBytesRead = in.read()) != 0) {
                Assert.assertFalse((String)"unexpected end-of-file while reading filename", (numBytesRead == -1 ? 1 : 0) != 0);
            }
        }
        if ((flags & 0x10) != 0) {
            while ((numBytesRead = in.read()) != 0) {
                Assert.assertFalse((String)"unexpected end-of-file while reading comment", (numBytesRead == -1 ? 1 : 0) != 0);
            }
        }
        if ((flags & 0xE0) != 0) {
            Assert.assertTrue((String)"reserved bits are set??", ((flags & 0xE0) == 0 ? 1 : 0) != 0);
        }
        if ((flags & 2) != 0) {
            numBytesRead = in.read(compressedBuf, 0, 2);
            Assert.assertEquals((String)"CRC16 bytes read", (long)2L, (long)numBytesRead);
            xlen = (compressedBuf[1] << 8 | compressedBuf[0]) & 0xFFFF;
        }
        numBytesRead = in.read(compressedBuf);
        byte[] uncompressedBuf = new byte[256];
        Inflater inflater = new Inflater(true);
        inflater.setInput(compressedBuf, 0, numBytesRead);
        try {
            int numBytesUncompressed = inflater.inflate(uncompressedBuf);
            String outString = new String(uncompressedBuf, 0, numBytesUncompressed, "UTF-8");
            System.out.println("uncompressed data of first gzip member = [" + outString + "]");
        }
        catch (DataFormatException ex) {
            throw new IOException(ex.getMessage());
        }
        in.close();
    }

    @Test
    public void testBuiltInGzipDecompressor() throws IOException {
        int numBytes;
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setBoolean("io.native.lib.available", false);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)jobConf);
        localFs.delete(workDir, true);
        Assert.assertEquals((String)"[non-native (Java) codec]", BuiltInGzipDecompressor.class, (Object)gzip.getDecompressorType());
        System.out.println("\u001b[1;33;40mtestBuiltInGzipDecompressor() using non-native (Java Inflater) Decompressor (" + gzip.getDecompressorType() + ")\u001b[0m");
        String fn1 = "testConcatThenCompress.txt" + gzip.getDefaultExtension();
        Path fnLocal1 = new Path(System.getProperty("test.concat.data", "/tmp"), fn1);
        Path fnHDFS1 = new Path(workDir, fn1);
        localFs.copyFromLocalFile(fnLocal1, fnHDFS1);
        String fn2 = "testCompressThenConcat.txt" + gzip.getDefaultExtension();
        Path fnLocal2 = new Path(System.getProperty("test.concat.data", "/tmp"), fn2);
        Path fnHDFS2 = new Path(workDir, fn2);
        localFs.copyFromLocalFile(fnLocal2, fnHDFS2);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        FileInputStream in1 = new FileInputStream(fnLocal1.toString());
        FileInputStream in2 = new FileInputStream(fnLocal2.toString());
        Assert.assertEquals((String)"concat bytes available", (long)2734L, (long)in1.available());
        Assert.assertEquals((String)"concat bytes available", (long)3413L, (long)in2.available());
        CompressionInputStream cin2 = gzip.createInputStream((InputStream)in2);
        LineReader in = new LineReader((InputStream)cin2);
        Text out = new Text();
        int totalBytes = 0;
        int lineNum = 0;
        while ((numBytes = in.readLine(out)) > 0) {
            ++lineNum;
            totalBytes += numBytes;
        }
        in.close();
        Assert.assertEquals((String)"total uncompressed bytes in concatenated test file", (long)5346L, (long)totalBytes);
        Assert.assertEquals((String)"total uncompressed lines in concatenated test file", (long)84L, (long)lineNum);
        TestConcatenatedCompressedInput.doMultipleGzipBufferSizes(jobConf, false);
        TestConcatenatedCompressedInput.doMultipleGzipBufferSizes(jobConf, true);
    }

    private static void doMultipleGzipBufferSizes(JobConf jConf, boolean useNative) throws IOException {
        int bufferSize;
        System.out.println("\u001b[0;33;40mdoMultipleGzipBufferSizes() using " + (useNative ? "GzipZlibDecompressor" : "BuiltInGzipDecompressor") + COLOR_NORMAL);
        jConf.setBoolean("io.native.lib.available", useNative);
        for (bufferSize = 1; bufferSize < 34; ++bufferSize) {
            jConf.setInt("io.file.buffer.size", bufferSize);
            TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        }
        bufferSize = 512;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 1024;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 2048;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 4096;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 64512;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 65536;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 66560;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 130048;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 131072;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
        bufferSize = 132096;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleGzipBufferSize(jConf);
    }

    private static void doSingleGzipBufferSize(JobConf jConf) throws IOException {
        TextInputFormat format = new TextInputFormat();
        format.configure(jConf);
        InputSplit[] splits = format.getSplits(jConf, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("testCompressThenConcat.txt.gz")) {
            System.out.println("  (swapping)");
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestConcatenatedCompressedInput.readSplit(format, splits[0], jConf);
        Assert.assertEquals((String)"splits[0] length (num lines)", (long)84L, (long)results.size());
        Assert.assertEquals((String)"splits[0][0]", (Object)"Call me Ishmael. Some years ago--never mind how long precisely--having", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[0][42]", (Object)"Tell me, does the magnetic virtue of the needles of the compasses of", (Object)results.get(42).toString());
        results = TestConcatenatedCompressedInput.readSplit(format, splits[1], jConf);
        Assert.assertEquals((String)"splits[1] length (num lines)", (long)84L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"Call me Ishmael. Some years ago--never mind how long precisely--having", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[1][42]", (Object)"Tell me, does the magnetic virtue of the needles of the compasses of", (Object)results.get(42).toString());
    }

    @Test
    public void testBzip2() throws IOException {
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        BZip2Codec bzip2 = new BZip2Codec();
        ReflectionUtils.setConf((Object)bzip2, (Configuration)jobConf);
        localFs.delete(workDir, true);
        System.out.println("\u001b[1;36mtestBzip2() using non-native CBZip2InputStream (presumably)\u001b[0m");
        String fn = "concat" + bzip2.getDefaultExtension();
        Path fnLocal = new Path(System.getProperty("test.concat.data", "/tmp"), fn);
        Path fnHDFS = new Path(workDir, fn);
        localFs.copyFromLocalFile(fnLocal, fnHDFS);
        TestConcatenatedCompressedInput.writeFile(localFs, new Path(workDir, "part2.txt.bz2"), (CompressionCodec)bzip2, "this is a test\nof bzip2\n");
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(jobConf);
        format.setMinSplitSize(256L);
        InputSplit[] splits = format.getSplits(jobConf, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.bz2")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestConcatenatedCompressedInput.readSplit(format, splits[0], jobConf);
        Assert.assertEquals((String)"splits[0] num lines", (long)6L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)"member #3", (Object)results.get(5).toString());
        results = TestConcatenatedCompressedInput.readSplit(format, splits[1], jobConf);
        Assert.assertEquals((String)"splits[1] num lines", (long)2L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"this is a test", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[1][1]", (Object)"of bzip2", (Object)results.get(1).toString());
    }

    @Test
    public void testMoreBzip2() throws IOException {
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        BZip2Codec bzip2 = new BZip2Codec();
        ReflectionUtils.setConf((Object)bzip2, (Configuration)jobConf);
        localFs.delete(workDir, true);
        System.out.println("\u001b[1;35mtestMoreBzip2() using non-native CBZip2InputStream (presumably)\u001b[0m");
        String fn1 = "testConcatThenCompress.txt" + bzip2.getDefaultExtension();
        Path fnLocal1 = new Path(System.getProperty("test.concat.data", "/tmp"), fn1);
        Path fnHDFS1 = new Path(workDir, fn1);
        localFs.copyFromLocalFile(fnLocal1, fnHDFS1);
        String fn2 = "testCompressThenConcat.txt" + bzip2.getDefaultExtension();
        Path fnLocal2 = new Path(System.getProperty("test.concat.data", "/tmp"), fn2);
        Path fnHDFS2 = new Path(workDir, fn2);
        localFs.copyFromLocalFile(fnLocal2, fnHDFS2);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        FileInputStream in1 = new FileInputStream(fnLocal1.toString());
        FileInputStream in2 = new FileInputStream(fnLocal2.toString());
        Assert.assertEquals((String)"concat bytes available", (long)2567L, (long)in1.available());
        Assert.assertEquals((String)"concat bytes available", (long)3056L, (long)in2.available());
        TestConcatenatedCompressedInput.doMultipleBzip2BufferSizes(jobConf, false);
    }

    private static void doMultipleBzip2BufferSizes(JobConf jConf, boolean useNative) throws IOException {
        int bufferSize;
        System.out.println("\u001b[0;35mdoMultipleBzip2BufferSizes() using default bzip2 decompressor\u001b[0m");
        jConf.setBoolean("io.native.lib.available", useNative);
        for (bufferSize = 1; bufferSize < 34; ++bufferSize) {
            jConf.setInt("io.file.buffer.size", bufferSize);
            TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        }
        bufferSize = 512;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 1024;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 2048;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 4096;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 64512;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 65536;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 66560;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 130048;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 131072;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
        bufferSize = 132096;
        jConf.setInt("io.file.buffer.size", bufferSize);
        TestConcatenatedCompressedInput.doSingleBzip2BufferSize(jConf);
    }

    private static void doSingleBzip2BufferSize(JobConf jConf) throws IOException {
        TextInputFormat format = new TextInputFormat();
        format.configure(jConf);
        format.setMinSplitSize(5500L);
        InputSplit[] splits = format.getSplits(jConf, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("testCompressThenConcat.txt.gz")) {
            System.out.println("  (swapping)");
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestConcatenatedCompressedInput.readSplit(format, splits[0], jConf);
        Assert.assertEquals((String)"splits[0] length (num lines)", (long)84L, (long)results.size());
        Assert.assertEquals((String)"splits[0][0]", (Object)"Call me Ishmael. Some years ago--never mind how long precisely--having", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[0][42]", (Object)"Tell me, does the magnetic virtue of the needles of the compasses of", (Object)results.get(42).toString());
        results = TestConcatenatedCompressedInput.readSplit(format, splits[1], jConf);
        Assert.assertEquals((String)"splits[1] length (num lines)", (long)84L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"Call me Ishmael. Some years ago--never mind how long precisely--having", (Object)results.get(0).toString());
        Assert.assertEquals((String)"splits[1][42]", (Object)"Tell me, does the magnetic virtue of the needles of the compasses of", (Object)results.get(42).toString());
    }

    private static String unquote(String in) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                ch = in.charAt(++i);
                switch (ch) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    default: {
                        result.append(ch);
                        break;
                    }
                }
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            System.out.println("Working on " + arg);
            LineReader reader = TestConcatenatedCompressedInput.makeStream(TestConcatenatedCompressedInput.unquote(arg));
            Text line = new Text();
            int size = reader.readLine(line);
            while (size > 0) {
                System.out.println("Got: " + line.toString());
                size = reader.readLine(line);
            }
            reader.close();
        }
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestConcatenatedCompressedInput").makeQualified(localFs);
        voidReporter = Reporter.NULL;
    }
}

