/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRBench
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MRBench.class);
    private static Path BASE_DIR = new Path(System.getProperty("test.build.data", "/benchmarks/MRBench"));
    private static Path INPUT_DIR = new Path(BASE_DIR, "mr_input");
    private static Path OUTPUT_DIR = new Path(BASE_DIR, "mr_output");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateTextFile(FileSystem fs, Path inputFile, long numLines, Order sortOrder) throws IOException {
        LOG.info("creating control file: " + numLines + " numLines, " + sortOrder + " sortOrder");
        try (PrintStream output = null;){
            output = new PrintStream((OutputStream)fs.create(inputFile));
            int padding = String.valueOf(numLines).length();
            switch (sortOrder) {
                case RANDOM: {
                    for (long l = 0L; l < numLines; ++l) {
                        output.println(MRBench.pad(new Random().nextLong(), padding));
                    }
                    break;
                }
                case ASCENDING: {
                    for (long l = 0L; l < numLines; ++l) {
                        output.println(MRBench.pad(l, padding));
                    }
                    break;
                }
                case DESCENDING: {
                    for (long l = numLines; l > 0L; --l) {
                        output.println(MRBench.pad(l, padding));
                    }
                    break;
                }
            }
        }
        LOG.info("created control file: " + inputFile);
    }

    private static String pad(long number, int length) {
        String str = String.valueOf(number);
        StringBuffer value = new StringBuffer();
        for (int i = str.length(); i < length; ++i) {
            value.append("0");
        }
        value.append(str);
        return value.toString();
    }

    private JobConf setupJob(int numMaps, int numReduces, String jarFile) {
        JobConf jobConf = new JobConf(this.getConf());
        jobConf.setJarByClass(MRBench.class);
        FileInputFormat.addInputPath((JobConf)jobConf, (Path)INPUT_DIR);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.setOutputFormat(TextOutputFormat.class);
        jobConf.setOutputValueClass(UTF8.class);
        jobConf.setMapOutputKeyClass(UTF8.class);
        jobConf.setMapOutputValueClass(UTF8.class);
        if (null != jarFile) {
            jobConf.setJar(jarFile);
        }
        jobConf.setMapperClass(Map.class);
        jobConf.setReducerClass(Reduce.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(numReduces);
        jobConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
        return jobConf;
    }

    private ArrayList<Long> runJobInSequence(JobConf masterJobConf, int numRuns) throws IOException {
        Random rand = new Random();
        ArrayList<Long> execTimes = new ArrayList<Long>();
        for (int i = 0; i < numRuns; ++i) {
            JobConf jobConf = new JobConf((Configuration)masterJobConf);
            jobConf.setJar(masterJobConf.getJar());
            FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(OUTPUT_DIR, "output_" + rand.nextInt()));
            LOG.info("Running job " + i + ": input=" + FileInputFormat.getInputPaths((JobConf)jobConf)[0] + " output=" + FileOutputFormat.getOutputPath((JobConf)jobConf));
            long curTime = System.currentTimeMillis();
            JobClient.runJob((JobConf)jobConf);
            execTimes.add(new Long(System.currentTimeMillis() - curTime));
        }
        return execTimes;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new MRBench(), (String[])args);
        System.exit(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        String version = "MRBenchmark.0.0.2";
        System.out.println(version);
        String usage = "Usage: mrbench [-baseDir <base DFS path for output/input, default is /benchmarks/MRBench>] [-jar <local path to job jar file containing Mapper and Reducer implementations, default is current jar file>] [-numRuns <number of times to run the job, default is 1>] [-maps <number of maps for each run, default is 2>] [-reduces <number of reduces for each run, default is 1>] [-inputLines <number of input lines to generate, default is 1>] [-inputType <type of input to generate, one of ascending (default), descending, random>] [-verbose]";
        String jarFile = null;
        int inputLines = 1;
        int numRuns = 1;
        int numMaps = 2;
        int numReduces = 1;
        boolean verbose = false;
        Order inputSortOrder = Order.ASCENDING;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-jar")) {
                jarFile = args[++i];
                continue;
            }
            if (args[i].equals("-numRuns")) {
                numRuns = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-baseDir")) {
                BASE_DIR = new Path(args[++i]);
                continue;
            }
            if (args[i].equals("-maps")) {
                numMaps = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-reduces")) {
                numReduces = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-inputLines")) {
                inputLines = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-inputType")) {
                String s;
                if ((s = args[++i]).equalsIgnoreCase("ascending")) {
                    inputSortOrder = Order.ASCENDING;
                    continue;
                }
                if (s.equalsIgnoreCase("descending")) {
                    inputSortOrder = Order.DESCENDING;
                    continue;
                }
                if (s.equalsIgnoreCase("random")) {
                    inputSortOrder = Order.RANDOM;
                    continue;
                }
                inputSortOrder = null;
                continue;
            }
            if (args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            System.err.println(usage);
            System.exit(-1);
        }
        if (numRuns < 1 || numMaps < 1 || numReduces < 1 || inputLines < 0 || inputSortOrder == null) {
            System.err.println(usage);
            return -1;
        }
        JobConf jobConf = this.setupJob(numMaps, numReduces, jarFile);
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        Path inputFile = new Path(INPUT_DIR, "input_" + new Random().nextInt() + ".txt");
        this.generateTextFile(fs, inputFile, inputLines, inputSortOrder);
        fs.mkdirs(BASE_DIR);
        ArrayList<Object> execTimes = new ArrayList();
        try {
            execTimes = this.runJobInSequence(jobConf, numRuns);
        }
        finally {
            fs.delete(BASE_DIR, true);
        }
        if (verbose) {
            System.out.println("Total MapReduce jobs executed: " + numRuns);
            System.out.println("Total lines of data per job: " + inputLines);
            System.out.println("Maps per job: " + numMaps);
            System.out.println("Reduces per job: " + numReduces);
        }
        int i = 0;
        long totalTime = 0L;
        for (Long l : execTimes) {
            totalTime += l.longValue();
            if (!verbose) continue;
            System.out.println("Total milliseconds for task: " + ++i + " = " + l);
        }
        long avgTime = totalTime / (long)numRuns;
        System.out.println("DataLines\tMaps\tReduces\tAvgTime (milliseconds)");
        System.out.println(inputLines + "\t\t" + numMaps + "\t" + numReduces + "\t" + avgTime);
        return 0;
    }

    public static class Reduce
    extends MapReduceBase
    implements Reducer<UTF8, UTF8, UTF8, UTF8> {
        public void reduce(UTF8 key, Iterator<UTF8> values, OutputCollector<UTF8, UTF8> output, Reporter reporter) throws IOException {
            while (values.hasNext()) {
                output.collect((Object)key, (Object)new UTF8(values.next().toString()));
            }
        }
    }

    public static class Map
    extends MapReduceBase
    implements Mapper<WritableComparable, Text, UTF8, UTF8> {
        public void map(WritableComparable key, Text value, OutputCollector<UTF8, UTF8> output, Reporter reporter) throws IOException {
            String line = value.toString();
            output.collect((Object)new UTF8(this.process(line)), (Object)new UTF8(""));
        }

        public String process(String line) {
            return line;
        }
    }

    public static enum Order {
        RANDOM,
        ASCENDING,
        DESCENDING;

    }
}

