/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TruncateOp
extends Operation {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateOp.class);

    TruncateOp(ConfigExtractor cfg, Random rnd) {
        super(TruncateOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getTruncateFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        try {
            Path fn = this.getTruncateFile();
            boolean waitOnTruncate = this.getConfig().shouldWaitOnTruncate();
            long currentSize = fs.getFileStatus(fn).getLen();
            Range<Long> truncateSizeRange = this.getConfig().getTruncateSize();
            if (this.getConfig().shouldTruncateUseBlockSize()) {
                truncateSizeRange = this.getConfig().getBlockSize();
            }
            long truncateSize = Math.max(0L, currentSize - Range.betweenPositive(this.getRandom(), truncateSizeRange));
            long timeTaken = 0L;
            LOG.info("Attempting to truncate file at " + fn + " to size " + Helper.toByteInfo(truncateSize));
            long startTime = Timer.now();
            boolean completed = fs.truncate(fn, truncateSize);
            if (!completed && waitOnTruncate) {
                this.waitForRecovery(fs, fn, truncateSize);
            }
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", 0));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken += Timer.elapsed(startTime)));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
            LOG.info("Truncate file " + fn + " to " + Helper.toByteInfo(truncateSize) + " in " + timeTaken + " milliseconds");
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn("Error with truncating", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn("Error with truncating", (Throwable)e);
        }
        return out;
    }

    private void waitForRecovery(FileSystem fs, Path fn, long newLength) throws IOException {
        FileStatus stat;
        LOG.info("Waiting on truncate file recovery for " + fn);
        while ((stat = fs.getFileStatus(fn)).getLen() != newLength) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

