/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;

class PathFinder {
    private static final String DIR_PREFIX = "sl_dir_";
    private static final String FILE_PREFIX = "sl_file_";
    private Path basePath;
    private ConfigExtractor config;
    private Random rnd;

    PathFinder(ConfigExtractor cfg, Random rnd) {
        this.basePath = cfg.getDataPath();
        this.config = cfg;
        this.rnd = rnd;
    }

    private Path getPath(int curId, int limitPerDir, Type type) {
        if (curId <= 0) {
            return this.basePath;
        }
        Object name = "";
        switch (type) {
            case FILE: {
                name = FILE_PREFIX + new Integer(curId % limitPerDir).toString();
                break;
            }
            case DIRECTORY: {
                name = DIR_PREFIX + new Integer(curId % limitPerDir).toString();
            }
        }
        Path base = this.getPath(curId / limitPerDir, limitPerDir, Type.DIRECTORY);
        return new Path(base, (String)name);
    }

    Path getFile() {
        int fileLimit = this.config.getTotalFiles();
        int dirLimit = this.config.getDirSize();
        int startPoint = 1 + this.rnd.nextInt(fileLimit);
        return this.getPath(startPoint, dirLimit, Type.FILE);
    }

    Path getDirectory() {
        int fileLimit = this.config.getTotalFiles();
        int dirLimit = this.config.getDirSize();
        int startPoint = this.rnd.nextInt(fileLimit);
        return this.getPath(startPoint, dirLimit, Type.DIRECTORY);
    }

    private static enum Type {
        FILE,
        DIRECTORY;

    }
}

