/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.util.StringUtils;

class ArgumentParser {
    private Options optList = this.getOptions();
    private String[] argumentList;
    private ParsedOutput parsed;

    ArgumentParser(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        this.argumentList = args;
        this.parsed = null;
    }

    private Options getOptionList() {
        return this.optList;
    }

    ParsedOutput parse() throws Exception {
        if (this.parsed == null) {
            PosixParser parser = new PosixParser();
            CommandLine popts = parser.parse(this.getOptionList(), this.argumentList, true);
            this.parsed = popts.hasOption(ConfigOption.HELP.getOpt()) ? new ParsedOutput(null, this, true) : new ParsedOutput(popts, this, false);
        }
        return this.parsed;
    }

    private Options getOptions() {
        Options cliopt = new Options();
        cliopt.addOption(ConfigOption.MAPS);
        cliopt.addOption(ConfigOption.REDUCES);
        cliopt.addOption(ConfigOption.PACKET_SIZE);
        cliopt.addOption(ConfigOption.OPS);
        cliopt.addOption(ConfigOption.DURATION);
        cliopt.addOption(ConfigOption.EXIT_ON_ERROR);
        cliopt.addOption(ConfigOption.SLEEP_TIME);
        cliopt.addOption(ConfigOption.TRUNCATE_WAIT);
        cliopt.addOption(ConfigOption.FILES);
        cliopt.addOption(ConfigOption.DIR_SIZE);
        cliopt.addOption(ConfigOption.BASE_DIR);
        cliopt.addOption(ConfigOption.RESULT_FILE);
        cliopt.addOption(ConfigOption.CLEANUP);
        String[] distStrs = new String[Constants.Distribution.values().length];
        Constants.Distribution[] distValues = Constants.Distribution.values();
        for (int i = 0; i < distValues.length; ++i) {
            distStrs[i] = distValues[i].lowerName();
        }
        String opdesc = String.format("pct,distribution where distribution is one of %s", StringUtils.arrayToString((String[])distStrs));
        for (Constants.OperationType type : Constants.OperationType.values()) {
            String opname = type.lowerName();
            cliopt.addOption(new Option(opname, true, opdesc));
        }
        cliopt.addOption(ConfigOption.REPLICATION_AM);
        cliopt.addOption(ConfigOption.BLOCK_SIZE);
        cliopt.addOption(ConfigOption.READ_SIZE);
        cliopt.addOption(ConfigOption.WRITE_SIZE);
        cliopt.addOption(ConfigOption.APPEND_SIZE);
        cliopt.addOption(ConfigOption.TRUNCATE_SIZE);
        cliopt.addOption(ConfigOption.RANDOM_SEED);
        cliopt.addOption(ConfigOption.QUEUE_NAME);
        cliopt.addOption(ConfigOption.HELP);
        return cliopt;
    }

    static class ParsedOutput {
        private CommandLine parsedData;
        private ArgumentParser source;
        private boolean needHelp;

        ParsedOutput(CommandLine parsedData, ArgumentParser source, boolean needHelp) {
            this.parsedData = parsedData;
            this.source = source;
            this.needHelp = needHelp;
        }

        boolean shouldOutputHelp() {
            return this.needHelp;
        }

        void outputHelp() {
            if (!this.shouldOutputHelp()) {
                return;
            }
            if (this.source != null) {
                HelpFormatter hlp = new HelpFormatter();
                hlp.printHelp(Constants.PROG_NAME + " 0.1.0", this.source.getOptionList());
            }
        }

        String getValue(String optName) {
            if (this.parsedData == null) {
                return null;
            }
            return this.parsedData.getOptionValue(optName);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.parsedData != null) {
                Option[] ops = this.parsedData.getOptions();
                for (int i = 0; i < ops.length; ++i) {
                    s.append(ops[i].getOpt() + " = " + s.append(ops[i].getValue()) + ",");
                }
            }
            return s.toString();
        }
    }
}

