/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageHandler;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebImageViewer
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(WebImageViewer.class);
    private Channel channel;
    private InetSocketAddress address;
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelGroup allChannels;

    public WebImageViewer(InetSocketAddress address) {
        this.address = address;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.bootstrap = (ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
    }

    public void start(String fsimage) throws IOException {
        try {
            this.initServer(fsimage);
            this.channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted. Stopping the WebImageViewer.");
            this.close();
        }
    }

    @VisibleForTesting
    public void initServer(String fsimage) throws IOException, InterruptedException {
        final FSImageLoader loader = FSImageLoader.load(fsimage);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new StringEncoder(), new HttpResponseEncoder(), new FSImageHandler(loader, WebImageViewer.this.allChannels)});
            }
        });
        this.channel = this.bootstrap.bind((SocketAddress)this.address).sync().channel();
        this.allChannels.add((Object)this.channel);
        this.address = (InetSocketAddress)this.channel.localAddress();
        LOG.info("WebImageViewer started. Listening on " + this.address.toString() + ". Press Ctrl+C to stop the viewer.");
    }

    @VisibleForTesting
    public int getPort() {
        return this.address.getPort();
    }

    @Override
    public void close() {
        this.allChannels.close().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

