/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.eclipse.jetty.util.log.Log;

public abstract class INodeReference
extends INode {
    private INode referred;

    public static int tryRemoveReference(INode inode) {
        if (!inode.isReference()) {
            return -1;
        }
        return INodeReference.removeReference(inode.asReference());
    }

    private static int removeReference(INodeReference ref) {
        INode referred = ref.getReferredINode();
        if (!(referred instanceof WithCount)) {
            return -1;
        }
        WithCount wc = (WithCount)referred;
        wc.removeReference(ref);
        return wc.getReferenceCount();
    }

    static int getPriorSnapshot(INodeReference ref) {
        WithCount wc = (WithCount)ref.getReferredINode();
        WithName wn = null;
        if (ref instanceof DstReference) {
            wn = wc.getLastWithName();
        } else if (ref instanceof WithName) {
            wn = wc.getPriorWithName((WithName)ref);
        }
        if (wn != null) {
            DirectoryWithSnapshotFeature sf;
            INode referred = wc.getReferredINode();
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                return referred.asFile().getDiffs().getPrior(wn.lastSnapshotId);
            }
            if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                return sf.getDiffs().getPrior(wn.lastSnapshotId);
            }
        }
        return -1;
    }

    public INodeReference(INode parent, INode referred) {
        super(parent);
        this.referred = referred;
    }

    public final INode getReferredINode() {
        return this.referred;
    }

    public final void setReferredINode(INode referred) {
        this.referred = referred;
    }

    @Override
    public final boolean isReference() {
        return true;
    }

    @Override
    public final INodeReference asReference() {
        return this;
    }

    @Override
    public final boolean isFile() {
        return this.referred.isFile();
    }

    @Override
    public final INodeFile asFile() {
        return this.referred.asFile();
    }

    @Override
    public final boolean isDirectory() {
        return this.referred.isDirectory();
    }

    @Override
    public final INodeDirectory asDirectory() {
        return this.referred.asDirectory();
    }

    @Override
    public final boolean isSymlink() {
        return this.referred.isSymlink();
    }

    @Override
    public final INodeSymlink asSymlink() {
        return this.referred.asSymlink();
    }

    @Override
    public byte[] getLocalNameBytes() {
        return this.referred.getLocalNameBytes();
    }

    @Override
    public void setLocalName(byte[] name) {
        this.referred.setLocalName(name);
    }

    @Override
    public final long getId() {
        return this.referred.getId();
    }

    @Override
    public final PermissionStatus getPermissionStatus(int snapshotId) {
        return this.referred.getPermissionStatus(snapshotId);
    }

    @Override
    public final String getUserName(int snapshotId) {
        return this.referred.getUserName(snapshotId);
    }

    @Override
    final void setUser(String user) {
        this.referred.setUser(user);
    }

    @Override
    public final String getGroupName(int snapshotId) {
        return this.referred.getGroupName(snapshotId);
    }

    @Override
    final void setGroup(String group) {
        this.referred.setGroup(group);
    }

    @Override
    public final FsPermission getFsPermission(int snapshotId) {
        return this.referred.getFsPermission(snapshotId);
    }

    @Override
    final AclFeature getAclFeature(int snapshotId) {
        return this.referred.getAclFeature(snapshotId);
    }

    @Override
    final void addAclFeature(AclFeature aclFeature) {
        this.referred.addAclFeature(aclFeature);
    }

    @Override
    final void removeAclFeature() {
        this.referred.removeAclFeature();
    }

    @Override
    final XAttrFeature getXAttrFeature(int snapshotId) {
        return this.referred.getXAttrFeature(snapshotId);
    }

    @Override
    final void addXAttrFeature(XAttrFeature xAttrFeature) {
        this.referred.addXAttrFeature(xAttrFeature);
    }

    @Override
    final void removeXAttrFeature() {
        this.referred.removeXAttrFeature();
    }

    @Override
    public final short getFsPermissionShort() {
        return this.referred.getFsPermissionShort();
    }

    @Override
    void setPermission(FsPermission permission) {
        this.referred.setPermission(permission);
    }

    @Override
    public long getPermissionLong() {
        return this.referred.getPermissionLong();
    }

    @Override
    public final long getModificationTime(int snapshotId) {
        return this.referred.getModificationTime(snapshotId);
    }

    @Override
    public final INode updateModificationTime(long mtime, int latestSnapshotId) {
        return this.referred.updateModificationTime(mtime, latestSnapshotId);
    }

    @Override
    public final void setModificationTime(long modificationTime) {
        this.referred.setModificationTime(modificationTime);
    }

    @Override
    public final long getAccessTime(int snapshotId) {
        return this.referred.getAccessTime(snapshotId);
    }

    @Override
    public final void setAccessTime(long accessTime) {
        this.referred.setAccessTime(accessTime);
    }

    @Override
    public final byte getStoragePolicyID() {
        return this.referred.getStoragePolicyID();
    }

    @Override
    public final byte getLocalStoragePolicyID() {
        return this.referred.getLocalStoragePolicyID();
    }

    @Override
    final void recordModification(int latestSnapshotId) {
        this.referred.recordModification(latestSnapshotId);
    }

    @Override
    public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        return this.referred.cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
    }

    @Override
    public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (INodeReference.removeReference(this) <= 0) {
            this.referred.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
        }
    }

    @Override
    public ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
        return this.referred.computeContentSummary(summary);
    }

    @Override
    public QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts, boolean useCache, int lastSnapshotId) {
        return this.referred.computeQuotaUsage(bsps, blockStoragePolicyId, counts, useCache, lastSnapshotId);
    }

    @Override
    public final INodeAttributes getSnapshotINode(int snapshotId) {
        return this.referred.getSnapshotINode(snapshotId);
    }

    @Override
    public QuotaCounts getQuotaCounts() {
        return this.referred.getQuotaCounts();
    }

    @Override
    public final void clear() {
        super.clear();
        this.referred = null;
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        if (this instanceof DstReference) {
            out.print(", dstSnapshotId=" + ((DstReference)this).dstSnapshotId);
        }
        if (this instanceof WithCount) {
            out.print(", count=" + ((WithCount)this).getReferenceCount());
        }
        out.println();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            b.append(' ');
        }
        b.append("->");
        this.getReferredINode().dumpTreeRecursively(out, b, snapshot);
    }

    public int getDstSnapshotId() {
        return 0x7FFFFFFE;
    }

    public static class DstReference
    extends INodeReference {
        private final int dstSnapshotId;

        @Override
        public final int getDstSnapshotId() {
            return this.dstSnapshotId;
        }

        public DstReference(INodeDirectory parent, WithCount referred, int dstSnapshotId) {
            super(parent, referred);
            this.dstSnapshotId = dstSnapshotId;
            referred.addReference(this);
        }

        @Override
        public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            if (snapshot == 0x7FFFFFFE && prior == -1) {
                QuotaCounts counts = new QuotaCounts.Builder().build();
                this.computeQuotaUsage(bsps, counts, true);
                this.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
                return counts;
            }
            if (prior == -1) {
                prior = DstReference.getPriorSnapshot(this);
            }
            if (snapshot != 0x7FFFFFFE && prior != -1 && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshot, prior) <= 0) {
                return new QuotaCounts.Builder().build();
            }
            return this.getReferredINode().cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
        }

        @Override
        public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            if (INodeReference.removeReference(this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            } else {
                int prior = DstReference.getPriorSnapshot(this);
                Preconditions.checkState((prior != -1 ? 1 : 0) != 0);
                int snapshot = this.getSelfSnapshot(prior);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (referred.isFile()) {
                    INodeFile file = referred.asFile();
                    Preconditions.checkState((boolean)file.isWithSnapshot());
                    file.getFileWithSnapshotFeature().deleteCurrentFile();
                    referred.cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
                } else if (referred.isDirectory()) {
                    INodeDirectory dir = referred.asDirectory();
                    Preconditions.checkState((boolean)dir.isWithSnapshot());
                    try {
                        DirectoryWithSnapshotFeature.destroyDstSubtree(bsps, dir, snapshot, prior, collectedBlocks, removedINodes);
                    }
                    catch (QuotaExceededException e) {
                        LOG.error("should not exceed quota while snapshot deletion", (Throwable)e);
                    }
                }
            }
        }

        private int getSelfSnapshot(int prior) {
            DirectoryWithSnapshotFeature sf;
            WithCount wc = (WithCount)this.getReferredINode().asReference();
            INode referred = wc.getReferredINode();
            int lastSnapshot = 0x7FFFFFFE;
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                lastSnapshot = referred.asFile().getDiffs().getLastSnapshotId();
            } else if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                lastSnapshot = sf.getLastSnapshotId();
            }
            if (lastSnapshot != 0x7FFFFFFE && lastSnapshot != prior) {
                return lastSnapshot;
            }
            return 0x7FFFFFFE;
        }
    }

    public static class WithName
    extends INodeReference {
        private final byte[] name;
        private final int lastSnapshotId;

        public WithName(INodeDirectory parent, WithCount referred, byte[] name, int lastSnapshotId) {
            super(parent, referred);
            this.name = name;
            this.lastSnapshotId = lastSnapshotId;
            referred.addReference(this);
        }

        @Override
        public final byte[] getLocalNameBytes() {
            return this.name;
        }

        @Override
        public final void setLocalName(byte[] name) {
            throw new UnsupportedOperationException("Cannot set name: " + this.getClass() + " is immutable.");
        }

        public int getLastSnapshotId() {
            return this.lastSnapshotId;
        }

        @Override
        public final ContentSummaryComputationContext computeContentSummary(ContentSummaryComputationContext summary) {
            QuotaCounts q = new QuotaCounts.Builder().build();
            this.computeQuotaUsage(summary.getBlockStoragePolicySuite(), this.getStoragePolicyID(), q, false, this.lastSnapshotId);
            summary.getCounts().addContent(Content.DISKSPACE, q.getStorageSpace());
            summary.getCounts().addTypeSpaces(q.getTypeSpaces());
            return summary;
        }

        @Override
        public final QuotaCounts computeQuotaUsage(BlockStoragePolicySuite bsps, byte blockStoragePolicyId, QuotaCounts counts, boolean useCache, int lastSnapshotId) {
            Preconditions.checkState((lastSnapshotId == 0x7FFFFFFE || this.lastSnapshotId >= lastSnapshotId ? 1 : 0) != 0);
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int id = lastSnapshotId != 0x7FFFFFFE ? lastSnapshotId : this.lastSnapshotId;
            return referred.computeQuotaUsage(bsps, blockStoragePolicyId, counts, false, id);
        }

        @Override
        public QuotaCounts cleanSubtree(BlockStoragePolicySuite bsps, int snapshot, int prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            Preconditions.checkArgument((snapshot != 0x7FFFFFFE ? 1 : 0) != 0);
            if (prior == -1) {
                prior = WithName.getPriorSnapshot(this);
            }
            if (prior != -1 && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshot, prior) <= 0) {
                return new QuotaCounts.Builder().build();
            }
            QuotaCounts counts = this.getReferredINode().cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
            INodeReference ref = this.getReferredINode().getParentReference();
            if (ref != null) {
                try {
                    ref.addSpaceConsumed(counts.negation(), true);
                }
                catch (QuotaExceededException e) {
                    Log.getLog().warn("Should not have QuotaExceededException", new Object[0]);
                }
            }
            if (snapshot < this.lastSnapshotId) {
                counts = new QuotaCounts.Builder().build();
            }
            return counts;
        }

        @Override
        public void destroyAndCollectBlocks(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            int snapshot = this.getSelfSnapshot();
            if (INodeReference.removeReference(this) <= 0) {
                this.getReferredINode().destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            } else {
                int prior = WithName.getPriorSnapshot(this);
                INode referred = this.getReferredINode().asReference().getReferredINode();
                if (snapshot != -1) {
                    if (prior != -1 && snapshot <= prior) {
                        return;
                    }
                    try {
                        QuotaCounts counts = referred.cleanSubtree(bsps, snapshot, prior, collectedBlocks, removedINodes);
                        INodeReference ref = this.getReferredINode().getParentReference();
                        if (ref != null) {
                            ref.addSpaceConsumed(counts.negation(), true);
                        }
                    }
                    catch (QuotaExceededException e) {
                        LOG.error("should not exceed quota while snapshot deletion", (Throwable)e);
                    }
                }
            }
        }

        private int getSelfSnapshot() {
            DirectoryWithSnapshotFeature sf;
            INode referred = this.getReferredINode().asReference().getReferredINode();
            int snapshot = -1;
            if (referred.isFile() && referred.asFile().isWithSnapshot()) {
                snapshot = referred.asFile().getDiffs().getPrior(this.lastSnapshotId);
            } else if (referred.isDirectory() && (sf = referred.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                snapshot = sf.getDiffs().getPrior(this.lastSnapshotId);
            }
            return snapshot;
        }
    }

    public static class WithCount
    extends INodeReference {
        private final List<WithName> withNameList = new ArrayList<WithName>();
        public static final Comparator<WithName> WITHNAME_COMPARATOR = new Comparator<WithName>(){

            @Override
            public int compare(WithName left, WithName right) {
                return left.lastSnapshotId - right.lastSnapshotId;
            }
        };

        public WithCount(INodeReference parent, INode referred) {
            super(parent, referred);
            Preconditions.checkArgument((!referred.isReference() ? 1 : 0) != 0);
            referred.setParentReference(this);
        }

        public int getReferenceCount() {
            int count = this.withNameList.size();
            if (this.getParentReference() != null) {
                ++count;
            }
            return count;
        }

        public void addReference(INodeReference ref) {
            if (ref instanceof WithName) {
                WithName refWithName = (WithName)ref;
                int i = Collections.binarySearch(this.withNameList, refWithName, WITHNAME_COMPARATOR);
                Preconditions.checkState((i < 0 ? 1 : 0) != 0);
                this.withNameList.add(-i - 1, refWithName);
            } else if (ref instanceof DstReference) {
                this.setParentReference(ref);
            }
        }

        public void removeReference(INodeReference ref) {
            if (ref instanceof WithName) {
                int i = Collections.binarySearch(this.withNameList, (WithName)ref, WITHNAME_COMPARATOR);
                if (i >= 0) {
                    this.withNameList.remove(i);
                }
            } else if (ref == this.getParentReference()) {
                this.setParent(null);
            }
        }

        WithName getLastWithName() {
            return this.withNameList.size() > 0 ? this.withNameList.get(this.withNameList.size() - 1) : null;
        }

        WithName getPriorWithName(WithName post) {
            int i = Collections.binarySearch(this.withNameList, post, WITHNAME_COMPARATOR);
            if (i > 0) {
                return this.withNameList.get(i - 1);
            }
            if (i == 0 || i == -1) {
                return null;
            }
            return this.withNameList.get(-i - 2);
        }

        public INodeReference getParentRef(int snapshotId) {
            int start = 0;
            int end = this.withNameList.size() - 1;
            while (start < end) {
                int mid = start + (end - start) / 2;
                int sid = this.withNameList.get((int)mid).lastSnapshotId;
                if (sid == snapshotId) {
                    return this.withNameList.get(mid);
                }
                if (sid < snapshotId) {
                    start = mid + 1;
                    continue;
                }
                end = mid;
            }
            if (start < this.withNameList.size() && this.withNameList.get((int)start).lastSnapshotId >= snapshotId) {
                return this.withNameList.get(start);
            }
            return this.getParentReference();
        }
    }
}

