/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public abstract class ReplicaInfo
extends Block
implements Replica {
    private FsVolumeSpi volume;
    private File baseDir;
    private boolean hasSubdirs;
    private static final Map<String, File> internedBaseDirs = new HashMap<String, File>();

    ReplicaInfo(Block block, FsVolumeSpi vol, File dir) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir);
    }

    ReplicaInfo(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir) {
        super(blockId, len, genStamp);
        this.volume = vol;
        this.setDirInternal(dir);
    }

    ReplicaInfo(ReplicaInfo from) {
        this(from, from.getVolume(), from.getDir());
    }

    public File getBlockFile() {
        return new File(this.getDir(), this.getBlockName());
    }

    public File getMetaFile() {
        return new File(this.getDir(), DatanodeUtil.getMetaName(this.getBlockName(), this.getGenerationStamp()));
    }

    public FsVolumeSpi getVolume() {
        return this.volume;
    }

    void setVolume(FsVolumeSpi vol) {
        this.volume = vol;
    }

    @Override
    public String getStorageUuid() {
        return this.volume.getStorageID();
    }

    File getDir() {
        return this.hasSubdirs ? DatanodeUtil.idToBlockDir(this.baseDir, this.getBlockId()) : this.baseDir;
    }

    public void setDir(File dir) {
        this.setDirInternal(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirInternal(File dir) {
        if (dir == null) {
            this.baseDir = null;
            return;
        }
        ReplicaDirInfo dirInfo = ReplicaInfo.parseBaseDir(dir);
        this.hasSubdirs = dirInfo.hasSubidrs;
        Map<String, File> map = internedBaseDirs;
        synchronized (map) {
            if (!internedBaseDirs.containsKey(dirInfo.baseDirPath)) {
                File baseDir = new File(dirInfo.baseDirPath);
                internedBaseDirs.put(dirInfo.baseDirPath, baseDir);
            }
            this.baseDir = internedBaseDirs.get(dirInfo.baseDirPath);
        }
    }

    @VisibleForTesting
    public static ReplicaDirInfo parseBaseDir(File dir) {
        File currentDir = dir;
        boolean hasSubdirs = false;
        while (currentDir.getName().startsWith("subdir")) {
            hasSubdirs = true;
            currentDir = currentDir.getParentFile();
        }
        return new ReplicaDirInfo(currentDir.getAbsolutePath(), hasSubdirs);
    }

    public boolean isUnlinked() {
        return true;
    }

    public void setUnlinked() {
    }

    public long getBytesReserved() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlinkFile(File file, Block b) throws IOException {
        File tmpFile = DatanodeUtil.createTmpFile(b, DatanodeUtil.getUnlinkTmpFile(file));
        try {
            try (FileInputStream in = new FileInputStream(file);
                 FileOutputStream out = new FileOutputStream(tmpFile);){
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)16384);
            }
            if (file.length() != tmpFile.length()) {
                throw new IOException("Copy of file " + file + " size " + file.length() + " into file " + tmpFile + " resulted in a size of " + tmpFile.length());
            }
            FileUtil.replaceFile((File)tmpFile, (File)file);
        }
        catch (IOException e) {
            boolean done = tmpFile.delete();
            if (!done) {
                DataNode.LOG.info("detachFile failed to delete temporary file " + tmpFile);
            }
            throw e;
        }
    }

    public boolean unlinkBlock(int numLinks) throws IOException {
        if (this.isUnlinked()) {
            return false;
        }
        File file = this.getBlockFile();
        if (file == null || this.getVolume() == null) {
            throw new IOException("detachBlock:Block not found. " + this);
        }
        File meta = this.getMetaFile();
        if (HardLink.getLinkCount((File)file) > numLinks) {
            DataNode.LOG.info("CopyOnWrite for block " + this);
            this.unlinkFile(file, this);
        }
        if (HardLink.getLinkCount((File)meta) > numLinks) {
            this.unlinkFile(meta, this);
        }
        this.setUnlinked();
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ", " + super.toString() + ", " + this.getState() + "\n  getNumBytes()     = " + this.getNumBytes() + "\n  getBytesOnDisk()  = " + this.getBytesOnDisk() + "\n  getVisibleLength()= " + this.getVisibleLength() + "\n  getVolume()       = " + this.getVolume() + "\n  getBlockFile()    = " + this.getBlockFile();
    }

    @Override
    public boolean isOnTransientStorage() {
        return this.volume.isTransientStorage();
    }

    @VisibleForTesting
    public static class ReplicaDirInfo {
        public String baseDirPath;
        public boolean hasSubidrs;

        public ReplicaDirInfo(String baseDirPath, boolean hasSubidrs) {
            this.baseDirPath = baseDirPath;
            this.hasSubidrs = hasSubidrs;
        }
    }
}

