/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockMetadataHeader {
    private static final Logger LOG = LoggerFactory.getLogger(BlockMetadataHeader.class);
    public static final short VERSION = 1;
    private final short version;
    private DataChecksum checksum = null;

    @VisibleForTesting
    public BlockMetadataHeader(short version, DataChecksum checksum) {
        this.checksum = checksum;
        this.version = version;
    }

    public short getVersion() {
        return this.version;
    }

    public DataChecksum getChecksum() {
        return this.checksum;
    }

    public static DataChecksum readDataChecksum(File metaFile) throws IOException {
        DataChecksum dataChecksum;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(metaFile), HdfsConstants.IO_FILE_BUFFER_SIZE));
            dataChecksum = BlockMetadataHeader.readDataChecksum(in, metaFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
        return dataChecksum;
    }

    public static DataChecksum readDataChecksum(DataInputStream metaIn, Object name) throws IOException {
        BlockMetadataHeader header = BlockMetadataHeader.readHeader(metaIn);
        if (header.getVersion() != 1) {
            LOG.warn("Unexpected meta-file version for " + name + ": version in file is " + header.getVersion() + " but expected version is 1");
        }
        return header.getChecksum();
    }

    public static BlockMetadataHeader preadHeader(FileChannel fc) throws IOException {
        byte[] arr = new byte[BlockMetadataHeader.getHeaderSize()];
        ByteBuffer buf = ByteBuffer.wrap(arr);
        while (buf.hasRemaining()) {
            if (fc.read(buf, 0L) > 0) continue;
            throw new EOFException("unexpected EOF while reading metadata file header");
        }
        short version = (short)(arr[0] << 8 | arr[1] & 0xFF);
        DataChecksum dataChecksum = DataChecksum.newDataChecksum((byte[])arr, (int)2);
        return new BlockMetadataHeader(version, dataChecksum);
    }

    public static BlockMetadataHeader readHeader(DataInputStream in) throws IOException {
        return BlockMetadataHeader.readHeader(in.readShort(), in);
    }

    public static BlockMetadataHeader readHeader(File file) throws IOException {
        BlockMetadataHeader blockMetadataHeader;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            blockMetadataHeader = BlockMetadataHeader.readHeader(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
        return blockMetadataHeader;
    }

    public static BlockMetadataHeader readHeader(RandomAccessFile raf) throws IOException {
        byte[] buf = new byte[BlockMetadataHeader.getHeaderSize()];
        raf.seek(0L);
        raf.readFully(buf, 0, buf.length);
        return BlockMetadataHeader.readHeader(new DataInputStream(new ByteArrayInputStream(buf)));
    }

    private static BlockMetadataHeader readHeader(short version, DataInputStream in) throws IOException {
        DataChecksum checksum = DataChecksum.newDataChecksum((DataInputStream)in);
        return new BlockMetadataHeader(version, checksum);
    }

    @VisibleForTesting
    public static void writeHeader(DataOutputStream out, BlockMetadataHeader header) throws IOException {
        out.writeShort(header.getVersion());
        header.getChecksum().writeHeader(out);
    }

    public static void writeHeader(DataOutputStream out, DataChecksum checksum) throws IOException {
        BlockMetadataHeader.writeHeader(out, new BlockMetadataHeader(1, checksum));
    }

    public static int getHeaderSize() {
        return 2 + DataChecksum.getChecksumHeaderSize();
    }
}

