/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.TraceScope;

@InterfaceAudience.Private
public class DFSOutputStream
extends FSOutputSummer
implements Syncable,
CanSetDropBehind,
StreamCapabilities {
    @VisibleForTesting
    static final int CREATE_RETRY_COUNT = 10;
    @VisibleForTesting
    static CryptoProtocolVersion[] SUPPORTED_CRYPTO_VERSIONS = CryptoProtocolVersion.supported();
    private final DFSClient dfsClient;
    private final ByteArrayManager byteArrayManager;
    private volatile boolean closed = false;
    private final String src;
    private final long fileId;
    private final long blockSize;
    private final int bytesPerChecksum;
    private DFSPacket currentPacket = null;
    private DataStreamer streamer;
    private int packetSize = 0;
    private int chunksPerPacket = 0;
    private long lastFlushOffset = 0L;
    private long initialFileSize = 0L;
    private final short blockReplication;
    private boolean shouldSyncBlock = false;
    private final AtomicReference<CachingStrategy> cachingStrategy;
    private FileEncryptionInfo fileEncryptionInfo;

    private DFSPacket createPacket(int packetSize, int chunksPerPkt, long offsetInBlock, long seqno, boolean lastPacketInBlock) throws InterruptedIOException {
        byte[] buf;
        int bufferSize = PacketHeader.PKT_MAX_HEADER_LEN + packetSize;
        try {
            buf = this.byteArrayManager.newByteArray(bufferSize);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException("seqno=" + seqno);
            iioe.initCause(ie);
            throw iioe;
        }
        return new DFSPacket(buf, chunksPerPkt, offsetInBlock, seqno, this.getChecksumSize(), lastPacketInBlock);
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed()) {
            IOException e = this.streamer.getLastException().get();
            throw e != null ? e : new ClosedChannelException();
        }
    }

    @VisibleForTesting
    public synchronized DatanodeInfo[] getPipeline() {
        if (this.streamer.streamerClosed()) {
            return null;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return null;
        }
        DatanodeInfo[] value = new DatanodeInfo[currentNodes.length];
        for (int i = 0; i < currentNodes.length; ++i) {
            value[i] = currentNodes[i];
        }
        return value;
    }

    private static DataChecksum getChecksum4Compute(DataChecksum checksum, HdfsFileStatus stat) {
        if (DataStreamer.isLazyPersist(stat) && stat.getReplication() == 1) {
            return DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)checksum.getBytesPerChecksum());
        }
        return checksum;
    }

    private DFSOutputStream(DFSClient dfsClient, String src, Progressable progress, HdfsFileStatus stat, DataChecksum checksum) throws IOException {
        super(DFSOutputStream.getChecksum4Compute(checksum, stat));
        this.dfsClient = dfsClient;
        this.src = src;
        this.fileId = stat.getFileId();
        this.blockSize = stat.getBlockSize();
        this.blockReplication = stat.getReplication();
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
        this.cachingStrategy = new AtomicReference<CachingStrategy>(dfsClient.getDefaultWriteCachingStrategy());
        if (progress != null && DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug("Set non-null progress callback on DFSOutputStream " + src);
        }
        this.bytesPerChecksum = checksum.getBytesPerChecksum();
        if (this.bytesPerChecksum <= 0) {
            throw new HadoopIllegalArgumentException("Invalid value: bytesPerChecksum = " + this.bytesPerChecksum + " <= 0");
        }
        if (this.blockSize % (long)this.bytesPerChecksum != 0L) {
            throw new HadoopIllegalArgumentException("Invalid values: dfs.bytes-per-checksum (=" + this.bytesPerChecksum + ") must divide block size (=" + this.blockSize + ").");
        }
        this.byteArrayManager = dfsClient.getClientContext().getByteArrayManager();
    }

    private DFSOutputStream(DFSClient dfsClient, String src, HdfsFileStatus stat, EnumSet<CreateFlag> flag, Progressable progress, DataChecksum checksum, String[] favoredNodes) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.shouldSyncBlock = flag.contains(CreateFlag.SYNC_BLOCK);
        this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), this.bytesPerChecksum);
        this.streamer = new DataStreamer(stat, null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager);
        if (favoredNodes != null && favoredNodes.length != 0) {
            this.streamer.setFavoredNodes(favoredNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForCreate(DFSClient dfsClient, String src, FsPermission masked, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, DataChecksum checksum, String[] favoredNodes) throws IOException {
        try (TraceScope scope = dfsClient.newPathTraceScope("newStreamForCreate", src);){
            HdfsFileStatus stat = null;
            boolean shouldRetry = true;
            int retryCount = 10;
            while (shouldRetry) {
                shouldRetry = false;
                try {
                    stat = dfsClient.namenode.create(src, masked, dfsClient.clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(flag), createParent, replication, blockSize, SUPPORTED_CRYPTO_VERSIONS);
                    break;
                }
                catch (RemoteException re) {
                    IOException e = re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, RetryStartFileException.class, SafeModeException.class, UnresolvedPathException.class, SnapshotAccessControlException.class, UnknownCryptoProtocolVersionException.class});
                    if (e instanceof RetryStartFileException) {
                        if (retryCount > 0) {
                            shouldRetry = true;
                            --retryCount;
                            continue;
                        }
                        throw new IOException("Too many retries because of encryption zone operations", e);
                    }
                    throw e;
                }
            }
            Preconditions.checkNotNull(stat, (Object)"HdfsFileStatus should not be null!");
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, stat, flag, progress, checksum, favoredNodes);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private DFSOutputStream(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.initialFileSize = stat.getLen();
        boolean toNewBlock = flags.contains(CreateFlag.NEW_BLOCK);
        if (!toNewBlock && lastBlock != null) {
            this.streamer = new DataStreamer(lastBlock, stat, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager);
            this.streamer.setBytesCurBlock(lastBlock.getBlockSize());
            this.adjustPacketChunkSize(stat);
            this.streamer.setPipelineInConstruction(lastBlock);
        } else {
            this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), this.bytesPerChecksum);
            this.streamer = new DataStreamer(stat, lastBlock != null ? lastBlock.getBlock() : null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager);
        }
    }

    private void adjustPacketChunkSize(HdfsFileStatus stat) throws IOException {
        long usedInLastBlock = stat.getLen() % this.blockSize;
        int freeInLastBlock = (int)(this.blockSize - usedInLastBlock);
        int usedInCksum = (int)(stat.getLen() % (long)this.bytesPerChecksum);
        int freeInCksum = this.bytesPerChecksum - usedInCksum;
        if ((long)freeInLastBlock == this.blockSize) {
            throw new IOException("The last block for file " + this.src + " is full.");
        }
        if (usedInCksum > 0 && freeInCksum > 0) {
            this.computePacketChunkSize(0, freeInCksum);
            this.setChecksumBufSize(freeInCksum);
            this.streamer.setAppendChunk(true);
        } else {
            this.computePacketChunkSize(Math.min(this.dfsClient.getConf().getWritePacketSize(), freeInLastBlock), this.bytesPerChecksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForAppend(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, int bufferSize, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, String[] favoredNodes) throws IOException {
        try (TraceScope scope = dfsClient.newPathTraceScope("newStreamForAppend", src);){
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, flags, progress, lastBlock, stat, checksum);
            if (favoredNodes != null && favoredNodes.length != 0) {
                out.streamer.setFavoredNodes(favoredNodes);
            }
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private void computePacketChunkSize(int psize, int csize) {
        int bodySize = psize - PacketHeader.PKT_MAX_HEADER_LEN;
        int chunkSize = csize + this.getChecksumSize();
        this.chunksPerPacket = Math.max(bodySize / chunkSize, 1);
        this.packetSize = chunkSize * this.chunksPerPacket;
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug("computePacketChunkSize: src=" + this.src + ", chunkSize=" + chunkSize + ", chunksPerPacket=" + this.chunksPerPacket + ", packetSize=" + this.packetSize);
        }
    }

    protected TraceScope createWriteTraceScope() {
        return this.dfsClient.newPathTraceScope("DFSOutputStream#write", this.src);
    }

    protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (len > this.bytesPerChecksum) {
            throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + this.bytesPerChecksum);
        }
        if (cklen != 0 && cklen != this.getChecksumSize()) {
            throw new IOException("writeChunk() checksum size is supposed to be " + this.getChecksumSize() + " but found to be " + cklen);
        }
        if (this.currentPacket == null) {
            this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug("DFSClient writeChunk allocating new packet seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", packetSize=" + this.packetSize + ", chunksPerPacket=" + this.chunksPerPacket + ", bytesCurBlock=" + this.streamer.getBytesCurBlock());
            }
        }
        this.currentPacket.writeChecksum(checksum, ckoff, cklen);
        this.currentPacket.writeData(b, offset, len);
        this.currentPacket.incNumChunks();
        this.streamer.incBytesCurBlock(len);
        if (this.currentPacket.getNumChunks() == this.currentPacket.getMaxChunks() || this.streamer.getBytesCurBlock() == this.blockSize) {
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug("DFSClient writeChunk packet full seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", bytesCurBlock=" + this.streamer.getBytesCurBlock() + ", blockSize=" + this.blockSize + ", appendChunk=" + this.streamer.getAppendChunk());
            }
            this.streamer.waitAndQueuePacket(this.currentPacket);
            this.currentPacket = null;
            if (this.streamer.getAppendChunk() && this.streamer.getBytesCurBlock() % (long)this.bytesPerChecksum == 0L) {
                this.streamer.setAppendChunk(false);
                this.resetChecksumBufSize();
            }
            if (!this.streamer.getAppendChunk()) {
                int psize = Math.min((int)(this.blockSize - this.streamer.getBytesCurBlock()), this.dfsClient.getConf().getWritePacketSize());
                this.computePacketChunkSize(psize, this.bytesPerChecksum);
            }
            if (this.streamer.getBytesCurBlock() == this.blockSize) {
                this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
                this.currentPacket.setSyncBlock(this.shouldSyncBlock);
                this.streamer.waitAndQueuePacket(this.currentPacket);
                this.currentPacket = null;
                this.streamer.setBytesCurBlock(0L);
                this.lastFlushOffset = 0L;
            }
        }
    }

    @Deprecated
    public void sync() throws IOException {
        this.hflush();
    }

    public void hflush() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hflush", this.src);){
            this.flushOrSync(false, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync(EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, syncFlags);
        }
    }

    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase((String)capability)) {
            case "hsync": 
            case "hflush": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOrSync(boolean isSync, EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        try {
            long toWaitFor;
            long lastBlockLength = -1L;
            boolean updateLength = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH);
            boolean endBlock = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.END_BLOCK);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                int numKept = this.flushBuffer(!endBlock, true);
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug("DFSClient flush(): bytesCurBlock=" + this.streamer.getBytesCurBlock() + " lastFlushOffset=" + this.lastFlushOffset + " createNewBlock=" + endBlock);
                }
                if (this.lastFlushOffset != this.streamer.getBytesCurBlock()) {
                    assert (this.streamer.getBytesCurBlock() > this.lastFlushOffset);
                    this.lastFlushOffset = this.streamer.getBytesCurBlock();
                    if (isSync && this.currentPacket == null && !endBlock) {
                        this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
                    }
                } else if (isSync && this.streamer.getBytesCurBlock() > 0L && !endBlock) {
                    this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
                } else if (this.currentPacket != null) {
                    this.currentPacket.releaseBuffer(this.byteArrayManager);
                    this.currentPacket = null;
                }
                if (this.currentPacket != null) {
                    this.currentPacket.setSyncBlock(isSync);
                    this.streamer.waitAndQueuePacket(this.currentPacket);
                    this.currentPacket = null;
                }
                if (endBlock && this.streamer.getBytesCurBlock() > 0L) {
                    this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
                    this.currentPacket.setSyncBlock(this.shouldSyncBlock || isSync);
                    this.streamer.waitAndQueuePacket(this.currentPacket);
                    this.currentPacket = null;
                    this.streamer.setBytesCurBlock(0L);
                    this.lastFlushOffset = 0L;
                } else {
                    this.streamer.setBytesCurBlock(this.streamer.getBytesCurBlock() - (long)numKept);
                }
                toWaitFor = this.streamer.getLastQueuedSeqno();
            }
            this.streamer.waitForAckedSeqno(toWaitFor);
            if (updateLength || this.streamer.getPersistBlocks().get()) {
                dFSOutputStream = this;
                synchronized (dFSOutputStream) {
                    if (!this.streamer.streamerClosed() && this.streamer.getBlock() != null) {
                        lastBlockLength = this.streamer.getBlock().getNumBytes();
                    }
                }
            }
            if (this.streamer.getPersistBlocks().getAndSet(false) || updateLength) {
                try {
                    this.dfsClient.namenode.fsync(this.src, this.fileId, this.dfsClient.clientName, lastBlockLength);
                }
                catch (IOException ioe) {
                    DFSClient.LOG.warn("Unable to persist blocks in hflush for " + this.src, (Throwable)ioe);
                    this.checkClosed();
                    throw ioe;
                }
            }
            dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.streamer.streamerClosed()) {
                    this.streamer.setHflush();
                }
            }
        }
        catch (InterruptedIOException interrupt) {
            throw interrupt;
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Error while syncing", (Throwable)e);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.isClosed()) {
                    this.streamer.getLastException().set(new IOException("IOException flush: " + e));
                    this.closeThreads(true);
                }
            }
            throw e;
        }
    }

    @Deprecated
    public synchronized int getNumCurrentReplicas() throws IOException {
        return this.getCurrentBlockReplication();
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (this.streamer.streamerClosed()) {
            return this.blockReplication;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return this.blockReplication;
        }
        return currentNodes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal() throws IOException {
        long toWaitFor;
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            this.dfsClient.checkOpen();
            this.checkClosed();
            this.streamer.queuePacket(this.currentPacket);
            this.currentPacket = null;
            toWaitFor = this.streamer.getLastQueuedSeqno();
        }
        this.streamer.waitForAckedSeqno(toWaitFor);
    }

    private synchronized void start() {
        this.streamer.start();
    }

    synchronized void abort() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.streamer.setLastException(new IOException("Lease timeout of " + this.dfsClient.getConf().getHdfsTimeout() / 1000 + " seconds expired."));
        this.closeThreads(true);
        this.dfsClient.endFileLease(this.fileId);
    }

    boolean isClosed() {
        return this.closed || this.streamer.streamerClosed();
    }

    void setClosed() {
        this.closed = true;
        this.streamer.release();
    }

    private void closeThreads(boolean force) throws IOException {
        try {
            this.streamer.close(force);
            this.streamer.join();
            this.streamer.closeSocket();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to shutdown streamer");
        }
        finally {
            this.streamer.setSocketToNull();
            this.setClosed();
        }
    }

    public synchronized void close() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("DFSOutputStream#close", this.src);){
            this.closeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeImpl() throws IOException {
        if (this.isClosed()) {
            IOException e = this.streamer.getLastException().getAndSet(null);
            if (e == null) {
                return;
            }
            throw e;
        }
        try {
            this.flushBuffer();
            if (this.currentPacket != null) {
                this.streamer.waitAndQueuePacket(this.currentPacket);
                this.currentPacket = null;
            }
            if (this.streamer.getBytesCurBlock() != 0L) {
                this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
                this.currentPacket.setSyncBlock(this.shouldSyncBlock);
            }
            this.flushInternal();
            ExtendedBlock lastBlock = this.streamer.getBlock();
            this.closeThreads(false);
            try (TraceScope scope = this.dfsClient.getTracer().newScope("completeFile");){
                this.completeFile(lastBlock);
            }
            this.dfsClient.endFileLease(this.fileId);
        }
        catch (ClosedChannelException closedChannelException) {
        }
        finally {
            this.setClosed();
        }
    }

    private void completeFile(ExtendedBlock last) throws IOException {
        long localstart = Time.monotonicNow();
        DfsClientConf conf = this.dfsClient.getConf();
        long localTimeout = 400L;
        boolean fileComplete = false;
        int retries = conf.getNumBlockWriteLocateFollowingRetry();
        while (!fileComplete) {
            fileComplete = this.dfsClient.namenode.complete(this.src, this.dfsClient.clientName, last, this.fileId);
            if (fileComplete) continue;
            int hdfsTimeout = conf.getHdfsTimeout();
            if (!this.dfsClient.clientRunning || hdfsTimeout > 0 && localstart + (long)hdfsTimeout < Time.monotonicNow()) {
                String msg = "Unable to close file because dfsclient  was unable to contact the HDFS servers. clientRunning " + this.dfsClient.clientRunning + " hdfsTimeout " + hdfsTimeout;
                DFSClient.LOG.info(msg);
                throw new IOException(msg);
            }
            try {
                if (retries == 0) {
                    throw new IOException("Unable to close file because the last block does not have enough number of replicas.");
                }
                --retries;
                Thread.sleep(localTimeout);
                localTimeout *= 2L;
                if (Time.monotonicNow() - localstart <= 5000L) continue;
                DFSClient.LOG.info("Could not complete " + this.src + " retrying...");
            }
            catch (InterruptedException ie) {
                DFSClient.LOG.warn("Caught exception ", (Throwable)ie);
            }
        }
    }

    @VisibleForTesting
    public void setArtificialSlowdown(long period) {
        this.streamer.setArtificialSlowdown(period);
    }

    @VisibleForTesting
    public synchronized void setChunksPerPacket(int value) {
        this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
        this.packetSize = (this.bytesPerChecksum + this.getChecksumSize()) * this.chunksPerPacket;
    }

    public long getInitialLen() {
        return this.initialFileSize;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.fileEncryptionInfo;
    }

    synchronized Token<BlockTokenIdentifier> getBlockToken() {
        return this.streamer.getBlockToken();
    }

    public void setDropBehind(Boolean dropBehind) throws IOException {
        CachingStrategy nextStrategy;
        CachingStrategy prevStrategy;
        while (!this.cachingStrategy.compareAndSet(prevStrategy = this.cachingStrategy.get(), nextStrategy = new CachingStrategy.Builder(prevStrategy).setDropBehind(dropBehind).build())) {
        }
    }

    @VisibleForTesting
    ExtendedBlock getBlock() {
        return this.streamer.getBlock();
    }

    @VisibleForTesting
    public long getFileId() {
        return this.fileId;
    }
}

