/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.StringUtils;

public class TeraInputFormatWithCRC
extends FileInputFormat<Text, Text> {
    static final String PARTITION_FILENAME = "_partition.lst";
    static final String SAMPLE_SIZE = "terasort.partitions.sample";
    private static MRJobConfig lastContext = null;
    private static List<InputSplit> lastResult = null;

    public static void writePartitionFile(JobContext job, Path partFile) throws IOException {
        TeraInputFormatWithCRC inFormat = new TeraInputFormatWithCRC();
        TextSampler sampler = new TextSampler();
        Configuration conf = job.getConfiguration();
        int partitions = job.getNumReduceTasks();
        long sampleSize = conf.getLong(SAMPLE_SIZE, 100000L);
        List<InputSplit> splits = inFormat.getSplits(job);
        int samples = Math.min(10, splits.size());
        long recordsPerSample = sampleSize / (long)samples;
        int sampleStep = splits.size() / samples;
        long records = 0L;
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
        block3: for (int i = 0; i < samples; ++i) {
            try {
                RecordReader<Text, Text> reader = inFormat.createRecordReader(splits.get(sampleStep * i), (TaskAttemptContext)context);
                reader.initialize(splits.get(sampleStep * i), (TaskAttemptContext)context);
                while (reader.nextKeyValue()) {
                    if (((Text)reader.getCurrentKey()).getLength() <= 0) continue;
                    sampler.addKey(new Text((Text)reader.getCurrentKey()));
                    if ((long)(i + 1) * recordsPerSample > ++records) continue;
                    continue block3;
                }
                continue;
            }
            catch (IOException ie) {
                System.err.println("Got an exception while reading splits " + StringUtils.stringifyException((Throwable)ie));
                throw new RuntimeException(ie);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        FileSystem outFs = partFile.getFileSystem(conf);
        if (outFs.exists(partFile)) {
            outFs.delete(partFile, false);
        }
        FSDataOutputStream writer = outFs.create(partFile, true, 65536, (short)10, outFs.getDefaultBlockSize(partFile));
        for (Text split : sampler.createPartitions(partitions)) {
            split.write((DataOutput)writer);
        }
        writer.close();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        if (job == lastContext) {
            return lastResult;
        }
        lastContext = job;
        lastResult = super.getSplits(job);
        return lastResult;
    }

    public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new TeraRecordReader();
    }

    static class TeraRecordReader
    extends RecordReader<Text, Text> {
        private static int KEY_LENGTH = 10;
        static final int VALUE_LENGTH = 90;
        private static int CRC_LENGTH = 20;
        private Text key;
        private Text value;
        private FSDataInputStream in;
        private long offset;
        private long length;
        private static final int RECORD_LENGTH = KEY_LENGTH + 90 + CRC_LENGTH;
        private byte[] buffer = new byte[RECORD_LENGTH];

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Path p = ((FileSplit)split).getPath();
            FileSystem fs = p.getFileSystem(context.getConfiguration());
            this.in = fs.open(p);
            long start = ((FileSplit)split).getStart();
            this.offset = ((long)RECORD_LENGTH - start % (long)RECORD_LENGTH) % (long)RECORD_LENGTH;
            this.in.seek(start + this.offset);
            this.length = ((FileSplit)split).getLength();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public float getProgress() throws IOException {
            return (float)this.offset / (float)this.length;
        }

        public Text getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public Text getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.offset >= this.length) {
                return false;
            }
            int read = 0;
            while (read < RECORD_LENGTH) {
                long newRead = this.in.read(this.buffer, read, RECORD_LENGTH - read);
                if (newRead == -1L) {
                    if (read == 0) {
                        return false;
                    }
                    throw new EOFException("read past eof");
                }
                read = (int)((long)read + newRead);
            }
            if (this.buffer.length < KEY_LENGTH) {
                try {
                    throw new Exception("The length of the line is less than key length " + this.buffer.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (this.key == null) {
                    this.key = new Text();
                }
                if (this.value == null) {
                    this.value = new Text();
                }
                int actual_value_length = this.buffer.length - KEY_LENGTH - CRC_LENGTH;
                this.key.set(this.buffer, 0, KEY_LENGTH);
                this.value.set(this.buffer, KEY_LENGTH, actual_value_length);
                Long start_cksum = System.currentTimeMillis();
                CRC32 checksum = new CRC32();
                checksum.update(this.key.getBytes(), 0, this.key.getLength());
                checksum.update(this.value.getBytes(), 0, this.value.getLength());
                Long end_cksum = System.currentTimeMillis();
                String cksum_bytes = new String(this.buffer, KEY_LENGTH + actual_value_length, CRC_LENGTH).trim();
                long stored_cksum = Long.parseLong(cksum_bytes);
                long computed_cksum = checksum.getValue();
                String computed_cksum_str = Long.toString(computed_cksum);
                String rowid_str = new String(this.buffer, KEY_LENGTH + 2, 32).trim();
                long rowid = Long.parseLong(rowid_str, 16);
                if (!computed_cksum_str.equals(cksum_bytes)) {
                    try {
                        throw new Exception("CHECKSUM MISMATCH at row " + rowid + ": computed " + computed_cksum + " stored " + stored_cksum);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            this.offset += (long)RECORD_LENGTH;
            return true;
        }
    }

    static class TextSampler
    implements IndexedSortable {
        private ArrayList<Text> records = new ArrayList();

        TextSampler() {
        }

        public int compare(int i, int j) {
            Text left = this.records.get(i);
            Text right = this.records.get(j);
            return left.compareTo((BinaryComparable)right);
        }

        public void swap(int i, int j) {
            Text left = this.records.get(i);
            Text right = this.records.get(j);
            this.records.set(j, left);
            this.records.set(i, right);
        }

        public void addKey(Text key) {
            this.records.add(new Text(key));
        }

        Text[] createPartitions(int numPartitions) {
            int numRecords = this.records.size();
            System.out.println("Making " + numPartitions + " from " + numRecords + " records");
            if (numPartitions > numRecords) {
                throw new IllegalArgumentException("Requested more partitions than input keys (" + numPartitions + " > " + numRecords + ")");
            }
            new QuickSort().sort((IndexedSortable)this, 0, this.records.size());
            float stepSize = (float)numRecords / (float)numPartitions;
            System.out.println("Step size is " + stepSize);
            Text[] result = new Text[numPartitions - 1];
            for (int i = 1; i < numPartitions; ++i) {
                result[i - 1] = this.records.get(Math.round(stepSize * (float)i));
            }
            return result;
        }
    }
}

