/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import org.apache.hadoop.examples.pi.Util;

public class ArithmeticProgression
implements Comparable<ArithmeticProgression> {
    public final char symbol;
    public final long value;
    public final long delta;
    public final long limit;

    public ArithmeticProgression(char symbol, long value, long delta, long limit) {
        if (delta == 0L) {
            throw new IllegalArgumentException("delta == 0");
        }
        this.symbol = symbol;
        this.value = value;
        this.delta = delta;
        this.limit = limit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ArithmeticProgression) {
            ArithmeticProgression that = (ArithmeticProgression)obj;
            if (this.symbol != that.symbol) {
                throw new IllegalArgumentException("this.symbol != that.symbol, this=" + this + ", that=" + that);
            }
            return this.value == that.value && this.delta == that.delta && this.limit == that.limit;
        }
        throw new IllegalArgumentException((String)(obj == null ? "obj == null" : "obj.getClass()=" + obj.getClass()));
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(ArithmeticProgression that) {
        if (this.symbol != that.symbol) {
            throw new IllegalArgumentException("this.symbol != that.symbol, this=" + this + ", that=" + that);
        }
        if (this.delta != that.delta) {
            throw new IllegalArgumentException("this.delta != that.delta, this=" + this + ", that=" + that);
        }
        long d = this.limit - that.limit;
        return d > 0L ? 1 : (d == 0L ? 0 : -1);
    }

    boolean contains(ArithmeticProgression that) {
        if (this.symbol != that.symbol) {
            throw new IllegalArgumentException("this.symbol != that.symbol, this=" + this + ", that=" + that);
        }
        if (this.delta == that.delta) {
            if (this.value == that.value) {
                return this.getSteps() >= that.getSteps();
            }
            if (this.delta < 0L) {
                return this.value > that.value && this.limit <= that.limit;
            }
            if (this.delta > 0L) {
                return this.value < that.value && this.limit >= that.limit;
            }
        }
        return false;
    }

    long skip(long steps) {
        if (steps < 0L) {
            throw new IllegalArgumentException("steps < 0, steps=" + steps);
        }
        return this.value + steps * this.delta;
    }

    public long getSteps() {
        return (this.limit - this.value) / this.delta;
    }

    public String toString() {
        return this.symbol + ":value=" + this.value + ",delta=" + this.delta + ",limit=" + this.limit;
    }

    static ArithmeticProgression valueOf(String s) {
        int i = 2;
        int j = s.indexOf(",delta=");
        long value = Util.parseLongVariable("value", s.substring(2, j));
        i = j + 1;
        j = s.indexOf(",limit=");
        long delta = Util.parseLongVariable("delta", s.substring(i, j));
        i = j + 1;
        long limit = Util.parseLongVariable("limit", s.substring(i));
        return new ArithmeticProgression(s.charAt(0), value, delta, limit);
    }
}

