/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.pi.Container;
import org.apache.hadoop.examples.pi.math.ArithmeticProgression;
import org.apache.hadoop.examples.pi.math.Summation;
import org.apache.hadoop.io.WritableComparable;

public final class SummationWritable
implements WritableComparable<SummationWritable>,
Container<Summation> {
    private Summation sigma;

    public SummationWritable() {
    }

    SummationWritable(Summation sigma) {
        this.sigma = sigma;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.sigma;
    }

    @Override
    public Summation getElement() {
        return this.sigma;
    }

    public static Summation read(Class<?> clazz, Configuration conf) {
        return Summation.valueOf(conf.get(clazz.getSimpleName() + ".sigma"));
    }

    public static void write(Summation sigma, Class<?> clazz, Configuration conf) {
        conf.set(clazz.getSimpleName() + ".sigma", sigma.toString());
    }

    static Summation read(DataInput in) throws IOException {
        SummationWritable s = new SummationWritable();
        s.readFields(in);
        return s.getElement();
    }

    public void readFields(DataInput in) throws IOException {
        ArithmeticProgression N = ArithmeticProgressionWritable.read(in);
        ArithmeticProgression E = ArithmeticProgressionWritable.read(in);
        this.sigma = new Summation(N, E);
        if (in.readBoolean()) {
            this.sigma.setValue(in.readDouble());
        }
    }

    public static void write(Summation sigma, DataOutput out) throws IOException {
        ArithmeticProgressionWritable.write(sigma.N, out);
        ArithmeticProgressionWritable.write(sigma.E, out);
        Double v = sigma.getValue();
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDouble(v);
        }
    }

    public void write(DataOutput out) throws IOException {
        SummationWritable.write(this.sigma, out);
    }

    public int compareTo(SummationWritable that) {
        return this.sigma.compareTo(that.sigma);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof SummationWritable) {
            SummationWritable that = (SummationWritable)obj;
            return this.compareTo(that) == 0;
        }
        throw new IllegalArgumentException((String)(obj == null ? "obj == null" : "obj.getClass()=" + obj.getClass()));
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private static class ArithmeticProgressionWritable {
        private ArithmeticProgressionWritable() {
        }

        private static ArithmeticProgression read(DataInput in) throws IOException {
            return new ArithmeticProgression(in.readChar(), in.readLong(), in.readLong(), in.readLong());
        }

        private static void write(ArithmeticProgression ap, DataOutput out) throws IOException {
            out.writeChar(ap.symbol);
            out.writeLong(ap.value);
            out.writeLong(ap.delta);
            out.writeLong(ap.limit);
        }
    }
}

