/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.blocklocality;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class LocalityInputFormat
extends FileInputFormat<Text, Text> {
    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new LocalityRecordReader((FileSplit)split, (Configuration)job);
    }

    static class LocalityRecordReader
    implements RecordReader<Text, Text> {
        private FileSplit fileSplit;
        private Configuration conf;
        private FileSystem fs;
        private FSDataInputStream in;
        private boolean processed = false;
        private FileStatus fstatus;
        private Path file;

        public LocalityRecordReader(FileSplit fileSplit, Configuration conf) throws IOException {
            this.fileSplit = fileSplit;
            long offset = fileSplit.getStart();
            this.conf = conf;
            this.file = fileSplit.getPath();
            this.fs = this.file.getFileSystem(conf);
            this.in = this.fs.open(this.file);
            this.in.seek(offset);
            System.out.println("fileSplit offset = " + offset);
            System.out.println("Current position after seek to offset = " + this.in.getPos());
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Text createKey() {
            return new Text();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return this.in.getPos();
        }

        public float getProgress() throws IOException {
            return this.processed ? 1.0f : 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean next(Text key, Text value) throws IOException {
            if (this.processed) {
                return false;
            }
            char[] data = new char[2000];
            try {
                while (this.in.readChar() != '<') {
                }
                this.fstatus = this.fs.getFileStatus(this.file);
                BlockLocation[] bloc = this.fs.getFileBlockLocations(this.fstatus, this.in.getPos(), this.in.getPos() + 10L);
                if (bloc == null) {
                    System.out.println("null ********");
                    System.exit(-1);
                }
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < bloc.length; ++j) {
                    String[] hostnames = bloc[j].getHosts();
                    for (int k = 0; k < hostnames.length; ++k) {
                        sb.append(hostnames[k]);
                        sb.append(";");
                    }
                }
                System.out.println("Starting position is " + this.in.getPos());
                key.set("1");
                value.set(sb.toString());
            }
            finally {
                this.processed = true;
                return true;
            }
        }
    }
}

