/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import com.google.common.base.Supplier;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.event.Level;

public class TestGenericTestUtils
extends GenericTestUtils {
    @Test
    public void testAssertExceptionContainsNullEx() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", null);
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains(E_NULL_THROWABLE)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsNullString() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", new BrokenException());
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains(E_NULL_THROWABLE_STRING)) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWrongText() throws Throwable {
        block3: {
            try {
                TestGenericTestUtils.assertExceptionContains("Expected", new Exception("(actual)"));
            }
            catch (AssertionError e) {
                String s = ((Throwable)((Object)e)).toString();
                if (!s.contains(E_UNEXPECTED_EXCEPTION) || !s.contains("(actual)")) {
                    throw e;
                }
                if (((Throwable)((Object)e)).getCause() != null) break block3;
                throw new AssertionError("No nested cause in assertion", (Throwable)((Object)e));
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWorking() throws Throwable {
        TestGenericTestUtils.assertExceptionContains("Expected", new Exception("Expected"));
    }

    @Test
    public void testWaitingForConditionWithInvalidParams() throws Throwable {
        try {
            TestGenericTestUtils.waitFor(null, 0, 0);
        }
        catch (NullPointerException e) {
            TestGenericTestUtils.assertExceptionContains("Input supplier interface should be initailized", e);
        }
        Supplier<Boolean> simpleSupplier = new Supplier<Boolean>(){

            public Boolean get() {
                return true;
            }
        };
        TestGenericTestUtils.waitFor(simpleSupplier, 5, 10);
        try {
            TestGenericTestUtils.waitFor(simpleSupplier, 10, 5);
            Assert.fail((String)"Excepted a failure when the param value of waitForMillis is smaller than checkEveryMillis.");
        }
        catch (IllegalArgumentException e) {
            TestGenericTestUtils.assertExceptionContains("Total wait time should be greater than check interval time", e);
        }
    }

    @Test
    public void testToLevel() throws Throwable {
        Assert.assertEquals((Object)Level.INFO, (Object)TestGenericTestUtils.toLevel("INFO"));
        Assert.assertEquals((Object)Level.DEBUG, (Object)TestGenericTestUtils.toLevel("NonExistLevel"));
        Assert.assertEquals((Object)Level.INFO, (Object)TestGenericTestUtils.toLevel("INFO", Level.TRACE));
        Assert.assertEquals((Object)Level.TRACE, (Object)TestGenericTestUtils.toLevel("NonExistLevel", Level.TRACE));
    }

    private static class BrokenException
    extends Exception {
        @Override
        public String toString() {
            return null;
        }
    }
}

