/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWritableUtils
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestWritableUtils.class);

    public static void testValue(int val, int vintlen) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        DataInputBuffer inbuf = new DataInputBuffer();
        WritableUtils.writeVInt((DataOutput)buf, (int)val);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Value = " + val);
            BytesWritable printer = new BytesWritable();
            printer.set(buf.getData(), 0, buf.getLength());
            LOG.debug("Buffer = " + printer);
        }
        inbuf.reset(buf.getData(), 0, buf.getLength());
        TestWritableUtils.assertEquals((int)val, (int)WritableUtils.readVInt((DataInput)inbuf));
        TestWritableUtils.assertEquals((int)vintlen, (int)buf.getLength());
        TestWritableUtils.assertEquals((int)vintlen, (int)WritableUtils.getVIntSize((long)val));
        TestWritableUtils.assertEquals((int)vintlen, (int)WritableUtils.decodeVIntSize((byte)buf.getData()[0]));
    }

    public static void testReadInRange(long val, int lower, int upper, boolean expectSuccess) throws IOException {
        block3: {
            DataOutputBuffer buf = new DataOutputBuffer();
            DataInputBuffer inbuf = new DataInputBuffer();
            WritableUtils.writeVLong((DataOutput)buf, (long)val);
            try {
                inbuf.reset(buf.getData(), 0, buf.getLength());
                long val2 = WritableUtils.readVIntInRange((DataInput)inbuf, (int)lower, (int)upper);
                if (!expectSuccess) {
                    TestWritableUtils.fail((String)"expected readVIntInRange to throw an exception");
                }
                TestWritableUtils.assertEquals((long)val, (long)val2);
            }
            catch (IOException e) {
                if (!expectSuccess) break block3;
                LOG.error("unexpected exception:", (Throwable)e);
                TestWritableUtils.fail((String)"readVIntInRange threw an unexpected exception");
            }
        }
    }

    public static void testVInt() throws Exception {
        TestWritableUtils.testValue(12, 1);
        TestWritableUtils.testValue(127, 1);
        TestWritableUtils.testValue(-112, 1);
        TestWritableUtils.testValue(-113, 2);
        TestWritableUtils.testValue(-128, 2);
        TestWritableUtils.testValue(128, 2);
        TestWritableUtils.testValue(-129, 2);
        TestWritableUtils.testValue(255, 2);
        TestWritableUtils.testValue(-256, 2);
        TestWritableUtils.testValue(256, 3);
        TestWritableUtils.testValue(-257, 3);
        TestWritableUtils.testValue(65535, 3);
        TestWritableUtils.testValue(-65536, 3);
        TestWritableUtils.testValue(65536, 4);
        TestWritableUtils.testValue(-65537, 4);
        TestWritableUtils.testReadInRange(123L, 122, 123, true);
        TestWritableUtils.testReadInRange(123L, 0, 100, false);
        TestWritableUtils.testReadInRange(0L, 0, 100, true);
        TestWritableUtils.testReadInRange(-1L, 0, 100, false);
        TestWritableUtils.testReadInRange(0x10000000000L, 0, Integer.MAX_VALUE, false);
    }
}

