/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSSLHttpServer
extends HttpServerFunctionalTest {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSSLHttpServer.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(TestSSLHttpServer.class);
    private static Configuration conf;
    private static HttpServer2 server;
    private static String keystoresDir;
    private static String sslConfDir;
    private static SSLFactory clientSslFactory;
    private static final String excludeCiphers = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5";
    private static final String oneEnabledCiphers = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5,TLS_RSA_WITH_AES_128_CBC_SHA";
    private static final String exclusiveEnabledCiphers = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDH_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA";

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false, true, excludeCiphers);
        Configuration sslConf = new Configuration(false);
        sslConf.addResource("ssl-server.xml");
        sslConf.addResource("ssl-client.xml");
        clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, sslConf);
        clientSslFactory.init();
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list")).build();
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addServlet("longheader", "/longheader", HttpServerFunctionalTest.LongHeaderServlet.class);
        server.start();
        baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
        clientSslFactory.destroy();
    }

    @Test
    public void testEcho() throws Exception {
        TestSSLHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c=d")));
        TestSSLHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testLongHeader() throws Exception {
        URL url = new URL(baseUrl, "/longheader");
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        this.testLongHeader(conn);
    }

    private static String readOut(URL url) throws Exception {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        return out.toString();
    }

    @Test
    public void testExcludedCiphers() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
        PrefferedCipherSSLSocketFactory testPreferredCipherSSLSocketF = new PrefferedCipherSSLSocketFactory(sslSocketF, excludeCiphers.split(","));
        conn.setSSLSocketFactory(testPreferredCipherSSLSocketF);
        TestSSLHttpServer.assertFalse((String)"excludedCipher list is empty", (boolean)excludeCiphers.isEmpty());
        try {
            InputStream in = conn.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
            TestSSLHttpServer.fail((String)"No Ciphers in common, SSLHandshake must fail.");
        }
        catch (SSLHandshakeException ex) {
            LOG.info("No Ciphers in common, expected succesful test result.", (Throwable)ex);
        }
    }

    @Test
    public void testOneEnabledCiphers() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
        PrefferedCipherSSLSocketFactory testPreferredCipherSSLSocketF = new PrefferedCipherSSLSocketFactory(sslSocketF, oneEnabledCiphers.split(","));
        conn.setSSLSocketFactory(testPreferredCipherSSLSocketF);
        TestSSLHttpServer.assertFalse((String)"excludedCipher list is empty", (boolean)oneEnabledCiphers.isEmpty());
        try {
            InputStream in = conn.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
            TestSSLHttpServer.assertEquals((Object)out.toString(), (Object)"a:b\nc:d\n");
            LOG.info("Atleast one additional enabled cipher than excluded ciphers, expected successful test result.");
        }
        catch (SSLHandshakeException ex) {
            TestSSLHttpServer.fail((String)("Atleast one additional cipher available for successful handshake. Unexpected test failure: " + ex));
        }
    }

    @Test
    public void testExclusiveEnabledCiphers() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
        PrefferedCipherSSLSocketFactory testPreferredCipherSSLSocketF = new PrefferedCipherSSLSocketFactory(sslSocketF, exclusiveEnabledCiphers.split(","));
        conn.setSSLSocketFactory(testPreferredCipherSSLSocketF);
        TestSSLHttpServer.assertFalse((String)"excludedCipher list is empty", (boolean)exclusiveEnabledCiphers.isEmpty());
        try {
            InputStream in = conn.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
            TestSSLHttpServer.assertEquals((Object)out.toString(), (Object)"a:b\nc:d\n");
            LOG.info("Atleast one additional enabled cipher than excluded ciphers, expected successful test result.");
        }
        catch (SSLHandshakeException ex) {
            TestSSLHttpServer.fail((String)("Atleast one additional cipher available for successful handshake. Unexpected test failure: " + ex));
        }
    }

    private class PrefferedCipherSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegateSocketFactory;
        private final String[] enabledCipherSuites;

        public PrefferedCipherSSLSocketFactory(SSLSocketFactory sslSocketFactory, String[] pEnabledCipherSuites) {
            this.delegateSocketFactory = sslSocketFactory;
            this.enabledCipherSuites = null != pEnabledCipherSuites && pEnabledCipherSuites.length > 0 ? pEnabledCipherSuites : null;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegateSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegateSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(socket, string, i, bln);
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i);
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i, ia, i1);
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i);
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i, ia1, i1);
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return sslSocket;
        }
    }
}

