/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFs;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;

public class TestFilterFs
extends TestCase {
    private static final Logger LOG = FileSystem.LOG;

    public void testFilterFileSystem() throws Exception {
        for (Method m : AbstractFileSystem.class.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || Modifier.isFinal(m.getModifiers())) continue;
            try {
                DontCheck.class.getMethod(m.getName(), m.getParameterTypes());
                LOG.info("Skipping " + m);
            }
            catch (NoSuchMethodException exc) {
                LOG.info("Testing " + m);
                try {
                    FilterFs.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException exc2) {
                    LOG.error("FilterFileSystem doesn't implement " + m);
                    throw exc2;
                }
            }
        }
    }

    public static class DontCheck {
        public void checkScheme(URI uri, String supportedScheme) {
        }

        public Iterator<FileStatus> listStatusIterator(Path f) {
            return null;
        }

        public Iterator<LocatedFileStatus> listLocatedStatus(Path f) {
            return null;
        }
    }
}

