/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.eval;

import java.math.BigDecimal;
import java.math.MathContext;
import net.java.dev.eval.Type;

enum Operator {
    END(-1, 0, null, null, null){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            throw new IllegalArgumentException("END is a dummy operation");
        }
    }
    ,
    TERNARY(0, 3, "?", null, null){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 ? value2 : value3;
        }
    }
    ,
    AND(0, 2, "&&", Type.BOOLEAN, Type.BOOLEAN){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 && value2.signum() != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    OR(0, 2, "||", Type.BOOLEAN, Type.BOOLEAN){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() != 0 || value2.signum() != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    NOT(0, 1, "!", Type.BOOLEAN, Type.BOOLEAN){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.signum() == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    GT(1, 2, ">", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) > 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    GE(1, 2, ">=", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) >= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    LT(1, 2, "<", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) < 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    LE(1, 2, "<=", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) <= 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    EQ(1, 2, "==", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) == 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    NE(1, 2, "!=", Type.BOOLEAN, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.compareTo(value2) != 0 ? BigDecimal.ONE : BigDecimal.ZERO;
        }
    }
    ,
    ADD(2, 2, "+", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.add(value2);
        }
    }
    ,
    SUB(2, 2, "-", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.subtract(value2);
        }
    }
    ,
    DIV(3, 2, "/", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.divide(value2, MathContext.DECIMAL128);
        }
    }
    ,
    REMAINDER(3, 2, "%", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.remainder(value2, MathContext.DECIMAL128);
        }
    }
    ,
    MUL(3, 2, "*", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.multiply(value2);
        }
    }
    ,
    NEG(4, 1, "-", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.negate();
        }
    }
    ,
    PLUS(4, 1, "+", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1;
        }
    }
    ,
    ABS(4, 1, " abs ", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1.abs();
        }
    }
    ,
    POW(4, 2, " pow ", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            try {
                return value1.pow(value2.intValueExact());
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("pow argument: " + ae.getMessage());
            }
        }
    }
    ,
    INT(4, 1, "int ", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return new BigDecimal(value1.toBigInteger());
        }
    }
    ,
    NOP(4, 1, "", Type.ARITHMETIC, Type.ARITHMETIC){

        @Override
        BigDecimal perform(BigDecimal value1, BigDecimal value2, BigDecimal value3) {
            return value1;
        }
    };

    final int precedence;
    final int numberOfOperands;
    final String string;
    final Type resultType;
    final Type operandType;

    private Operator(int precedence, int numberOfOperands, String string2, Type resultType, Type operandType) {
        this.precedence = precedence;
        this.numberOfOperands = numberOfOperands;
        this.string = string2;
        this.resultType = resultType;
        this.operandType = operandType;
    }

    abstract BigDecimal perform(BigDecimal var1, BigDecimal var2, BigDecimal var3);
}

