/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.mapreduce.v2.api.HSAdminProtocol;
import org.apache.hadoop.mapreduce.v2.api.HSAdminRefreshProtocol;
import org.apache.hadoop.mapreduce.v2.api.HSAdminRefreshProtocolPB;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.ClientHSPolicyProvider;
import org.apache.hadoop.mapreduce.v2.hs.HSAuditLogger;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.proto.HSAdminRefreshProtocolProtos;
import org.apache.hadoop.mapreduce.v2.hs.protocolPB.HSAdminRefreshProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HSAdminServer
extends AbstractService
implements HSAdminProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(HSAdminServer.class);
    private AccessControlList adminAcl;
    private AggregatedLogDeletionService aggLogDelService = null;
    protected RPC.Server clientRpcServer;
    protected InetSocketAddress clientRpcAddress;
    private static final String HISTORY_ADMIN_SERVER = "HSAdminServer";
    private JobHistory jobHistoryService = null;
    private UserGroupInformation loginUGI;

    public HSAdminServer(AggregatedLogDeletionService aggLogDelService, JobHistory jobHistoryService) {
        super(HSAdminServer.class.getName());
        this.aggLogDelService = aggLogDelService;
        this.jobHistoryService = jobHistoryService;
    }

    public void serviceInit(Configuration conf) throws Exception {
        RPC.setProtocolEngine((Configuration)conf, RefreshUserMappingsProtocolPB.class, ProtobufRpcEngine.class);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB((RefreshUserMappingsProtocol)this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService((RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.BlockingInterface)refreshUserMappingXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB((GetUserMappingsProtocol)this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService((GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.BlockingInterface)getUserMappingXlator);
        HSAdminRefreshProtocolServerSideTranslatorPB refreshHSAdminProtocolXlator = new HSAdminRefreshProtocolServerSideTranslatorPB((HSAdminRefreshProtocol)this);
        BlockingService refreshHSAdminProtocolService = HSAdminRefreshProtocolProtos.HSAdminRefreshProtocolService.newReflectiveBlockingService((HSAdminRefreshProtocolProtos.HSAdminRefreshProtocolService.BlockingInterface)refreshHSAdminProtocolXlator);
        WritableRpcEngine.ensureInitialized();
        this.clientRpcAddress = conf.getSocketAddr("mapreduce.jobhistory.bind-host", "mapreduce.jobhistory.admin.address", "0.0.0.0:10033", 10033);
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(RefreshUserMappingsProtocolPB.class).setInstance((Object)refreshUserMappingService).setBindAddress(this.clientRpcAddress.getHostName()).setPort(this.clientRpcAddress.getPort()).setVerbose(false).build();
        this.addProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService);
        this.addProtocol(conf, HSAdminRefreshProtocolPB.class, refreshHSAdminProtocolService);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.clientRpcServer.refreshServiceAcl(conf, (PolicyProvider)new ClientHSPolicyProvider());
        }
        this.adminAcl = new AccessControlList(conf.get("mapreduce.jobhistory.admin.acl", "*"));
    }

    protected void serviceStart() throws Exception {
        this.loginUGI = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.getLoginUser() : UserGroupInformation.getCurrentUser();
        this.clientRpcServer.start();
    }

    @VisibleForTesting
    UserGroupInformation getLoginUGI() {
        return this.loginUGI;
    }

    @VisibleForTesting
    void setLoginUGI(UserGroupInformation ugi) {
        this.loginUGI = ugi;
    }

    protected void serviceStop() throws Exception {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
    }

    private void addProtocol(Configuration conf, Class<?> protocol, BlockingService blockingService) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        this.clientRpcServer.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)blockingService);
    }

    private UserGroupInformation checkAcls(String method) throws IOException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn("Couldn't get current user", (Throwable)ioe);
            HSAuditLogger.logFailure("UNKNOWN", method, this.adminAcl.toString(), HISTORY_ADMIN_SERVER, "Couldn't get current user");
            throw ioe;
        }
        if (!this.adminAcl.isUserAllowed(user)) {
            LOG.warn("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'");
            HSAuditLogger.logFailure(user.getShortUserName(), method, this.adminAcl.toString(), HISTORY_ADMIN_SERVER, "Unauthorized user");
            throw new AccessControlException("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'");
        }
        LOG.info("HS Admin: " + method + " invoked by user " + user.getShortUserName());
        return user;
    }

    public String[] getGroupsForUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public void refreshUserToGroupsMappings() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshUserToGroupsMappings");
        Groups.getUserToGroupsMappingService().refresh();
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshUserToGroupsMappings", HISTORY_ADMIN_SERVER);
    }

    public void refreshSuperUserGroupsConfiguration() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshSuperUserGroupsConfiguration");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.createConf());
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", HISTORY_ADMIN_SERVER);
    }

    protected Configuration createConf() {
        return new Configuration();
    }

    public void refreshAdminAcls() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshAdminAcls");
        Configuration conf = this.createConf();
        this.adminAcl = new AccessControlList(conf.get("mapreduce.jobhistory.admin.acl", "*"));
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshAdminAcls", HISTORY_ADMIN_SERVER);
    }

    public void refreshLoadedJobCache() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshLoadedJobCache");
        try {
            this.jobHistoryService.refreshLoadedJobCache();
        }
        catch (UnsupportedOperationException e) {
            HSAuditLogger.logFailure(user.getShortUserName(), "refreshLoadedJobCache", this.adminAcl.toString(), HISTORY_ADMIN_SERVER, e.getMessage());
            throw e;
        }
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshLoadedJobCache", HISTORY_ADMIN_SERVER);
    }

    public void refreshLogRetentionSettings() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshLogRetentionSettings");
        try {
            this.loginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    HSAdminServer.this.aggLogDelService.refreshLogRetentionSettings();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshLogRetentionSettings", HISTORY_ADMIN_SERVER);
    }

    public void refreshJobRetentionSettings() throws IOException {
        UserGroupInformation user = this.checkAcls("refreshJobRetentionSettings");
        try {
            this.loginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    HSAdminServer.this.jobHistoryService.refreshJobRetentionSettings();
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        HSAuditLogger.logSuccess(user.getShortUserName(), "refreshJobRetentionSettings", HISTORY_ADMIN_SERVER);
    }
}

