/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsParser {
    private static final Logger LOG = LoggerFactory.getLogger(OptionsParser.class);
    private static final Options cliOptions = new Options();

    public static DistCpOptions parse(String[] args) throws IllegalArgumentException {
        CommandLine command;
        CustomParser parser = new CustomParser();
        try {
            command = parser.parse(cliOptions, args, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse arguments. " + Arrays.toString(args), e);
        }
        DistCpOptions option = OptionsParser.parseSourceAndTargetPaths(command);
        if (command.hasOption(DistCpOptionSwitch.IGNORE_FAILURES.getSwitch())) {
            option.setIgnoreFailures(true);
        }
        if (command.hasOption(DistCpOptionSwitch.ATOMIC_COMMIT.getSwitch())) {
            option.setAtomicCommit(true);
        }
        if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch()) && option.shouldAtomicCommit()) {
            String workPath = OptionsParser.getVal(command, DistCpOptionSwitch.WORK_PATH.getSwitch());
            if (workPath != null && !workPath.isEmpty()) {
                option.setAtomicWorkPath(new Path(workPath));
            }
        } else if (command.hasOption(DistCpOptionSwitch.WORK_PATH.getSwitch())) {
            throw new IllegalArgumentException("-tmp work-path can only be specified along with -atomic");
        }
        if (command.hasOption(DistCpOptionSwitch.LOG_PATH.getSwitch())) {
            option.setLogPath(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.LOG_PATH.getSwitch())));
        }
        if (command.hasOption(DistCpOptionSwitch.SYNC_FOLDERS.getSwitch())) {
            option.setSyncFolder(true);
        }
        if (command.hasOption(DistCpOptionSwitch.OVERWRITE.getSwitch())) {
            option.setOverwrite(true);
        }
        if (command.hasOption(DistCpOptionSwitch.APPEND.getSwitch())) {
            option.setAppend(true);
        }
        if (command.hasOption(DistCpOptionSwitch.DELETE_MISSING.getSwitch())) {
            option.setDeleteMissing(true);
        }
        if (command.hasOption(DistCpOptionSwitch.SKIP_CRC.getSwitch())) {
            option.setSkipCRC(true);
        }
        if (command.hasOption(DistCpOptionSwitch.BLOCKING.getSwitch())) {
            option.setBlocking(false);
        }
        OptionsParser.parseBandwidth(command, option);
        if (command.hasOption(DistCpOptionSwitch.SSL_CONF.getSwitch())) {
            option.setSslConfigurationFile(command.getOptionValue(DistCpOptionSwitch.SSL_CONF.getSwitch()));
        }
        OptionsParser.parseNumListStatusThreads(command, option);
        OptionsParser.parseMaxMaps(command, option);
        if (command.hasOption(DistCpOptionSwitch.COPY_STRATEGY.getSwitch())) {
            option.setCopyStrategy(OptionsParser.getVal(command, DistCpOptionSwitch.COPY_STRATEGY.getSwitch()));
        }
        OptionsParser.parsePreserveStatus(command, option);
        if (command.hasOption(DistCpOptionSwitch.DIFF.getSwitch())) {
            String[] snapshots = OptionsParser.getVals(command, DistCpOptionSwitch.DIFF.getSwitch());
            Preconditions.checkArgument((snapshots != null && snapshots.length == 2 ? 1 : 0) != 0, (Object)"Must provide both the starting and ending snapshot names");
            option.setUseDiff(true, snapshots[0], snapshots[1]);
        }
        OptionsParser.parseFileLimit(command);
        OptionsParser.parseSizeLimit(command);
        if (command.hasOption(DistCpOptionSwitch.FILTERS.getSwitch())) {
            option.setFiltersFile(OptionsParser.getVal(command, DistCpOptionSwitch.FILTERS.getSwitch()));
        }
        return option;
    }

    private static void parseSizeLimit(CommandLine command) {
        if (command.hasOption(DistCpOptionSwitch.SIZE_LIMIT.getSwitch())) {
            String sizeLimitString = OptionsParser.getVal(command, DistCpOptionSwitch.SIZE_LIMIT.getSwitch().trim());
            try {
                Long.parseLong(sizeLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Size-limit is invalid: " + sizeLimitString, e);
            }
            LOG.warn(DistCpOptionSwitch.SIZE_LIMIT.getSwitch() + " is a deprecated option. Ignoring.");
        }
    }

    private static void parseFileLimit(CommandLine command) {
        if (command.hasOption(DistCpOptionSwitch.FILE_LIMIT.getSwitch())) {
            String fileLimitString = OptionsParser.getVal(command, DistCpOptionSwitch.FILE_LIMIT.getSwitch().trim());
            try {
                Integer.parseInt(fileLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("File-limit is invalid: " + fileLimitString, e);
            }
            LOG.warn(DistCpOptionSwitch.FILE_LIMIT.getSwitch() + " is a deprecated option. Ignoring.");
        }
    }

    private static void parsePreserveStatus(CommandLine command, DistCpOptions option) {
        block4: {
            if (!command.hasOption(DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) break block4;
            String attributes = OptionsParser.getVal(command, DistCpOptionSwitch.PRESERVE_STATUS.getSwitch());
            if (attributes == null || attributes.isEmpty()) {
                for (DistCpOptions.FileAttribute attribute : DistCpOptions.FileAttribute.values()) {
                    option.preserve(attribute);
                }
            } else {
                for (int index = 0; index < attributes.length(); ++index) {
                    option.preserve(DistCpOptions.FileAttribute.getAttribute(attributes.charAt(index)));
                }
            }
        }
    }

    private static void parseMaxMaps(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.MAX_MAPS.getSwitch())) {
            try {
                Integer maps = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()).trim());
                option.setMaxMaps(maps);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of maps is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.MAX_MAPS.getSwitch()), e);
            }
        }
    }

    private static void parseNumListStatusThreads(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch())) {
            try {
                Integer numThreads = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()).trim());
                option.setNumListstatusThreads(numThreads);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Number of liststatus threads is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.NUM_LISTSTATUS_THREADS.getSwitch()), e);
            }
        }
    }

    private static void parseBandwidth(CommandLine command, DistCpOptions option) {
        if (command.hasOption(DistCpOptionSwitch.BANDWIDTH.getSwitch())) {
            try {
                Integer mapBandwidth = Integer.parseInt(OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch()).trim());
                if (mapBandwidth <= 0) {
                    throw new IllegalArgumentException("Bandwidth specified is not positive: " + mapBandwidth);
                }
                option.setMapBandwidth(mapBandwidth);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bandwidth specified is invalid: " + OptionsParser.getVal(command, DistCpOptionSwitch.BANDWIDTH.getSwitch()), e);
            }
        }
    }

    private static DistCpOptions parseSourceAndTargetPaths(CommandLine command) {
        DistCpOptions option;
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        String[] leftOverArgs = command.getArgs();
        if (leftOverArgs == null || leftOverArgs.length < 1) {
            throw new IllegalArgumentException("Target path not specified");
        }
        Path targetPath = new Path(leftOverArgs[leftOverArgs.length - 1].trim());
        for (int index = 0; index < leftOverArgs.length - 1; ++index) {
            sourcePaths.add(new Path(leftOverArgs[index].trim()));
        }
        if (command.hasOption(DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())) {
            if (!sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Both source file listing and source paths present");
            }
            option = new DistCpOptions(new Path(OptionsParser.getVal(command, DistCpOptionSwitch.SOURCE_FILE_LISTING.getSwitch())), targetPath);
        } else {
            if (sourcePaths.isEmpty()) {
                throw new IllegalArgumentException("Neither source file listing nor source paths present");
            }
            option = new DistCpOptions(sourcePaths, targetPath);
        }
        if (command.hasOption(DistCpOptionSwitch.MIN_FILE_SIZE.getSwitch())) {
            String minFileSizeString = OptionsParser.getVal(command, DistCpOptionSwitch.MIN_FILE_SIZE.getSwitch().trim());
            try {
                option.setMinFileSize(Long.parseLong(minFileSizeString));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Minimum file size is invalid: " + minFileSizeString, e);
            }
        }
        if (command.hasOption(DistCpOptionSwitch.MAX_FILE_SIZE.getSwitch())) {
            String maxFileSizeString = OptionsParser.getVal(command, DistCpOptionSwitch.MAX_FILE_SIZE.getSwitch().trim());
            try {
                long maxFileSize = Long.parseLong(maxFileSizeString);
                if (maxFileSize <= 0L) {
                    throw new IllegalArgumentException("Maximum file size should be positive");
                }
                option.setMaxFileSize(maxFileSize);
                if (maxFileSize < option.getMinFileSize()) {
                    throw new IllegalArgumentException("Maximum file size cannot be less than minimum file size: " + option.getMinFileSize());
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Maximum file size is invalid: " + maxFileSizeString, e);
            }
        }
        OptionsParser.parseBlocksPerChunk(command, option);
        return option;
    }

    private static void parseBlocksPerChunk(CommandLine command, DistCpOptions option) {
        boolean hasOption = command.hasOption(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch());
        LOG.info("parseChunkSize: " + DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " " + hasOption);
        if (hasOption) {
            String chunkSizeString = OptionsParser.getVal(command, DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch().trim());
            try {
                int csize = Integer.parseInt(chunkSizeString);
                if (csize < 0) {
                    csize = 0;
                }
                LOG.info("Set distcp blocksPerChunk to " + csize);
                option.setBlocksPerChunk(csize);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("blocksPerChunk is invalid: " + chunkSizeString, e);
            }
        }
    }

    private static String getVal(CommandLine command, String swtch) {
        String optionValue = command.getOptionValue(swtch);
        if (optionValue == null) {
            return null;
        }
        return optionValue.trim();
    }

    private static String[] getVals(CommandLine command, String option) {
        return command.getOptionValues(option);
    }

    public static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("distcp OPTIONS [source_path...] <target_path>\n\nOPTIONS", cliOptions);
    }

    static {
        for (DistCpOptionSwitch option : DistCpOptionSwitch.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding option " + option.getOption());
            }
            cliOptions.addOption(option.getOption());
        }
    }

    private static class CustomParser
    extends GnuParser {
        private CustomParser() {
        }

        protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
            for (int index = 0; index < arguments.length; ++index) {
                if (!arguments[index].equals("-" + DistCpOptionSwitch.PRESERVE_STATUS.getSwitch())) continue;
                arguments[index] = "-prbugpcte";
            }
            return super.flatten(options, arguments, stopAtNonOption);
        }
    }
}

