/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ReservationQueueConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AllocationFileLoaderService
extends AbstractService {
    public static final Logger LOG = LoggerFactory.getLogger((String)AllocationFileLoaderService.class.getName());
    public static final long ALLOC_RELOAD_INTERVAL_MS = 10000L;
    public static final long ALLOC_RELOAD_WAIT_MS = 5000L;
    public static final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private final Clock clock;
    private long lastSuccessfulReload;
    private boolean lastReloadAttemptFailed = false;
    private File allocFile;
    private Listener reloadListener;
    @VisibleForTesting
    long reloadIntervalMs = 10000L;
    private Thread reloadThread;
    private volatile boolean running = true;

    public AllocationFileLoaderService() {
        this((Clock)new SystemClock());
    }

    public AllocationFileLoaderService(Clock clock) {
        super(AllocationFileLoaderService.class.getName());
        this.clock = clock;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.allocFile = this.getAllocationFile(conf);
        if (this.allocFile != null) {
            this.reloadThread = new Thread(){

                @Override
                public void run() {
                    while (AllocationFileLoaderService.this.running) {
                        long time = AllocationFileLoaderService.this.clock.getTime();
                        long lastModified = AllocationFileLoaderService.this.allocFile.lastModified();
                        if (lastModified > AllocationFileLoaderService.this.lastSuccessfulReload && time > lastModified + 5000L) {
                            try {
                                AllocationFileLoaderService.this.reloadAllocations();
                            }
                            catch (Exception ex) {
                                if (!AllocationFileLoaderService.this.lastReloadAttemptFailed) {
                                    LOG.error("Failed to reload fair scheduler config file - will use existing allocations.", (Throwable)ex);
                                }
                                AllocationFileLoaderService.this.lastReloadAttemptFailed = true;
                            }
                        } else if (lastModified == 0L) {
                            if (!AllocationFileLoaderService.this.lastReloadAttemptFailed) {
                                LOG.warn("Failed to reload fair scheduler config file because last modified returned 0. File exists: " + AllocationFileLoaderService.this.allocFile.exists());
                            }
                            AllocationFileLoaderService.this.lastReloadAttemptFailed = true;
                        }
                        try {
                            Thread.sleep(AllocationFileLoaderService.this.reloadIntervalMs);
                        }
                        catch (InterruptedException ex) {
                            LOG.info("Interrupted while waiting to reload alloc configuration");
                        }
                    }
                }
            };
            this.reloadThread.setName("AllocationFileReloader");
            this.reloadThread.setDaemon(true);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (this.reloadThread != null) {
            this.reloadThread.start();
        }
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.running = false;
        if (this.reloadThread != null) {
            this.reloadThread.interrupt();
            try {
                this.reloadThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("reloadThread fails to join.");
            }
        }
        super.serviceStop();
    }

    public File getAllocationFile(Configuration conf) {
        String allocFilePath = conf.get("yarn.scheduler.fair.allocation.file", "fair-scheduler.xml");
        File allocFile = new File(allocFilePath);
        if (!allocFile.isAbsolute()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(allocFilePath);
            if (url == null) {
                LOG.warn(allocFilePath + " not found on the classpath.");
                allocFile = null;
            } else {
                if (!url.getProtocol().equalsIgnoreCase("file")) {
                    throw new RuntimeException("Allocation file " + url + " found on the classpath is not on the local filesystem.");
                }
                allocFile = new File(url.getPath());
            }
        }
        return allocFile;
    }

    public synchronized void setReloadListener(Listener reloadListener) {
        this.reloadListener = reloadListener;
    }

    public synchronized void reloadAllocations() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            return;
        }
        LOG.info("Loading allocation file " + this.allocFile);
        HashMap<String, Resource> minQueueResources = new HashMap<String, Resource>();
        HashMap<String, Resource> maxQueueResources = new HashMap<String, Resource>();
        HashMap<String, Resource> maxContainerAllocations = new HashMap<String, Resource>();
        HashMap<String, Integer> queueMaxApps = new HashMap<String, Integer>();
        HashMap<String, Integer> userMaxApps = new HashMap<String, Integer>();
        HashMap<String, Float> queueMaxAMShares = new HashMap<String, Float>();
        HashMap<String, ResourceWeights> queueWeights = new HashMap<String, ResourceWeights>();
        HashMap<String, SchedulingPolicy> queuePolicies = new HashMap<String, SchedulingPolicy>();
        HashMap<String, Long> minSharePreemptionTimeouts = new HashMap<String, Long>();
        HashMap<String, String> queueLabels = new HashMap<String, String>();
        HashMap<String, Queue.QueueLabelPolicy> queueLabelPolicies = new HashMap<String, Queue.QueueLabelPolicy>();
        String defaultQueueLabel = null;
        HashMap<String, Long> fairSharePreemptionTimeouts = new HashMap<String, Long>();
        HashMap<String, Float> fairSharePreemptionThresholds = new HashMap<String, Float>();
        HashMap<String, Map<QueueACL, AccessControlList>> queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        HashSet<String> reservableQueues = new HashSet<String>();
        int userMaxAppsDefault = Integer.MAX_VALUE;
        int queueMaxAppsDefault = Integer.MAX_VALUE;
        float queueMaxAMShareDefault = 0.5f;
        long defaultFairSharePreemptionTimeout = Long.MAX_VALUE;
        long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        float defaultFairSharePreemptionThreshold = 0.5f;
        SchedulingPolicy defaultSchedPolicy = SchedulingPolicy.DEFAULT_POLICY;
        String planner = null;
        String reservationAgent = null;
        String reservationAdmissionPolicy = null;
        QueuePlacementPolicy newPlacementPolicy = null;
        HashMap<FSQueueType, Set<String>> configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            configuredQueues.put(queueType, new HashSet());
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(this.allocFile);
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        ArrayList<Element> queueElements = new ArrayList<Element>();
        Element placementPolicyElement = null;
        for (int i = 0; i < elements.getLength(); ++i) {
            String text;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("queue".equals(element.getTagName()) || "pool".equals(element.getTagName())) {
                queueElements.add(element);
                continue;
            }
            if ("user".equals(element.getTagName())) {
                String userName = element.getAttribute("name");
                NodeList fields = element.getChildNodes();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Element field;
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element) || !"maxRunningApps".equals((field = (Element)fieldNode).getTagName())) continue;
                    String text2 = ((Text)field.getFirstChild()).getData().trim();
                    int val = Integer.parseInt(text2);
                    userMaxApps.put(userName, val);
                }
                continue;
            }
            if ("userMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                userMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("defaultFairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultFairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                if (defaultFairSharePreemptionTimeout != Long.MAX_VALUE) continue;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultFairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultMinSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultMinSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultFairSharePreemptionThreshold".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                defaultFairSharePreemptionThreshold = val = Math.max(Math.min(val, 1.0f), 0.0f);
                continue;
            }
            if ("queueMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                queueMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("queueMaxAMShareDefault".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                queueMaxAMShareDefault = val = Math.min(val, 1.0f);
                continue;
            }
            if ("defaultQueueSchedulingPolicy".equals(element.getTagName()) || "defaultQueueSchedulingMode".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultSchedPolicy = SchedulingPolicy.parse(text);
                continue;
            }
            if ("queuePlacementPolicy".equals(element.getTagName())) {
                placementPolicyElement = element;
                continue;
            }
            if ("reservation-planner".equals(element.getTagName())) {
                planner = text = ((Text)element.getFirstChild()).getData().trim();
                continue;
            }
            if ("reservation-agent".equals(element.getTagName())) {
                reservationAgent = text = ((Text)element.getFirstChild()).getData().trim();
                continue;
            }
            if ("reservation-policy".equals(element.getTagName())) {
                reservationAdmissionPolicy = text = ((Text)element.getFirstChild()).getData().trim();
                continue;
            }
            if ("defaultQueueLabel".equals(element.getTagName())) {
                defaultQueueLabel = text = ((Text)element.getFirstChild()).getData().trim();
                continue;
            }
            LOG.warn("Bad element in allocations file: " + element.getTagName());
        }
        for (Element element : queueElements) {
            String parent = "root";
            if (element.getAttribute("name").equalsIgnoreCase("root")) {
                if (queueElements.size() > 1) {
                    throw new AllocationConfigurationException("If configuring root queue, no other queues can be placed alongside it.");
                }
                parent = null;
            }
            this.loadQueue(parent, element, minQueueResources, maxQueueResources, maxContainerAllocations, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, configuredQueues, reservableQueues, queueLabels, queueLabelPolicies);
        }
        Configuration conf = this.getConfig();
        newPlacementPolicy = placementPolicyElement != null ? QueuePlacementPolicy.fromXml(placementPolicyElement, configuredQueues, conf) : QueuePlacementPolicy.fromConfiguration(conf, configuredQueues);
        if (!minSharePreemptionTimeouts.containsKey("root")) {
            minSharePreemptionTimeouts.put("root", defaultMinSharePreemptionTimeout);
        }
        if (!fairSharePreemptionTimeouts.containsKey("root")) {
            fairSharePreemptionTimeouts.put("root", defaultFairSharePreemptionTimeout);
        }
        if (!fairSharePreemptionThresholds.containsKey("root")) {
            fairSharePreemptionThresholds.put("root", Float.valueOf(defaultFairSharePreemptionThreshold));
        }
        ReservationQueueConfiguration globalReservationQueueConfig = new ReservationQueueConfiguration();
        if (planner != null) {
            globalReservationQueueConfig.setPlanner(planner);
        }
        if (reservationAdmissionPolicy != null) {
            globalReservationQueueConfig.setReservationAdmissionPolicy(reservationAdmissionPolicy);
        }
        if (reservationAgent != null) {
            globalReservationQueueConfig.setReservationAgent(reservationAgent);
        }
        AllocationConfiguration info = new AllocationConfiguration(minQueueResources, maxQueueResources, maxContainerAllocations, queueMaxApps, userMaxApps, queueWeights, queueMaxAMShares, userMaxAppsDefault, queueMaxAppsDefault, queueMaxAMShareDefault, queuePolicies, defaultSchedPolicy, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, newPlacementPolicy, configuredQueues, globalReservationQueueConfig, reservableQueues, queueLabels, queueLabelPolicies, defaultQueueLabel);
        this.lastSuccessfulReload = this.clock.getTime();
        this.lastReloadAttemptFailed = false;
        this.reloadListener.onReload(info);
    }

    private void loadQueue(String parentName, Element element, Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Resource> maxContainerAllocations, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, Float> queueMaxAMShares, Map<String, ResourceWeights> queueWeights, Map<String, SchedulingPolicy> queuePolicies, Map<String, Long> minSharePreemptionTimeouts, Map<String, Long> fairSharePreemptionTimeouts, Map<String, Float> fairSharePreemptionThresholds, Map<String, Map<QueueACL, AccessControlList>> queueAcls, Map<FSQueueType, Set<String>> configuredQueues, Set<String> reservableQueues, Map<String, String> queueLabels, Map<String, Queue.QueueLabelPolicy> queueLabelPolicies) throws AllocationConfigurationException {
        Object queueName = element.getAttribute("name").trim();
        if (((String)queueName).contains(".")) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: queue name (" + (String)queueName + ") shouldn't contain period.");
        }
        if (parentName != null) {
            queueName = parentName + "." + (String)queueName;
        }
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        NodeList fields = element.getChildNodes();
        boolean isLeaf = true;
        boolean isReservable = false;
        for (int j = 0; j < fields.getLength(); ++j) {
            String text;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if ("minResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                minQueueResources.put((String)queueName, val);
                continue;
            }
            if ("maxResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                maxQueueResources.put((String)queueName, val);
                continue;
            }
            if ("maxContainerAllocation".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue(text);
                maxContainerAllocations.put((String)queueName, val);
                continue;
            }
            if ("maxRunningApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                queueMaxApps.put((String)queueName, val);
                continue;
            }
            if ("maxAMShare".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                val = Math.min(val, 1.0f);
                queueMaxAMShares.put((String)queueName, Float.valueOf(val));
                continue;
            }
            if ("weight".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                double val = Double.parseDouble(text);
                queueWeights.put((String)queueName, new ResourceWeights((float)val));
                continue;
            }
            if ("minSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                minSharePreemptionTimeouts.put((String)queueName, val);
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                fairSharePreemptionTimeouts.put((String)queueName, val);
                continue;
            }
            if ("fairSharePreemptionThreshold".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                val = Math.max(Math.min(val, 1.0f), 0.0f);
                fairSharePreemptionThresholds.put((String)queueName, Float.valueOf(val));
                continue;
            }
            if ("schedulingPolicy".equals(field.getTagName()) || "schedulingMode".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                SchedulingPolicy policy = SchedulingPolicy.parse(text);
                queuePolicies.put((String)queueName, policy);
                continue;
            }
            if ("aclSubmitApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList(text));
                continue;
            }
            if ("aclAdministerApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList(text));
                continue;
            }
            if ("reservation".equals(field.getTagName())) {
                isReservable = true;
                reservableQueues.add((String)queueName);
                configuredQueues.get((Object)FSQueueType.PARENT).add((String)queueName);
                continue;
            }
            if ("label".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                queueLabels.put((String)queueName, text);
                continue;
            }
            if ("labelPolicy".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                try {
                    Queue.QueueLabelPolicy policy = Queue.QueueLabelPolicy.valueOf(text);
                    queueLabelPolicies.put((String)queueName, policy);
                }
                catch (IllegalArgumentException ie) {
                    LOG.warn("Unknown Label Policy: " + text);
                }
                continue;
            }
            if (!"queue".endsWith(field.getTagName()) && !"pool".equals(field.getTagName())) continue;
            this.loadQueue((String)queueName, field, minQueueResources, maxQueueResources, maxContainerAllocations, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, fairSharePreemptionTimeouts, fairSharePreemptionThresholds, queueAcls, configuredQueues, reservableQueues, queueLabels, queueLabelPolicies);
            isLeaf = false;
        }
        if (isLeaf && !"parent".equals(element.getAttribute("type"))) {
            configuredQueues.get((Object)FSQueueType.LEAF).add((String)queueName);
        } else {
            if (isReservable) {
                throw new AllocationConfigurationException("The configuration settings for " + (String)queueName + " are invalid. A queue element that contains child queue elements or that has the type='parent' attribute cannot also include a reservation element.");
            }
            configuredQueues.get((Object)FSQueueType.PARENT).add((String)queueName);
        }
        queueAcls.put((String)queueName, acls);
        if (maxQueueResources.containsKey(queueName) && minQueueResources.containsKey(queueName) && !Resources.fitsIn((Resource)minQueueResources.get(queueName), (Resource)maxQueueResources.get(queueName))) {
            LOG.warn(String.format("Queue %s has max resources %s less than min resources %s", queueName, maxQueueResources.get(queueName), minQueueResources.get(queueName)));
        }
    }

    public static interface Listener {
        public void onReload(AllocationConfiguration var1);
    }
}

