/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.java.dev.eval.Expression;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Logger LOG = LoggerFactory.getLogger(AppSchedulingInfo.class);
    private final ApplicationAttemptId applicationAttemptId;
    final ApplicationId applicationId;
    private String queueName;
    Queue queue;
    private Expression appLabelExpression;
    private final AtomicBoolean isAppLabelExpressionSet = new AtomicBoolean(false);
    private String applicationLabel;
    final String user;
    private final AtomicLong containerIdCounter;
    private final int EPOCH_BIT_SHIFT = 40;
    final Set<Priority> priorities = new TreeSet<Priority>(new Priority.Comparator());
    final Map<Priority, Map<String, ResourceRequest>> requests = new ConcurrentHashMap<Priority, Map<String, ResourceRequest>>();
    private Set<String> blacklist = new HashSet<String>();
    private ActiveUsersManager activeUsersManager;
    boolean pending = true;
    private AtomicBoolean userBlacklistChanged = new AtomicBoolean(false);

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, long epoch) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.queueName = queue.getQueueName();
        this.user = user;
        this.activeUsersManager = activeUsersManager;
        this.containerIdCounter = new AtomicLong(epoch << 40);
    }

    public void setApplicationLabel(String applicationLabel) {
        this.applicationLabel = applicationLabel;
    }

    public String getApplicationLabel() {
        return this.applicationLabel;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized boolean isPending() {
        return this.pending;
    }

    private synchronized void clearRequests() {
        this.priorities.clear();
        this.requests.clear();
        LOG.info("Application " + this.applicationId + " requests cleared");
    }

    public long getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests, boolean recoverPreemptedRequest) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (ResourceRequest request : requests) {
            Map<String, ResourceRequest> asks;
            Priority priority = request.getPriority();
            String resourceName = request.getResourceName();
            boolean updatePendingResources = false;
            ResourceRequest lastRequest = null;
            if (resourceName.equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("update: application=" + this.applicationId + " request=" + request);
                }
                updatePendingResources = true;
                if (request.getNumContainers() > 0) {
                    this.activeUsersManager.activateApplication(this.user, this.applicationId);
                }
            }
            if ((asks = this.requests.get(priority)) == null) {
                asks = new ConcurrentHashMap<String, ResourceRequest>();
                this.requests.put(priority, asks);
                this.priorities.add(priority);
            }
            lastRequest = asks.get(resourceName);
            if (recoverPreemptedRequest && lastRequest != null) {
                request.setNumContainers(lastRequest.getNumContainers() + 1);
            }
            asks.put(resourceName, request);
            if (!updatePendingResources) continue;
            if (request.getNumContainers() <= 0) {
                LOG.info("checking for deactivate of application :" + this.applicationId);
                this.checkForDeactivation();
            }
            int lastRequestContainers = lastRequest != null ? lastRequest.getNumContainers() : 0;
            Resource lastRequestCapability = lastRequest != null ? lastRequest.getCapability() : Resources.none();
            metrics.incrPendingResources(this.user, request.getNumContainers(), request.getCapability());
            metrics.decrPendingResources(this.user, lastRequestContainers, lastRequestCapability);
        }
    }

    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        boolean changed = false;
        if (blacklistAdditions != null) {
            changed = this.blacklist.addAll(blacklistAdditions);
        }
        if (blacklistRemovals != null && this.blacklist.removeAll(blacklistRemovals)) {
            changed = true;
        }
        if (changed) {
            this.userBlacklistChanged.set(true);
        }
    }

    public boolean getAndResetBlacklistChanged() {
        return this.userBlacklistChanged.getAndSet(false);
    }

    public synchronized Collection<Priority> getPriorities() {
        return this.priorities;
    }

    public synchronized Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.requests.get(priority);
    }

    public List<ResourceRequest> getAllResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        for (Map<String, ResourceRequest> r : this.requests.values()) {
            ret.addAll(r.values());
        }
        return ret;
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        Map<String, ResourceRequest> nodeRequests = this.requests.get(priority);
        return nodeRequests == null ? null : nodeRequests.get(resourceName);
    }

    public synchronized Resource getResource(Priority priority) {
        ResourceRequest request = this.getResourceRequest(priority, "*");
        return request == null ? null : request.getCapability();
    }

    public boolean isBlacklisted(SchedulerNode node, Logger myLog) {
        if (this.isBlacklisted(node.getNodeName()) || this.isBlackListedBasedOnLabels(node.getNodeName())) {
            if (myLog.isDebugEnabled()) {
                myLog.debug("Skipping 'host' " + node.getNodeName() + " for " + this.applicationId + " since it has been blacklisted");
            }
            return true;
        }
        if (this.isBlacklisted(node.getRackName())) {
            if (myLog.isDebugEnabled()) {
                myLog.debug("Skipping 'rack' " + node.getRackName() + " for " + this.applicationId + " since it has been blacklisted");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean isBlacklisted(String resourceName) {
        return this.blacklist.contains(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBlackListedBasedOnLabels(String resourceName) {
        Priority priority;
        LabelManager lb = LabelManager.getInstance();
        if (!lb.isServiceEnabled()) {
            return false;
        }
        AppSchedulingInfo appSchedulingInfo = this;
        synchronized (appSchedulingInfo) {
            if (this.priorities.contains(RMAppAttemptImpl.AM_CONTAINER_PRIORITY)) {
                priority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY;
            } else if (this.priorities.iterator().hasNext()) {
                priority = this.priorities.iterator().next();
            } else {
                LOG.trace("priorities is empty. Marking resource as not blacklisted");
                return false;
            }
        }
        ResourceRequest req = this.getResourceRequest(priority, resourceName);
        if (req == null) {
            req = this.getResourceRequest(priority, "*");
        }
        if (req != null) {
            try {
                Expression.fillEmptyValues = true;
                if (!this.isAppLabelExpressionSet.get()) {
                    String labelExp = req.getLabel();
                    String requestLabel = labelExp == null || labelExp.trim().isEmpty() ? this.applicationLabel : labelExp;
                    this.appLabelExpression = lb.getEffectiveLabelExpr(requestLabel);
                    this.isAppLabelExpressionSet.set(true);
                }
                Expression finalExp = lb.constructAppLabel(this.queue.getLabelPolicy(), this.appLabelExpression, this.queue.getLabel());
                LabelManager.LabelApplicabilityStatus blackListStatus = lb.isNodeApplicableForApp(resourceName, finalExp);
                switch (blackListStatus) {
                    case NOT_APPLICABLE: 
                    case NODE_HAS_LABEL: {
                        return false;
                    }
                    case NODE_DOES_NOT_HAVE_LABEL: {
                        return true;
                    }
                }
                return false;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception while trying to evaluate label expressions", (Throwable)e);
                }
                return false;
            }
        }
        return false;
    }

    public synchronized List<ResourceRequest> allocate(NodeType type, SchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        ArrayList<ResourceRequest> resourceRequests = new ArrayList<ResourceRequest>();
        if (type == NodeType.NODE_LOCAL) {
            this.allocateNodeLocal(node, priority, request, container, resourceRequests);
        } else if (type == NodeType.RACK_LOCAL) {
            this.allocateRackLocal(node, priority, request, container, resourceRequests);
        } else {
            this.allocateOffSwitch(node, priority, request, container, resourceRequests);
        }
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("allocate: applicationId=" + this.applicationId + " container=" + container.getId() + " host=" + container.getNodeId().toString() + " user=" + this.user + " resource=" + request.getCapability());
        }
        metrics.allocateResources(this.user, 1, request.getCapability(), true);
        return resourceRequests;
    }

    private synchronized void allocateNodeLocal(SchedulerNode node, Priority priority, ResourceRequest nodeLocalRequest, Container container, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getNodeName(), priority, nodeLocalRequest);
        ResourceRequest rackLocalRequest = this.requests.get(priority).get(node.getRackName());
        this.decResourceRequest(node.getRackName(), priority, rackLocalRequest);
        ResourceRequest offRackRequest = this.requests.get(priority).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(nodeLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private void decResourceRequest(String resourceName, Priority priority, ResourceRequest request) {
        request.setNumContainers(request.getNumContainers() - 1);
        if (request.getNumContainers() == 0) {
            this.requests.get(priority).remove(resourceName);
        }
    }

    private synchronized void allocateRackLocal(SchedulerNode node, Priority priority, ResourceRequest rackLocalRequest, Container container, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getRackName(), priority, rackLocalRequest);
        ResourceRequest offRackRequest = this.requests.get(priority).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private synchronized void allocateOffSwitch(SchedulerNode node, Priority priority, ResourceRequest offSwitchRequest, Container container, List<ResourceRequest> resourceRequests) {
        this.decrementOutstanding(offSwitchRequest);
        resourceRequests.add(this.cloneResourceRequest(offSwitchRequest));
    }

    private synchronized void decrementOutstanding(ResourceRequest offSwitchRequest) {
        int numOffSwitchContainers = offSwitchRequest.getNumContainers() - 1;
        offSwitchRequest.setNumContainers(numOffSwitchContainers);
        if (numOffSwitchContainers == 0) {
            this.checkForDeactivation();
        }
    }

    private synchronized void checkForDeactivation() {
        boolean deactivate = true;
        for (Priority priority : this.getPriorities()) {
            ResourceRequest request = this.getResourceRequest(priority, "*");
            if (request == null || request.getNumContainers() <= 0) continue;
            deactivate = false;
            break;
        }
        if (deactivate) {
            this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    public synchronized void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        for (Map<String, ResourceRequest> asks : this.requests.values()) {
            ResourceRequest request = asks.get("*");
            if (request == null) continue;
            oldMetrics.decrPendingResources(this.user, request.getNumContainers(), request.getCapability());
            newMetrics.incrPendingResources(this.user, request.getNumContainers(), request.getCapability());
        }
        oldMetrics.moveAppFrom(this);
        newMetrics.moveAppTo(this);
        this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        this.activeUsersManager = newQueue.getActiveUsersManager();
        this.activeUsersManager.activateApplication(this.user, this.applicationId);
        this.queue = newQueue;
        this.queueName = newQueue.getQueueName();
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        QueueMetrics metrics = this.queue.getMetrics();
        for (Map<String, ResourceRequest> asks : this.requests.values()) {
            ResourceRequest request = asks.get("*");
            if (request == null) continue;
            metrics.decrPendingResources(this.user, request.getNumContainers(), request.getCapability());
        }
        metrics.finishAppAttempt(this.applicationId, this.pending, this.user);
        this.clearRequests();
    }

    public synchronized void setQueue(Queue queue) {
        this.queue = queue;
    }

    public synchronized Set<String> getBlackList() {
        return this.blacklist;
    }

    public synchronized void transferStateFromPreviousAppSchedulingInfo(AppSchedulingInfo appInfo) {
        this.blacklist = appInfo.getBlackList();
    }

    public synchronized void recoverContainer(RMContainer rmContainer) {
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        metrics.allocateResources(this.user, 1, rmContainer.getAllocatedResource(), false);
    }

    public ResourceRequest cloneResourceRequest(ResourceRequest request) {
        ResourceRequest newRequest = ResourceRequest.newInstance((Priority)request.getPriority(), (String)request.getResourceName(), (Resource)request.getCapability(), (int)1, (boolean)request.getRelaxLocality());
        return newRequest;
    }
}

