/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.MismatchedUserException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class NoOverCommitPolicy
implements SharingPolicy {
    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        ReservationAllocation oldReservation = plan.getReservationById(reservation.getReservationId());
        if (oldReservation != null && !oldReservation.getUser().equals(reservation.getUser())) {
            throw new MismatchedUserException("Updating an existing reservation with mismatching user:" + oldReservation.getUser() + " != " + reservation.getUser());
        }
        long startTime = reservation.getStartTime();
        long endTime = reservation.getEndTime();
        long step = plan.getStep();
        for (long t = startTime; t < endTime; t += step) {
            Resource currExistingAllocTot = plan.getTotalCommittedResources(t);
            Resource currNewAlloc = reservation.getResourcesAtTime(t);
            Resource currOldAlloc = Resource.newInstance((int)0, (int)0);
            if (oldReservation != null) {
                oldReservation.getResourcesAtTime(t);
            }
            if (!Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)plan.getTotalCapacity(), (Resource)Resources.subtract((Resource)Resources.add((Resource)currExistingAllocTot, (Resource)currNewAlloc), (Resource)currOldAlloc), (Resource)plan.getTotalCapacity())) continue;
            throw new ResourceOverCommitException("Resources at time " + t + " would be overcommitted by accepting reservation: " + reservation.getReservationId());
        }
    }

    @Override
    public long getValidWindow() {
        return 0L;
    }

    @Override
    public void init(String planQueuePath, ReservationSchedulerConfiguration conf) {
    }
}

